#include <stdio.h>
#include "Graph.h"

// ʱ־
typedef enum {
    UnVisited, // δ
    Visited,   // ѷ
    InPath,    // ·
} FLAG;

// ʱ־飬¼ʹĶ
static FLAG flags[MAX_VERTEX_NUM];


/*
 * ҳͼеĻ·
 */
void Algo_7_25(Graph G);

/*
 * start㿪ʼһ·
 *
 * path洢·Ķ㣬path[0]洢pathеĶ
 *
 * ҵ·ػ·ʼţ
 * ûҵ·򷵻-1
 */
int Circuit_7_25(Graph G, int start, int path[MAX_VERTEX_NUM + 1]);


int main(int argc, char* argv[]) {
    Graph G;
    
    printf(" ͼ...\n");
    {
        char* path = "TestData_DG.txt";
        
        CreateGraph(&G, path);
        PrintGraph(G);
        printf("\n");
    }
    
    printf(" ͼеĻ·...\n");
    {
        Algo_7_25(G);
        printf("\n");
    }
    
    return 0;
}


/*
 * ҳͼеĻ·
 */
void Algo_7_25(Graph G) {
    int i, w = -1;
    int path[MAX_VERTEX_NUM + 1]; // 0ŵԪ¼pathд洢Ķ
    
    // жΪδ
    for(i = 0; i < G.vexnum; i++) {
        flags[i] = UnVisited;
    }
    
    path[0] = 0;
    
    for(i = 0; i < G.vexnum; i++) {
        w = Circuit_7_25(G, i, path);
        
        if(w != -1) {
            break;  // ҵһ·ѭ
        }
    }
    
    if(w == -1) {
        printf("ͼвڻ·\n");
        return;
    }
    
    printf("ͼҵ·Ϊ");
    for(i = 1; path[i] != w; i++) {
        // Ѱһ·
    }
    // ҵ˻·
    if(path[i] == w) {
        while(i <= path[0]) {
            printf("%c -> ", G.vexs[path[i]]);
            i++;
        }
        printf("%c\n", G.vexs[w]);
    }
}

/*
 * start㿪ʼһ·
 *
 * path洢·Ķ㣬path[0]洢pathеĶ
 *
 * ҵ·ػ·ʼţ
 * ûҵ·򷵻-1
 */
int Circuit_7_25(Graph G, int start, int path[MAX_VERTEX_NUM]) {
    int i;
    int v, w;
    
    path[0]++;
    path[path[0]] = start;
    flags[start] = InPath;  // Ǹöѽ·
    
    // startڽӵ
    for(i = G.fst[start]; i <= G.lst[start]; i++) {
        v = G.s[i]; // ȡڽӵ
        
        // ·еڽӵ㣬˵˻·
        if(flags[v] == InPath) {
            return v;
            
            // ѷʵڽӵ
        } else if(flags[v] == Visited) {
            continue;
        } else {
            w = Circuit_7_25(G, v, path);
            if(w != -1) {
                return w;
            }
        }
    }
    
    // ·Ƴö㣬״̬Ϊ"ѷ"
    path[0]--;
    flags[start] = Visited;
    
    return -1;
}
