/*=====================
 * ͼڽӶر洢ʾ
 ======================*/

#ifndef AMLGRAPH_H
#define AMLGRAPH_H

#include <stdio.h>
#include <string.h>     // ṩmemsetstrcmp ԭ
#include <stdarg.h>     // ṩva_listva_startva_argva_end
#include <stdlib.h>     // ṩmallocreallocfreeexitԭ
#include "Status.h"     //**01 **//

/*
 * ע
 *
 * ͨȨͼΪͼȨͼΪ
 * ͼ/еĶϵΪߡͼ/еĶϵΪֻͷ뻡β
 * ʵʱУδػϸ
 *
 * ǰṹʺϴ洢ͼ/
 *
 *  /Ϣʱʵǰ""ģʹòĻǰ""еġ
 */


/* 궨 */
#define MAX_VERTEX_NUM 26                       // 󶥵


// ͼ
// ͼ
typedef enum {
    DG,     // 0-ͼ˴֧
    DN,     // 1-(Ȩֵ)˴֧
    UDG,    // 2-ͼ
    UDN     // 3-(Ȩֵ)
} GraphKind;


/* ͼڽӶرͶ */
typedef enum {
    unvisit, visit
} VisitIf;

// 
typedef char VertexType;

// ߵظϢ
typedef struct {
    /*
     * ע
     * ̲иĽṹֻȨͼûȨͼ()
     * Ϊ˰ѡҲǽȥڸϢ"Ȩ"ԡ
     */
    int weight;
} InfoType;

/* ߽ */
typedef struct EBox {
    VisitIf mark;       // ʱ
    int ivex;           // ñλ
    int jvex;           // ñλ
    struct EBox* ilink; // ֱָһ
    struct EBox* jlink; // ֱָһ
    InfoType* info;
} EBox;

// ÿͷ
typedef struct VexBox {
    VertexType data;    // Ϣ
    EBox* firstedge;    // ָһöıߵָ
} VexBox;

/* ͼڽӶر洢ʾͶ */
typedef struct {
    VexBox adjmulist[MAX_VERTEX_NUM];   // ͷ
    int vexnum, edgenum;                // ͼ/Ķͱ
    GraphKind kind;                     // ͼͱ־
} AMLGraph;


// /ǷڸϢ
extern Boolean IncInfo;


/*
 * 
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLpath[kind]Ϊ""
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateGraph(AMLGraph* G, char* path[]);

/*
 * ͼ
 */
static Status CreateUDG(AMLGraph* G);

/*
 * 
 */
static Status CreateUDN(AMLGraph* G);

/*
 * ¼ߵظϢ
 */
static void Input(AMLGraph G, InfoType** info);

/*
 * 
 *
 * ضuͼ/еλ
 */
int LocateVex(AMLGraph G, VertexType u);

/*
 * 붥
 *
 * ָĶv׷ӵ㼯УδöĹϵ
 */
Status InsertVex(AMLGraph* G, VertexType v);

/*
 * ɾ
 *
 * Ӷ㼯ɾָĶvעҪصĶϵ
 */
Status DeleteVex(AMLGraph* G, VertexType v);

/*
 * һ߽(ڲʹ)
 */
static EBox* newEBoxPtr(VisitIf mark, int ivex, int jvex, EBox* ilink, EBox* jlink, InfoType* info);

/*
 * <v, w>
 *
 * ǰͼ/ģĽṹʹòһʱֻҪһԶϵߵȻһ
 * ͼ/˵ڿɱгߵĸϢ
 *
 * ע˴յĲMGraphЩһĸϢа˸ߵȨֵ
 */
Status InsertArc(AMLGraph* G, VertexType v, VertexType w, ...);

/*
 * ɾ<v, w>
 */
Status DeleteArc(AMLGraph* G, VertexType v, VertexType w);

/*
 * ͼλʽǰṹ
 */
void PrintGraph(AMLGraph G);

#endif
