/*=====================
 * ͼڽӶر洢ʾ
 ======================*/

#include "AMLGraph.h"

// ¼ݵԴļfpΪnullʱ˵Ҫӿ̨¼
static FILE* fp = NULL;

/*
 * IncInfoָʾͼıǷڸϢ
 * ֵΪ0ʾ޸Ϣ򣬱ʾڸϢ
 */
Boolean IncInfo = FALSE;

// ʱ־飬¼ʹĶ
static Boolean visited[MAX_VERTEX_NUM];

// 
static Status (* VisitFunc)(VertexType e);


/*
 * 
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLpath[kind]Ϊ""
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateGraph(AMLGraph* G, char* path[]) {
    int readFromConsole;    // Ƿӿ̨ȡ
    int kind;
    Status flag;
    
    printf("ͼ(2-ͼ  3-)");
    scanf("%d", &kind);
    
    // ͲϹ(ֻͼ/)
    if(kind < 2 || kind > 3) {
        return ERROR;
    }
    
    // ûļ·Ϣӿ̨ȡ
    readFromConsole = (path == NULL) || strcmp(path[kind], "") == 0;
    
    // Ҫļȡ
    if(readFromConsole) {
        (*G).kind = GraphKind(kind);   // ¼ͼ/
    } else {
        // ļ׼ȡ
        fp = fopen(path[kind], "r");
        if(fp == NULL) {
            return ERROR;
        }
        
        // ¼ͼ
        ReadData(fp, "%d", &((*G).kind));
    }
    
    // ͼһ
    switch((*G).kind) {
        case UDG:
            flag = CreateUDG(G);
            break;
        case UDN:
            flag = CreateUDN(G);
            break;
        default:
            flag = ERROR;
            break;
    }
    
    if(fp != NULL) {
        fclose(fp);
        fp = NULL;
    }
    
    return flag;
}

/*
 * ͼ
 */
static Status CreateUDG(AMLGraph* G) {
    int i, k;
    int vexnum, arcnum;
    VertexType v1, v2;
    InfoType* info = NULL;
    
    (*G).vexnum = (*G).edgenum = 0;
    
    if(fp == NULL) {
        printf("ͼĶ");
        scanf("%d", &vexnum);
        printf("ͼı");
        scanf("%d", &arcnum);
        printf("ͼıǷϢ(0-1-)");
        scanf("%d", &IncInfo);
        
        // ¼붥㼯
        printf("¼ %d 㣬֮ͬÿո", vexnum);
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(stdin);
            scanf("%c", &((*G).adjmulist[i].data));
            (*G).adjmulist[i].firstedge = NULL;
            (*G).vexnum++;
        }
    } else {
        ReadData(fp, "%d", &vexnum); // ¼붥
        ReadData(fp, "%d", &arcnum); // ¼
        ReadData(fp, "%d", &IncInfo);// жϱǷϢ
        
        // ¼붥㼯
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(fp);
            ReadData(fp, "%c", &((*G).adjmulist[i].data));
            (*G).adjmulist[i].firstedge = NULL;
            (*G).vexnum++;
        }
    }
    
    // ڿ̨¼Ϣʱʾ
    if(fp == NULL && arcnum != 0) {
        printf("Ϊͼ¼ %d ߵϢ֮ÿո\n", arcnum);
    }
    
    // ¼ߵϢ
    for(k = 0; k < arcnum; k++) {
        if(fp == NULL) {
            printf(" %2d ߣ", k + 1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v2);
        } else {
            // հףѰһɶ
            skipBlank(fp);
            ReadData(fp, "%c%c", &v1, &v2);
        }
        
        // Ҫ¼ߵϢ
        if(IncInfo) {
            // ¼븽Ϣ
            Input(*G, &info);
        }
        
        // <v1, v2>
        InsertArc(G, v1, v2, info);
    }
    
    // ļжȡʱʵӦжһǷ㹻Ϣ
    return OK;
}

/*
 * 
 */
static Status CreateUDN(AMLGraph* G) {
    int i, k;
    int vexnum, arcnum;
    VertexType v1, v2;
    InfoType* info = NULL;
    
    (*G).vexnum = (*G).edgenum = 0;
    
    if(fp == NULL) {
        printf("Ķ");
        scanf("%d", &vexnum);
        printf("ı");
        scanf("%d", &arcnum);
        printf("ıϱϢΪ˴ȨֵҪ洢Ϣ...\n");
        IncInfo = 1;
        
        // ¼붥㼯
        printf("¼ %d 㣬֮ͬÿո", vexnum);
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(stdin);
            scanf("%c", &((*G).adjmulist[i].data));
            (*G).adjmulist[i].firstedge = NULL;
            (*G).vexnum++;
        }
    } else {
        ReadData(fp, "%d", &vexnum); // ¼붥
        ReadData(fp, "%d", &arcnum); // ¼
        ReadData(fp, "%d", &IncInfo);// жϱǷϢ
        IncInfo = 1;    // ǿƽȨֵ¼뵽Ϣ
        
        // ¼붥㼯
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(fp);
            ReadData(fp, "%c", &((*G).adjmulist[i].data));
            (*G).adjmulist[i].firstedge = NULL;
            (*G).vexnum++;
        }
    }
    
    // ڿ̨¼Ϣʱʾ
    if(fp == NULL && arcnum != 0) {
        printf("Ϊ¼ %d (Ȩֵ)Ϣ㼰Ȩֵ֮ÿո\n", arcnum);
    }
    
    // ¼ߵϢ
    for(k = 0; k < arcnum; k++) {
        if(fp == NULL) {
            printf(" %2d ߼Ȩֵ", k + 1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v2);
        } else {
            // հףѰһɶ
            skipBlank(fp);
            ReadData(fp, "%c%c", &v1, &v2);
        }
        
        // Ҫ¼ߵϢ
        if(IncInfo) {
            // ¼븽Ϣ(˴Ҫ¼Ȩֵ)
            Input(*G, &info);
        }
        
        // <v1, v2>
        InsertArc(G, v1, v2, info);
    }
    
    // ļжȡʱʵӦжһǷ㹻Ϣ
    return OK;
}

/*
 * ¼ߵظϢ
 */
static void Input(AMLGraph G, InfoType** info) {
    int weight;
    
    // ""Ҫ¼ȨֵϢ
    if(G.kind == UDN) {
        *info = (InfoType*) malloc(sizeof(InfoType));
        
        if(fp == NULL) {
            scanf("%d", &weight);
        } else {
            ReadData(fp, "%d", &weight);
        }
        
        (*info)->weight = weight;
    }
}

/*
 * 
 *
 * ضuͼ/еλ
 */
int LocateVex(AMLGraph G, VertexType u) {
    int i;
    
    for(i = 0; i < G.vexnum; i++) {
        if(G.adjmulist[i].data == u) {
            return i;
        }
    }
    
    return -1;
}

/*
 * 붥
 *
 * ָĶv׷ӵ㼯УδöĹϵ
 */
Status InsertVex(AMLGraph* G, VertexType v) {
    int k;
    
    // 
    if((*G).vexnum == MAX_VERTEX_NUM) {
        return ERROR;
    }
    
    // ҪжϸöǷ
    k = LocateVex(*G, v);
    if(k >= 0) {
        return ERROR;    // ָĶʱظ
    }
    
    G->adjmulist[(*G).vexnum].data = v;
    G->adjmulist[(*G).vexnum].firstedge = NULL;
    
    (*G).vexnum++;
    
    return OK;
}

/*
 * ɾ
 *
 * Ӷ㼯ɾָĶvעҪصĶϵ
 */
Status DeleteVex(AMLGraph* G, VertexType v) {
    int i, k, other;
    EBox* p;
    EBox* pre, * r;
    
    // ҪжϸöǷ
    k = LocateVex(*G, v);
    if(k == -1) {
        return ERROR;    // ָĶ㲻
    }
    
    while((p = G->adjmulist[k].firstedge) != NULL) {
        if(p->ivex == k) {
            G->adjmulist[k].firstedge = p->ilink;
            other = p->jvex;
        } else if(p->jvex == k) {
            G->adjmulist[k].firstedge = p->jlink;
            other = p->ivex;
        } else {
            // û
        }
        
        pre = NULL;
        r = G->adjmulist[other].firstedge;
        
        // ұ<other, k>϶ҵ
        while(r != NULL) {
            if(r->ivex == other && r->jvex < k) {
                pre = r;
                r = r->ilink;
            } else if(r->jvex == other && r->ivex < k) {
                pre = r;
                r = r->jlink;
            } else {
                break;
            }
        }
        
        if(r != NULL && r->ivex == other && r->jvex == k) {
            if(pre == NULL) {
                G->adjmulist[other].firstedge = r->ilink;
            } else {
                if(pre->ivex == other) {
                    pre->ilink = r->ilink;
                } else if(pre->jvex == other) {
                    pre->jlink = r->ilink;
                } else {
                    // û
                }
            }
        } else if(r != NULL && r->jvex == other && r->ivex == k) {
            if(pre == NULL) {
                G->adjmulist[other].firstedge = r->jlink;
            } else {
                if(pre->ivex == other) {
                    pre->ilink = r->jlink;
                } else if(pre->jvex == other) {
                    pre->jlink = r->jlink;
                } else {
                    // û
                }
            }
        } else {
            // ˣΪ϶ҵ
        }
        
        free(p);
        
        (*G).edgenum--;  // һ
    }
    
    // ±곬kĶ㣬Ҫݼ±
    for(i = k + 1; i < (*G).vexnum; i++) {
        r = G->adjmulist[i].firstedge;
    
        while(r!=NULL){
            if(r->ivex==i) {
                r->ivex--;
                r = r->ilink;
            } else if(r->jvex==i) {
                r->jvex--;
                r = r->jlink;
            } else {
                // 
            }
        }
    }
    
    // 㼯ǰ
    for(i = k + 1; i < (*G).vexnum; i++) {
        G->adjmulist[i - 1] = G->adjmulist[i];
    }
    
    // ݼ
    (*G).vexnum--;
    
    return OK;
}

/*
 * һ߽(ڲʹ)
 */
static EBox* newEBoxPtr(VisitIf mark, int ivex, int jvex, EBox* ilink, EBox* jlink, InfoType* info) {
    EBox* p = (EBox*) malloc(sizeof(EBox));
    if(!p) {
        exit(OVERFLOW);
    }
    
    p->mark = mark;
    
    p->ivex = ivex;
    p->jvex = jvex;
    
    p->ilink = ilink;
    p->jlink = jlink;
    
    p->info = info;
    
    return p;
}

/*
 * <v, w>
 *
 * ǰͼ/ģĽṹʹòһʱֻҪһԶϵߵȻһ
 * ͼ/˵ڿɱгߵĸϢ
 *
 * ע˴յĲMGraphЩһĸϢа˸ߵȨֵ
 */
Status InsertArc(AMLGraph* G, VertexType v, VertexType w, ...) {
    int tail, head, k;
    EBox* p;
    EBox* pre;
    EBox* r;
    Boolean overlay = FALSE;   // ǷΪ
    InfoType* info = NULL;     // ߵĸϢ
    va_list ap;
    
    tail = LocateVex(*G, v); // ȡvڶ㼯еλ
    if(tail == -1) {
        return ERROR;  // ָĶ㲻
    }
    
    head = LocateVex(*G, w); // ȡwڶ㼯еλ
    if(head == -1) {
        return ERROR;  // ָĶ㲻
    }
    
    // ܾ
    if(tail == head) {
        return ERROR;
    }
    
    // ϴڸϢ
    if(IncInfo) {
        va_start(ap, w);                // wѯ׸ɱ
        info = va_arg(ap, InfoType*);   // ȡϢ
        va_end(ap);
    }
    
    /* ҪҺʵĲλ */
    
    pre = NULL;
    r = G->adjmulist[tail].firstedge;
    
    while(r != NULL) {
        if(r->ivex == tail && r->jvex < head) {
            pre = r;
            r = r->ilink;
        } else if(r->jvex == tail && r->ivex < head) {
            pre = r;
            r = r->jlink;
        } else {
            break;
        }
    }
    
    if(r != NULL && r->ivex == tail && r->jvex == head) {
        r->info = info; // øý
        overlay = TRUE; // ˸
    } else if(r != NULL && r->jvex == tail && r->ivex == head) {
        r->info = info; // øý
        overlay = TRUE; // ˸
    } else {
        p = newEBoxPtr(unvisit, tail, head, r, NULL, info);
        
        if(pre == NULL) {
            G->adjmulist[tail].firstedge = p;
        } else {
            if(pre->ivex == tail) {
                pre->ilink = p;
            } else if(pre->jvex == tail) {
                pre->jlink = p;
            } else {
                // û
            }
        }
    }
    
    if(!overlay) {
        pre = NULL;
        r = G->adjmulist[head].firstedge;
        
        while(r != NULL) {
            if(r->ivex == head && r->jvex < tail) {
                pre = r;
                r = r->ilink;
            } else if(r->jvex == head && r->ivex < tail) {
                pre = r;
                r = r->jlink;
            } else {
                break;
            }
        }
        
        p->jlink = r;
        
        if(pre == NULL) {
            G->adjmulist[head].firstedge = p;
        } else {
            if(pre->ivex == head) {
                pre->ilink = p;
            } else if(pre->jvex == head) {
                pre->jlink = p;
            } else {
                // û
            }
        }
    }
    
    (*G).edgenum++;  // һ
    
    return OK;
}

/*
 * ɾ<v, w>
 */
Status DeleteArc(AMLGraph* G, VertexType v, VertexType w) {
    int tail, head;
    EBox* r;
    EBox* pre;
    
    tail = LocateVex(*G, v);
    if(tail == -1) {
        return ERROR;    // ָĶ㲻
    }
    
    head = LocateVex(*G, w);
    if(head == -1) {
        return ERROR;    // ָĶ㲻
    }
    
    pre = NULL;
    r = G->adjmulist[tail].firstedge;
    
    while(r != NULL) {
        if(r->ivex == tail && r->jvex < head) {
            pre = r;
            r = r->ilink;
        } else if(r->jvex == tail && r->ivex < head) {
            pre = r;
            r = r->jlink;
        } else {
            break;
        }
    }
    
    if(r != NULL && r->ivex == tail && r->jvex == head) {
        if(pre == NULL) {
            G->adjmulist[tail].firstedge = r->ilink;
        } else {
            if(pre->ivex == tail) {
                pre->ilink = r->ilink;
            } else if(pre->jvex == tail) {
                pre->jlink = r->ilink;
            } else {
                // û
            }
        }
    } else if(r != NULL && r->jvex == tail && r->ivex == head) {
        if(pre == NULL) {
            G->adjmulist[tail].firstedge = r->jlink;
        } else {
            if(pre->ivex == tail) {
                pre->ilink = r->jlink;
            } else if(pre->jvex == tail) {
                pre->jlink = r->jlink;
            } else {
                // û
            }
        }
    } else {
        return ERROR;   // δҵ
    }
    
    
    pre = NULL;
    r = G->adjmulist[head].firstedge;
    
    while(r != NULL) {
        if(r->ivex == head && r->jvex < tail) {
            pre = r;
            r = r->ilink;
        } else if(r->jvex == head && r->ivex < tail) {
            pre = r;
            r = r->jlink;
        } else {
            break;
        }
    }
    
    if(r != NULL && r->ivex == head && r->jvex == tail) {
        if(pre == NULL) {
            G->adjmulist[head].firstedge = r->ilink;
        } else {
            if(pre->ivex == head) {
                pre->ilink = r->ilink;
            } else if(pre->jvex == head) {
                pre->jlink = r->ilink;
            } else {
                // û
            }
        }
    } else if(r != NULL && r->jvex == head && r->ivex == tail) {
        if(pre == NULL) {
            G->adjmulist[head].firstedge = r->jlink;
        } else {
            if(pre->ivex == head) {
                pre->ilink = r->jlink;
            } else if(pre->jvex == head) {
                pre->jlink = r->jlink;
            } else {
                // û
            }
        }
    } else {
        // ˣΪǰҵˣ˴϶Ҳҵ
    }
    
    free(r); // ͷڴ
    
    (*G).edgenum--;  // һ
    
    return OK;
}

/*
 * ͼλʽǰṹ
 */
void PrintGraph(AMLGraph G) {
    int i, cur, pos;
    EBox* p;
    
    if(G.vexnum == 0) {
        printf("ͼӡ\n");
        return;
    }
    
    printf("ǰͼ/ %2d 㣬 %2d ...\n", G.vexnum, G.edgenum);
    
    for(i = 0; i < G.vexnum; i++) {
        printf("%c ===> ", G.adjmulist[i].data);
        
        cur = 0;
        p = G.adjmulist[i].firstedge;
        
        while(p != NULL) {
            if(p->ivex == i) {
                pos = p->jvex;
            } else {
                pos = p->ivex;
            }
            
            if(cur < pos) {
                if(IncInfo == 0) {
                    printf(" ");
                    
                    // 丽ϢлȡȨֵ
                } else {
                    printf("     ");
                }
            } else {
                if(IncInfo == 0) {
                    printf("%c", G.adjmulist[pos].data);
                    
                    // 丽ϢлȡȨֵ
                } else {
                    printf("%c[%2d]", G.adjmulist[pos].data, p->info->weight);
                }
                
                if(p->ivex == i) {
                    p = p->ilink;
                } else {
                    p = p->jlink;
                }
            }
            
            cur++;
            
            if(p != NULL) {
                printf("  ");
            }
        }
        
        printf("\n");
    }
}
