#include <stdio.h>
#include <stdarg.h>    // ṩva_listva_startva_argva_end
#include "Status.h"    //**01 **//
#include "AMLGraph.h"  //**07 ͼ**//

/*
 * ͼ/
 */
Status CreateGraph_7_19(AMLGraph* G, char* path[]);

/*
 * 붥
 *
 * ָĶv׷ӵ㼯УδöĹϵ
 */
Status InsertVex_7_18(AMLGraph* G, VertexType v);

/*
 * ɾ
 *
 * Ӷ㼯ɾָĶvעҪصĶϵ
 */
Status DeleteVex_7_18(AMLGraph* G, VertexType v);

/*
 * /<v, w>
 *
 * ǰͼ/ģһҪϵֻһ
 *
 * ͼ˵ڿɱг/ĸϢ
 * ˵ڿɱг/ȨֵԼϢ
 */
Status InsertArc_7_18(AMLGraph* G, VertexType v, VertexType w, ...);

/*
 * ɾ/<v, w>
 *
 * ɾֻǸ±/ͨϵ
 */
Status DeleteArc_7_18(AMLGraph* G, VertexType v, VertexType w);


int main(int argc, char* argv[]) {
    AMLGraph G;
    
    printf(" ͼ/...\n");
    {
        char* path[4];
        
        path[0] = "";
        path[1] = "";
        path[2] = "TestData_UDG.txt";
        path[3] = "TestData_UDN.txt";
        
        CreateGraph_7_19(&G, path);
        PrintGraph(G);
        printf("\n");
    }
    
    printf(" ɾ...\n");
    {
        VertexType v = 'X';
        
        printf("ɾ '%c' ͼΪ\n", v);
        DeleteVex_7_18(&G, v);
        PrintGraph(G);
        printf("\n");
    }
    
    printf(" 붥...\n");
    {
        VertexType v = 'Y';
        
        printf("붥 '%c' ͼΪ\n", v);
        InsertVex_7_18(&G, v);
        PrintGraph(G);
        printf("\n");
    }
    
    printf(" /...\n");
    {
        // ע<E, B>ظı
        VertexType v[10] = {'B', 'C', 'E', 'Y', 'Y', 'Y', 'D', 'D', 'E', 'E'};
        VertexType w[10] = {'Y', 'Y', 'Y', 'A', 'B', 'D', 'C', 'A', 'B', 'D'};
        InfoType info[10] = {{8}, {5}, {1}, {11}, {2}, {6}, {3}, {7}, {2}, {9}};
        int k;
        
        // ͼ
        if(G.kind == DG || G.kind == UDG) {
            for(k = 0; k < 10; k++) {
                printf("Ȩֵıߣ<%c, %c>...\n", v[k], w[k]);
                InsertArc_7_18(&G, v[k], w[k]);
            }
            
            // 
        } else if(G.kind == DN || G.kind == UDN) {
            for(k = 0; k < 10; k++) {
                printf("Ȩֵıߣ<%c, %c, %d>...\n", v[k], w[k], info[k].weight);
                InsertArc_7_18(&G, v[k], w[k], &info[k]);
            }
        } else {
            return ERROR;
        }
        
        PrintGraph(G);
        printf("\n");
    }
    
    printf(" ɾ/...\n");
    {
        VertexType v[3] = {'D', 'E', 'F'};
        VertexType w[3] = {'A', 'B', 'B'};
        int k;
        
        for(k = 0; k < 3; k++) {
            printf("ɾߣ<%c, %c>...\n", v[k], w[k]);
            DeleteArc_7_18(&G, v[k], w[k]);
        }
        PrintGraph(G);
        printf("\n");
    }
    
    return 0;
}


/*
 * ͼ/
 */
Status CreateGraph_7_19(AMLGraph* G, char* path[]) {
    return CreateGraph(G, path);
}

/*
 * 붥
 *
 * ָĶv׷ӵ㼯УδöĹϵ
 */
Status InsertVex_7_18(AMLGraph* G, VertexType v) {
    return InsertVex(G, v);
}

/*
 * ɾ
 *
 * Ӷ㼯ɾָĶvעҪصĶϵ
 */
Status DeleteVex_7_18(AMLGraph* G, VertexType v) {
    return DeleteVex(G, v);
}

/*
 * /<v, w>
 *
 * ǰͼ/ģһҪϵֻһ
 *
 * ͼ˵ڿɱг/ĸϢ
 * ˵ڿɱг/ȨֵԼϢ
 */
Status InsertArc_7_18(AMLGraph* G, VertexType v, VertexType w, ...) {
    va_list ap;
    InfoType* info = NULL;      // /ĸϢ
    
    // /ϴڸϢ
    if(IncInfo) {
        va_start(ap, w);                // wѯ׸ɱ
        info = va_arg(ap, InfoType*);   // ȡϢ
        va_end(ap);
    }
    
    return InsertArc(G, v, w, info);
}

/*
 * ɾ/<v, w>
 *
 * ɾֻǸ±/ͨϵ
 */
Status DeleteArc_7_18(AMLGraph* G, VertexType v, VertexType w) {
    return DeleteArc(G, v, w);
}
