/*=================================
 * ͼ(ڽӾ)洢ʾ
 *
 * 㷨: 7.17.27.47.57.6
 ==================================*/

#include "MGraph.h"     //**07 ͼ**//

// ¼ݵԴļfpΪnullʱ˵Ҫӿ̨¼
static FILE* fp = NULL;

/*
 * IncInfoָʾͼ/ı/ǷڸϢ
 * ֵΪ0ʾ޸Ϣ򣬱ʾڸϢ
 */
Boolean IncInfo = FALSE;

// ʱ־飬¼ʹĶ
static Boolean visited[MAX_VERTEX_NUM];

// 
static Status (* VisitFunc)(VertexType e);


/*
 *  㷨7.1 
 *
 * ͼ/
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLpath[kind]Ϊ""
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateGraph(MGraph* G, char* path[]) {
    int readFromConsole;    // Ƿӿ̨ȡ
    int kind;
    Status flag;
    
    printf("ͼ(0-ͼ  1-  2-ͼ  3-)");
    scanf("%d", &kind);
    
    // ͲϹ
    if(kind < 0 || kind > 3) {
        return ERROR;
    }
    
    // ûļ·Ϣӿ̨ȡ
    readFromConsole = (path == NULL) || strcmp(path[kind], "") == 0;
    
    // Ҫļȡ
    if(readFromConsole) {
        (*G).kind = GraphKind(kind);   // ¼ͼ/
    } else {
        // ļ׼ȡ
        fp = fopen(path[kind], "r");
        if(fp == NULL) {
            return ERROR;
        }
        
        // ¼ͼ
        ReadData(fp, "%d", &((*G).kind));
    }
    
    // ͼ/ͼ/һ
    switch((*G).kind) {
        case DG:
            flag = CreateDG(G);
            break;
        case DN:
            flag = CreateDN(G);
            break;
        case UDG:
            flag = CreateUDG(G);
            break;
        case UDN:
            flag = CreateUDN(G);
            break;
        default:
            flag = ERROR;
            break;
    }
    
    if(fp != NULL) {
        fclose(fp);
        fp = NULL;
    }
    
    return flag;
}

/*
 * ͼ
 */
static Status CreateDG(MGraph* G) {
    int i, j, k;
    ArcCell arcs = {0, NULL};   // ͼÿߵĳʼֵ
    VertexType v1, v2;
    
    if(fp == NULL) {
        printf("ͼĶ");
        scanf("%d", &((*G).vexnum));
        printf("ͼĻ");
        scanf("%d", &((*G).arcnum));
        printf("ͼĻǷϢ(0-1-)");
        scanf("%d", &IncInfo);
        
        // ¼붥㼯
        printf("¼ %d 㣬֮ͬÿո", (*G).vexnum);
        for(i = 0; i < (*G).vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(stdin);
            scanf("%c", &((*G).vexs[i]));
        }
    } else {
        ReadData(fp, "%d", &((*G).vexnum)); // ¼붥
        ReadData(fp, "%d", &((*G).arcnum)); // ¼뻡
        ReadData(fp, "%d", &IncInfo);       // жϻǷϢ
        
        // ¼붥㼯
        for(i = 0; i < (*G).vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(fp);
            ReadData(fp, "%c", &((*G).vexs[i]));
        }
    }
    
    // ʼͼڽӾ
    for(i = 0; i < (*G).vexnum; i++) {
        for(j = 0; j < (*G).vexnum; j++) {
            (*G).arcs[i][j] = arcs;
        }
    }
    
    // ڿ̨¼Ϣʱʾ
    if(fp == NULL && (*G).arcnum != 0) {
        printf("Ϊͼ¼ %d Ϣ֮ÿո\n", (*G).arcnum);
    }
    
    // ¼뻡Ϣ
    for(k = 0; k < (*G).arcnum; k++) {
        if(fp == NULL) {
            printf(" %2d ", k + 1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v2);
        } else {
            // հףѰһɶ
            skipBlank(fp);
            ReadData(fp, "%c%c", &v1, &v2);
        }
        
        i = LocateVex(*G, v1);  // ȡv1ڶ㼯еλ
        j = LocateVex(*G, v2);  // ȡv2ڶ㼯еλ
        
        // ָĶϵΪ1ָʾֱӵ(עû֤±ǷԽ)
        (*G).arcs[i][j].adj = 1;
        
        // Ҫ¼뻡Ϣ
        if(IncInfo) {
            // ¼븽Ϣ
            Input(*G, &((*G).arcs[i][j].info));
        }
    }
    
    // ļжȡʱʵӦжһǷ㹻Ϣ
    return OK;
}

/*
 * 
 */
static Status CreateDN(MGraph* G) {
    int i, j, k;
    ArcCell arcs = {INFINITE, NULL};    // ÿĳʼֵ
    VertexType v1, v2;
    VRType w;
    
    if(fp == NULL) {
        printf("Ķ");
        scanf("%d", &((*G).vexnum));
        printf("Ļ");
        scanf("%d", &((*G).arcnum));
        printf("ĻǷϢ(0-1-)");
        scanf("%d", &IncInfo);
        
        // ¼붥㼯
        printf("¼ %d 㣬֮ͬÿո", (*G).vexnum);
        for(i = 0; i < (*G).vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(stdin);
            scanf("%c", &((*G).vexs[i]));
        }
    } else {
        ReadData(fp, "%d", &((*G).vexnum)); // ¼붥
        ReadData(fp, "%d", &((*G).arcnum)); // ¼뻡
        ReadData(fp, "%d", &IncInfo);       // жϻǷϢ
        
        // ¼붥㼯
        for(i = 0; i < (*G).vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(fp);
            ReadData(fp, "%c", &((*G).vexs[i]));
        }
    }
    
    // ʼڽӾ
    for(i = 0; i < (*G).vexnum; i++) {
        for(j = 0; j < (*G).vexnum; j++) {
            (*G).arcs[i][j] = arcs;
        }
    }
    
    // ڿ̨¼Ϣʱʾ
    if(fp == NULL && (*G).arcnum != 0) {
        printf("Ϊ¼ %d (Ȩֵ)Ϣ㼰Ȩֵ֮ÿո\n", (*G).arcnum);
    }
    
    // ¼뻡Ϣ
    for(k = 0; k < (*G).arcnum; k++) {
        if(fp == NULL) {
            printf(" %2d Ȩֵ", k + 1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v2);
            scanf("%d", &w);
        } else {
            // հףѰһɶ
            skipBlank(fp);
            ReadData(fp, "%c%c%d", &v1, &v2, &w);
        }
        
        i = LocateVex(*G, v1);  // ȡv1ڶ㼯еλ
        j = LocateVex(*G, v2);  // ȡv2ڶ㼯еλ
        
        // ָĶϵϼ¼Ȩֵ(עû֤±ǷԽ)
        (*G).arcs[i][j].adj = w;
        
        // Ҫ¼뻡Ϣ
        if(IncInfo) {
            // ¼븽Ϣ
            Input(*G, &((*G).arcs[i][j].info));
        }
    }
    
    // ļжȡʱʵӦжһǷ㹻Ϣ
    return OK;
}

/*
 * ͼ
 */
static Status CreateUDG(MGraph* G) {
    int i, j, k;
    ArcCell arcs = {0, NULL};   // ͼÿߵĳʼֵ
    VertexType v1, v2;
    
    if(fp == NULL) {
        printf("ͼĶ");
        scanf("%d", &((*G).vexnum));
        printf("ͼı");
        scanf("%d", &((*G).arcnum));
        printf("ͼıǷϢ(0-1-)");
        scanf("%d", &IncInfo);
        
        // ¼붥㼯
        printf("¼ %d 㣬֮ͬÿո", (*G).vexnum);
        for(i = 0; i < (*G).vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(stdin);
            scanf("%c", &((*G).vexs[i]));
        }
    } else {
        ReadData(fp, "%d", &((*G).vexnum)); // ¼붥
        ReadData(fp, "%d", &((*G).arcnum)); // ¼
        ReadData(fp, "%d", &IncInfo);       // жϱǷϢ
        
        // ¼붥㼯
        for(i = 0; i < (*G).vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(fp);
            ReadData(fp, "%c", &((*G).vexs[i]));
        }
    }
    
    // ʼͼڽӾ
    for(i = 0; i < (*G).vexnum; i++) {
        for(j = 0; j < (*G).vexnum; j++) {
            (*G).arcs[i][j] = arcs;
        }
    }
    
    // ڿ̨¼Ϣʱʾ
    if(fp == NULL && (*G).arcnum != 0) {
        printf("Ϊͼ¼ %d ߵϢ֮ÿո\n", (*G).arcnum);
    }
    
    // ¼ߵϢ
    for(k = 0; k < (*G).arcnum; k++) {
        if(fp == NULL) {
            printf(" %2d ߣ", k + 1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v2);
        } else {
            // հףѰһɶ
            skipBlank(fp);
            ReadData(fp, "%c%c", &v1, &v2);
        }
        
        i = LocateVex(*G, v1);  // ȡv1ڶ㼯еλ
        j = LocateVex(*G, v2);  // ȡv2ڶ㼯еλ
        
        // ָĶϵΪ1ָʾֱӵ(עû֤±ǷԽ)
        (*G).arcs[i][j].adj = 1;
        
        // Ҫ¼ߵϢ
        if(IncInfo) {
            // ¼븽Ϣ
            Input(*G, &((*G).arcs[i][j].info));
        }
        
        // ԳƵ
        (*G).arcs[j][i] = (*G).arcs[i][j];
    }
    
    // ļжȡʱʵӦжһǷ㹻Ϣ
    return OK;
}

/*
 *  㷨7.2 
 *
 * 
 */
static Status CreateUDN(MGraph* G) {
    int i, j, k;
    ArcCell arcs = {INFINITE, NULL};    // ÿߵĳʼֵ
    VertexType v1, v2;
    VRType w;
    
    if(fp == NULL) {
        printf("Ķ");
        scanf("%d", &((*G).vexnum));
        printf("ı");
        scanf("%d", &((*G).arcnum));
        printf("ıǷϢ(0-1-)");
        scanf("%d", &IncInfo);
        
        // ¼붥㼯
        printf("¼ %d 㣬֮ͬÿո", (*G).vexnum);
        for(i = 0; i < (*G).vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(stdin);
            scanf("%c", &((*G).vexs[i]));
        }
    } else {
        ReadData(fp, "%d", &((*G).vexnum)); // ¼붥
        ReadData(fp, "%d", &((*G).arcnum)); // ¼
        ReadData(fp, "%d", &IncInfo);       // жϱǷϢ
        
        // ¼붥㼯
        for(i = 0; i < (*G).vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(fp);
            ReadData(fp, "%c", &((*G).vexs[i]));
        }
    }
    
    // ʼڽӾ
    for(i = 0; i < (*G).vexnum; i++) {
        for(j = 0; j < (*G).vexnum; j++) {
            (*G).arcs[i][j] = arcs;
        }
    }
    
    // ڿ̨¼Ϣʱʾ
    if(fp == NULL && (*G).arcnum != 0) {
        printf("Ϊ¼ %d (Ȩֵ)Ϣ㼰Ȩֵ֮ÿո\n", (*G).arcnum);
    }
    
    // ¼ߵϢ
    for(k = 0; k < (*G).arcnum; k++) {
        if(fp == NULL) {
            printf(" %2d ߼Ȩֵ", k + 1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v2);
            scanf("%d", &w);
        } else {
            // հףѰһɶ
            skipBlank(fp);
            ReadData(fp, "%c%c%d", &v1, &v2, &w);
        }
        
        i = LocateVex(*G, v1);  // ȡv1ڶ㼯еλ
        j = LocateVex(*G, v2);  // ȡv2ڶ㼯еλ
        
        // ָĶϵϼ¼Ȩֵ(עû֤±ǷԽ)
        (*G).arcs[i][j].adj = w;
        
        // Ҫ¼ߵϢ
        if(IncInfo) {
            // ¼븽Ϣ
            Input(*G, &((*G).arcs[i][j].info));
        }
        
        // ԳƵ
        (*G).arcs[j][i] = (*G).arcs[i][j];
    }
    
    // ļжȡʱʵӦжһǷ㹻Ϣ
    return OK;
}

/*
 * ¼/ظϢ
 */
static void Input(MGraph G, InfoType** info) {
    //¼/Ϣ漰ı/ĬϢ
}

/*
 * 
 *
 * ضuͼ/еλ
 */
int LocateVex(MGraph G, VertexType u) {
    int i;
    
    for(i = 0; i < G.vexnum; i++) {
        if(G.vexs[i] == u) {
            return i;
        }
    }
    
    return -1;
}

/*
 * 붥
 *
 * ָĶv׷ӵ㼯УδöĹϵ
 */
Status InsertVex(MGraph* G, VertexType v) {
    int i, k;
    VRType adj;
    
    // 
    if((*G).vexnum == MAX_VERTEX_NUM) {
        return ERROR;
    }
    
    // ҪжϸöǷ
    k = LocateVex(*G, v);
    if(k >= 0) {
        return ERROR;    // ָĶʱظ
    }
    
    // ȷһͨ
    if((*G).kind == DG || (*G).kind == UDG) {
        adj = 0;        // ͼ
    } else if((*G).kind == DN || (*G).kind == UDN) {
        adj = INFINITE; // 
    } else {
        return ERROR;
    }
    
    (*G).vexs[(*G).vexnum] = v;
    (*G).vexnum++;
    
    for(i = 0; i < (*G).vexnum; i++) {
        (*G).arcs[i][(*G).vexnum - 1].adj = adj;
        (*G).arcs[(*G).vexnum - 1][i].adj = adj;
    }
    
    return OK;
}

/*
 * ɾ
 *
 * Ӷ㼯ɾָĶvעҪصĶϵ
 */
Status DeleteVex(MGraph* G, VertexType v) {
    int i, j, k;
    VRType adj;
    
    k = LocateVex(*G, v);
    if(k == -1) {
        return ERROR;    // ָĶ㲻
    }
    
    // ȷһͨ
    if((*G).kind == DG || (*G).kind == UDG) {
        adj = 0;        // ͼ
    } else if((*G).kind == DN || (*G).kind == UDN) {
        adj = INFINITE; // 
    } else {
        return ERROR;
    }
    
    // ±/
    for(i = 0; i < (*G).vexnum; i++) {
        // ڴӶvıߣߵһ
        if((*G).arcs[k][i].adj != adj) {
            (*G).arcnum--;
        }
        
        // ͼ/ȻҪ±/
        if((*G).kind == DG || (*G).kind == DN) {
            // ڵﶥvıߣߵһ
            if((*G).arcs[i][k].adj != adj) {
                (*G).arcnum--;
            }
        }
    }
    
    // ڽӾеĶϵ
    for(j = k + 1; j < (*G).vexnum; j++) {
        for(i = 0; i < (*G).vexnum; i++) {
            (*G).arcs[i][j - 1] = (*G).arcs[i][j];    // ұߵŲߵ
        }
    }
    
    // ڽӾеĶϵ
    for(i = k + 1; i < (*G).vexnum; i++) {
        // עƵĹϵjС(*G).vexnum - 1
        for(j = 0; j < (*G).vexnum - 1; j++) {
            (*G).arcs[i - 1][j] = (*G).arcs[i][j];    // һŲһ
        }
    }
    
    // öӶ㼯Ƴ
    for(i = k + 1; i < (*G).vexnum; i++) {
        (*G).vexs[i - 1] = (*G).vexs[i];
    }
    
    // һ
    (*G).vexnum--;
    
    return OK;
}

/*
 * /<v, w>
 *
 * ǰͼ/ģһҪϵֻһ
 *
 * ͼ˵ڿɱг/ĸϢ
 * ˵ڿɱг/ȨֵԼϢ
 */
Status InsertArc(MGraph* G, VertexType v, VertexType w, ...) {
    int kv, kw;
    VRType adj;                 // ϵ
    Boolean overlay = FALSE;    // ǷΪ
    InfoType* info = NULL;      // /ĸϢ
    va_list ap;
    
    kv = LocateVex(*G, v);
    if(kv == -1) {
        return ERROR;    // ָĶ㲻
    }
    
    kw = LocateVex(*G, w);
    if(kw == -1) {
        return ERROR;    // ָĶ㲻
    }
    
    // ܾ
    if(kv == kw) {
        return ERROR;
    }
    
    /* ȷһϵ */
    
    // ͼ˵ͨϵ1ʾ
    if((*G).kind == DG || (*G).kind == UDG) {
        adj = 1;
        
        // /ϴڸϢ
        if(IncInfo) {
            va_start(ap, w);                // wѯ׸ɱ
            info = va_arg(ap, InfoType*);   // ȡϢ
            va_end(ap);
        }
        
        overlay = (*G).arcs[kv][kw].adj != 0;
        
        // ˵˴ҪӿɱлȡȨֵϢ
    } else if((*G).kind == DN || (*G).kind == UDN) {
        va_start(ap, w);    // wѯ׸ɱ
        
        adj = va_arg(ap, VRType);   // ȡȨֵϢ
        
        // /ϴڸϢ
        if(IncInfo) {
            info = va_arg(ap, InfoType*);   // ȡϢ
        }
        
        va_end(ap);
        
        overlay = (*G).arcs[kv][kw].adj != INFINITE;
    } else {
        return ERROR;
    }
    
    (*G).arcs[kv][kw].adj = adj;    // ¼ϵ
    
    // /ϴڸϢ¼ӹϵ
    if(IncInfo) {
        (*G).arcs[kv][kw].info = info;
    }
    
    // ͼ/ҪǶԳ
    if((*G).kind == UDG || (*G).kind == UDN) {
        (*G).arcs[kw][kv] = (*G).arcs[kv][kw];
    }
    
    // ڷǸǵ£ſǸ±/
    if(!overlay) {
        (*G).arcnum++;  // 򣬱/ֻһ
    }
    
    return OK;
}

/*
 * ɾ/
 *
 * ɾֻǸ±/ͨϵ
 */
Status DeleteArc(MGraph* G, VertexType v, VertexType w) {
    int kv, kw;
    VRType adj;
    Boolean found = FALSE;  // Ƿڴɾı/
    
    kv = LocateVex(*G, v);
    if(kv == -1) {
        return ERROR;    // ָĶ㲻
    }
    
    kw = LocateVex(*G, w);
    if(kw == -1) {
        return ERROR;    // ָĶ㲻
    }
    
    // ȷһͨ
    if((*G).kind == DG || (*G).kind == UDG) {
        adj = 0;        // ͼ
        
        found = (*G).arcs[kv][kw].adj != 0;
    } else if((*G).kind == DN || (*G).kind == UDN) {
        adj = INFINITE; // 
        
        found = (*G).arcs[kv][kw].adj != INFINITE;
    } else {
        return ERROR;
    }
    
    // ѶϿ
    (*G).arcs[kv][kw].adj = adj;
    
    // ͼ/ҪǶԳ
    if((*G).kind == UDG || (*G).kind == UDN) {
        (*G).arcs[kw][kv] = (*G).arcs[kv][kw];
    }
    
    // ҵָĻʱſǸ±/
    if(found) {
        (*G).arcnum--;  // 򣬱/ֻһ
    }
    
    return OK;
}

/*
 * ͼλʽǰṹ
 *
 * עͼ/Уʹ"-"ʾ㲻ֱͨ
 */
void PrintGraph(MGraph G) {
    int i, j;
    
    if(G.vexnum == 0) {
        printf("ͼӡ\n");
        return;
    }
    
    printf("ǰͼ/ %2d 㣬 %2d /...\n", G.vexnum, G.arcnum);
    
    printf("  ");
    for(i = 0; i < G.vexnum; i++) {
        printf("  %c", G.vexs[i]);
    }
    printf("\n");
    
    for(i = 0; i < G.vexnum; i++) {
        printf("%c ", G.vexs[i]);
        
        for(j = 0; j < G.vexnum; j++) {
            if(((G.kind == DG || G.kind == UDG) && G.arcs[i][j].adj == 0) || ((G.kind == DN || G.kind == UDN) && G.arcs[i][j].adj == INFINITE)) {
                printf("  -");
            } else {
                printf("%3d", G.arcs[i][j].adj);
            }
        }
        
        printf("\n");
    }
}
