/*==================
 * ˫ױ洢ʾ
 ===================*/

#ifndef PTREE_H
#define PTREE_H

#include <stdio.h>
#include <stdlib.h>     // ṩ mallocfree ԭ
#include <string.h>     // ṩ memsetstrcmp ԭ
#include "Status.h"     //**01 **//
#include "LinkList.h"   //**02 Ա**//
#include "LinkQueue.h"  //**03 ջͶ**//

/*  */
#define MAX_TREE_SIZE 1024

/* ĺ */
#define MAX_CHILD_COUNT 8

/* ԪͶ壬ԪΪchar */
typedef char TElemType;

/* (˫)Ľ㶨 */
typedef struct PTNode {
    TElemType data;
    int parent;         // ˫λ
} PTNode;

/*
 * (˫)Ͷ
 *
 *ע
 * 1.нnodes""洢ûп϶
 * 2.rܳnodesλ
 * 3.⣬ΰ˳ŸУһ̲ͼʾܻ
 * 4.nodesѭʹõģһ̲δᵽ
 * 5.nodesռ㹻ģΪ̬洢
 */
typedef struct {
    PTNode nodes[MAX_TREE_SIZE];    // 洢н
    int r;  // λ()
    int n;  // Ľ
} PTree;


/* ĳϢ */
typedef struct{
    int row;            // ǰ
    int col;            // ǰ
    int childIndex;     // ǰǵڼ
    int firstChild;     // ǰĵһе
    int lastChild;      // ǰһе
} Pos;


/*
 * ʼ
 *
 * 
 */
Status InitTree_P(PTree* T);

/*
 * 
 *
 * ԤĶ
 * ԼʹáС
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateTree_P(PTree* T, char* path);

/*
 * п
 *
 * жǷΪ
 */
Status TreeEmpty_P(PTree T);


/* ڲʹõĺ */

// ڲ
static void Create_P(PTree* T, FILE* fp);

// ȡTĽϢЩϢPos͵Ķ
static void getPos_P(PTree T, Pos pt[]);


/* ͼλ */

// ͼλʽǰṹ
void PrintTree_P(PTree T);

// ͼλǰṹڲʵ
static void Print_P(PTree T, Pos pt[], int i);

// ͼλнṹڲʹ
static void PrintFramework_P(PTree T);

#endif
