/*==================
 * ˫ױ洢ʾ
 ===================*/

#include "PTree.h"

/*
 * ʼ
 *
 * 
 */
Status InitTree(PTree* T) {
    if(T == NULL) {
        return ERROR;
    }
    
    T->n = 0;
    
    // 
    memset(T->nodes, 0, sizeof(T->nodes));
    
    return OK;
}

/*
 * 
 *
 * ԤĶ
 * ԼʹáС
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateTree(PTree* T, char* path) {
    FILE* fp;
    int readFromConsole;    // Ƿӿ̨ȡ
    
    // ûļ·Ϣӿ̨ȡ
    readFromConsole = path == NULL || strcmp(path, "") == 0;
    
    if(readFromConsole) {
        printf("ԪϢڿս㣬ʹ^...\n");
        Create(T, NULL);
    } else {
        // ļ׼ȡ
        fp = fopen(path, "r");
        if(fp == NULL) {
            return ERROR;
        }
        Create(T, fp);
        fclose(fp);
    }
    
    return OK;
}

/*
 * п
 *
 * жǷΪ
 */
Status TreeEmpty(PTree T) {
    return T.n == 0 ? TRUE : FALSE;
}

/*
 * 
 *
 * ȣ
 */
int TreeDepth(PTree T) {
    int k, level;
    
    // 
    if(TreeEmpty(T)) {
        return 0;
    }
    
    /*
     * kʼΪһλ
     * Ľ㰴洢洢Ľضλ
     */
    k = (T.r + T.n - 1) % MAX_TREE_SIZE;
    level = 0;
    
    do {
        level++;
        k = T.nodes[k].parent;
    } while(k != -1);
    
    return level;
}


/* ڲʹõĺ */

// ڲ
static void Create(PTree* T, FILE* fp) {
    int r;          // ĸλã
    int n;          // ¼Ԫ
    int cur;        // α
    TElemType ch;
    LinkQueue Q;
    QElemType e;    // Ԫָʾλ
    char s[MAX_CHILD_COUNT + 1];
    int i;
    
    InitQueue(&Q);
    
    n = 0;
    
    // ȡλ
    if(fp == NULL) {
        printf("λ(0~%d)", MAX_TREE_SIZE - 1);
        scanf("%d", &r);
        cur = r;
        
        printf("ֵ");
        scanf("%s", s);
        ch = s[0];
        
        // 
        EnQueue(&Q, cur);
        T->nodes[cur].data = ch;
        T->nodes[cur].parent = -1;
        cur = (cur + 1) % MAX_TREE_SIZE;
        n++;
        
        while(!QueueEmpty(Q)) {
            DeQueue(&Q, &e);    // λó
            
            printf(" %c ĺӽ㣬ںʱһ^", T->nodes[e].data);
            scanf("%s", s);
            for(i = 0; i < strlen(s); i++) {
                if(s[i] == '^') {
                    break;
                }
                
                EnQueue(&Q, cur); // ǰλ
                T->nodes[cur].data = s[i];
                T->nodes[cur].parent = e;
                cur = (cur + 1) % MAX_TREE_SIZE;
                n++;
            }
        }
    } else {
        // ¼λ
        ReadData(fp, "%d", &r);
        cur = r;
        
        // ¼ֵ
        ReadData(fp, "%s", s);
        ch = s[0];
        printf("¼ֵ%c\n", ch);
        
        // 
        EnQueue(&Q, cur);
        T->nodes[cur].data = ch;
        T->nodes[cur].parent = -1;
        cur = (cur + 1) % MAX_TREE_SIZE;
        n++;
        
        while(!QueueEmpty(Q)) {
            ReadData(fp, "%s", s);
            ch = s[0];
            printf("¼ %c ĺӣ", ch);
            
            // ¼뺢ӽ
            ReadData(fp, "%s", s);
            printf("%s\n", s);
            
            DeQueue(&Q, &e);    // λó
            
            // 
            for(i = 0; i < strlen(s); i++) {
                if(s[i] == '^') {
                    break;
                }
                
                EnQueue(&Q, cur); // ǰλ
                T->nodes[cur].data = s[i];
                T->nodes[cur].parent = e;
                cur = (cur + 1) % MAX_TREE_SIZE;
                n++;
            }
        }
    }
    
    T->r = r;
    T->n = n;
}

// ȡTĽϢЩϢPos͵Ķ
static void getPos(PTree T, Pos pt[]) {
    LinkList Lt, Lt_parent, Lt_child;
    int m, n, p, k, s;
    int level;
    
    memset(pt, 0, MAX_TREE_SIZE * sizeof(Pos));
    
    // 
    if(TreeEmpty(T)) {
        return;
    }
    
    InitList(&Lt_parent);
    InitList(&Lt_child);
    
    // parentΪ-1
    ListInsert(Lt_parent, 1, -1);
    
    level = 1;
    k = T.r;
    m = n = 0;
    s = -1; // ʼͷĸΪ-1
    
    while(k != (T.r + T.n) % MAX_TREE_SIZE) {
        // kһеʼΪ-1
        pt[k].firstChild = -1;
        
        // kһеʼΪ-1
        pt[k].lastChild = -1;
        
        // ǰkĸ
        p = T.nodes[k].parent;
        if(p != s) {
            s = p;  // ׷ٸı仯
            n = 0;  // ıʱҪ¼
        }
        
        // жϵǰǷΪlevel-1ĺ
        if(LocateElem(Lt_parent, p, Equal)) {
            ListInsert(Lt_child, ++m, k);
            
            pt[k].row = level;
            pt[k].col = m;
            pt[k].childIndex = ++n;
            
            // ȷǰ㸸
            if(p != -1) {
                // һе
                if(pt[p].firstChild==-1) {
                    pt[p].firstChild = k;
                }
                
                // һе
                pt[p].lastChild = k;
            }
            
            k = (k + 1) % MAX_TREE_SIZE;
        } else {
            Lt = Lt_parent;
            Lt_parent = Lt_child;
            Lt_child = Lt;
            ClearList(Lt_child);
            
            level++;
            m = 0;
        }
    }
    
    DestroyList(&Lt_parent);
    DestroyList(&Lt_child);
}


/* ͼλ */

// ͼλʽǰṹ
void PrintTree(PTree T) {
    Pos pt[MAX_TREE_SIZE];
    
    // 
    if(TreeEmpty(T)) {
        printf("\n");
        return;
    }
    
    // TнλϢ
    getPos(T, pt);
    
    Print(T, pt, T.r);
    
    printf("\n");
    
    printf("洢ṹ\n");
    PrintFramework(T);
}

// ͼλǰṹڲʵ
static void Print(PTree T, Pos pt[], int i) {
    int firstChild;
    int rightBrother;
    int k;
    
    // ʵǰ
    printf("%c ", T.nodes[i].data);
    
    firstChild = pt[i].firstChild;
    
    // ӣҪȷӵݣ
    if(firstChild != -1) {
        Print(T, pt, firstChild);
    }
    
    rightBrother = (i + 1) % MAX_TREE_SIZE;
    
    // ֵܣҪȷֵܵݣ
    if(rightBrother != (T.r + T.n) % MAX_TREE_SIZE && T.nodes[i].parent == T.nodes[rightBrother].parent) {
        // ʵǰֵǰǰ㲻һӣһλ
        if(pt[T.nodes[i].parent].lastChild != i) {
            printf("\n");
            
            for(k = 0; k < pt[rightBrother].row - 1; k++) {
                printf(". ");
            }
        }
        
        Print(T, pt, rightBrother);
    }
}

// ͼλнṹڲʹ
static void PrintFramework(PTree T) {
    int k;
    
    if(T.n == 0) {
        printf("\n");
        return;
    }
    
    printf("+---------+\n");
    printf("|  i e  p |\n");
    printf("+---------+\n");
    
    for(k = T.r; k != (T.r + T.n) % MAX_TREE_SIZE; k = (k + 1) % MAX_TREE_SIZE) {
        printf("| %2d %c %2d |\n", k, T.nodes[k].data, T.nodes[k].parent);
    }
    
    printf("+---------+\n");
}
