/*=============================
 * ߼ӵ˳ϡ
 *
 * 㷨: 5.3
 ==============================*/

#include "RLSMatrix.h"  //**05 ͹**//

/*
 * ϡM
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateSMatrix(RLSMatrix* M, char* path) {
    int k;
    FILE* fp;
    int readFromConsole;    // Ƿӿ̨ȡ
    
    // ûļ·Ϣӿ̨ȡ
    readFromConsole = path == NULL || strcmp(path, "") == 0;
    
    // ûļ·Ϣӿ̨ȡ
    if(readFromConsole) {
        printf("");
        scanf("%d", &((*M).mu));
        printf("");
        scanf("%d", &((*M).nu));
        printf("Ԫظ");
        scanf("%d", &((*M).tu));
        printf("%dԪϢ\n", (*M).tu);
        for(k = 1; k <= (*M).tu; k++) {
            printf("%2d飺", k);
            scanf("%d%d%d", &((*M).data[k].i), &((*M).data[k].j), &((*M).data[k].e));
        }
    } else {
        fp = fopen(path, "r");
        
        ReadData(fp, "%d%d%d", &((*M).mu), &((*M).nu), &((*M).tu));
        
        for(k = 1; k <= (*M).tu; k++) {
            ReadData(fp, "%d%d%d", &((*M).data[k].i), &((*M).data[k].j), &((*M).data[k].e));
        }
        
        fclose(fp);
    }
    
    // Ϊrpos鸳ֵ
    AssignRpos(M);
    
    return OK;
}

/*
 * ϡ
 *
 *ע
 * ߼ӵ˳ṹ޷١
 */
Status DestroySMatrix(RLSMatrix* M) {
    int i;
    
    if(M == NULL) {
        return ERROR;
    }
    
    M->mu = 0;
    M->nu = 0;
    M->tu = 0;
    
    for(i = 0; i <= MAXRC; ++i) {
        M->rpos[i] = 0;
    }
    
    return OK;
}

/*
 * 
 *
 * һ¾Tþ˴ӾMаݡ
 */
Status CopySMatrix(RLSMatrix M, RLSMatrix* T) {
    (*T) = M;   // ṹֱ֮ӸƣʹڲҲ
    
    return OK;
}

/*
 * ӷ
 *
 * Q = M + N
 */
Status AddSMatrix(RLSMatrix M, RLSMatrix N, RLSMatrix* Q) {
    int m, n, k;
    
    if(M.mu != N.mu || M.nu != N.nu) {
        printf("\n");
        return ERROR;
    }
    
    // ʼQϢ
    (*Q).mu = M.mu;
    (*Q).nu = M.nu;
    (*Q).tu = 0;
    
    m = n = k = 1;
    
    // αMNԪ
    while(m <= M.tu && n <= N.tu) {
        // MеԪ±С
        if(M.data[m].i < N.data[n].i) {
            (*Q).data[k] = M.data[m];
            m++;
            
            // NеԪ±С
        } else if(M.data[m].i > N.data[n].i) {
            (*Q).data[k] = N.data[n];
            n++;
            
            // MNеԪ±һ£ҪһȽ
        } else {
            // MеԪ±С
            if(M.data[m].j < N.data[n].j) {
                (*Q).data[k] = M.data[m];
                m++;
                
                // NеԪ±С
            } else if(M.data[m].j > N.data[n].j) {
                (*Q).data[k] = N.data[n];
                n++;
                
                // MNеԪ±һ£Ҫмӷ
            } else {
                // ֵѾΪ0ĻҪ洢Ԫ
                if((M.data[m].e + N.data[n].e) == 0) {
                    m++;
                    n++;
                    continue;
                } else {
                    (*Q).data[k].i = M.data[m].i;
                    (*Q).data[k].j = M.data[m].j;
                    (*Q).data[k].e = M.data[m].e + N.data[n].e;
                    m++;
                    n++;
                }
            }
        }
        
        k++;
        (*Q).tu++;
    }
    
    // MʣԪ
    while(m <= M.tu) {
        (*Q).data[k] = M.data[m];
        m++;
        k++;
        (*Q).tu++;
    }
    
    // NʣԪ
    while(n <= N.tu) {
        (*Q).data[k] = N.data[n];
        n++;
        k++;
        (*Q).tu++;
    }
    
    // Ϊrpos鸳ֵ
    AssignRpos(Q);
    
    return OK;
}

/*
 * 
 *
 * Q = M - N
 */
Status SubSMatrix(RLSMatrix M, RLSMatrix N, RLSMatrix* Q) {
    int m, n, k;
    
    if(M.mu != N.mu || M.nu != N.nu) {
        printf("\n");
        return ERROR;
    }
    
    // ʼQϢ
    (*Q).mu = M.mu;
    (*Q).nu = M.nu;
    (*Q).tu = 0;
    
    m = n = k = 1;
    
    // αMNԪ
    while(m <= M.tu && n <= N.tu) {
        // MеԪ±С
        if(M.data[m].i < N.data[n].i) {
            (*Q).data[k] = M.data[m];
            m++;
            
            // NеԪ±С
        } else if(M.data[m].i > N.data[n].i) {
            (*Q).data[k].i = N.data[n].i;
            (*Q).data[k].j = N.data[n].j;
            (*Q).data[k].e = -N.data[n].e;  // ҪԪֵȡ෴
            n++;
            
            // MNеԪ±һ£ҪһȽ
        } else {
            // MеԪ±С
            if(M.data[m].j < N.data[n].j) {
                (*Q).data[k] = M.data[m];
                m++;
                
                // NеԪ±С
            } else if(M.data[m].j > N.data[n].j) {
                (*Q).data[k].i = N.data[n].i;
                (*Q).data[k].j = N.data[n].j;
                (*Q).data[k].e = -N.data[n].e;  // ҪԪֵȡ෴
                n++;
                
                // MNеԪ±һ£Ҫм
            } else {
                // ֵѾΪ0ĻҪ洢Ԫ
                if((M.data[m].e - N.data[n].e) == 0) {
                    m++;
                    n++;
                    continue;
                } else {
                    (*Q).data[k].i = M.data[m].i;
                    (*Q).data[k].j = M.data[m].j;
                    (*Q).data[k].e = M.data[m].e - N.data[n].e;
                    m++;
                    n++;
                }
            }
        }
        
        k++;
        (*Q).tu++;
    }
    
    // MʣԪ
    while(m <= M.tu) {
        (*Q).data[k] = M.data[m];
        m++;
        k++;
        (*Q).tu++;
    }
    
    // NʣԪ
    while(n <= N.tu) {
        (*Q).data[k].i = N.data[n].i;
        (*Q).data[k].j = N.data[n].j;
        (*Q).data[k].e = -N.data[n].e;
        n++;
        k++;
        (*Q).tu++;
    }
    
    // Ϊrpos鸳ֵ
    AssignRpos(Q);
    
    return OK;
}

/*
 *  㷨5.3 
 *
 * ˷
 *
 * Q = M * N
 */
Status MultSMatrix(RLSMatrix M, RLSMatrix N, RLSMatrix* Q) {
    int arow, p, tp;
    int brow, q, tq;
    int ccol;
    int* ctemp;    // QиԪֵۼctemp[0]Ԫ
    int i;
    
    // MҪN
    if(M.nu != N.mu) {
        printf("\n");
        return ERROR;
    }
    
    // ʼQϢ
    (*Q).mu = M.mu;
    (*Q).nu = N.nu;
    (*Q).tu = 0;
    
    // 
    if(M.tu * N.tu == 0) {
        return OK;
    }
    
    ctemp = (int*) malloc((N.nu + 1) * sizeof(int));
    
    // Mÿһ
    for(arow = 1; arow <= M.mu; ++arow) {
        // ʼQԪֵ
        for(i = 0; i <= N.nu; ++i) {
            ctemp[i] = 0;
        }
        
        // tpָMǰеһеһԪλ
        if(arow < M.mu) {
            tp = M.rpos[arow + 1];
        } else {
            tp = M.tu + 1;
        }
        
        // MarowезԪ
        for(p = M.rpos[arow]; p < tp; ++p) {
            // ȡ÷ԪNек
            brow = M.data[p].j;
    
            // tqָNǰеһеһԪλ
            if(brow < N.mu) {
                tq = N.rpos[brow + 1];
            } else {
                tq = N.tu + 1;
            }
    
            // NbrowезԪ
            for(q = N.rpos[brow]; q < tq; ++q) {
                // ˻ԪQек
                ccol = N.data[q].j;
                
                // ۼӳ˻
                ctemp[ccol] += M.data[p].e * N.data[q].e;
            }
        }
    
        /*
         * ˣQеarowԪ
         */
        
        // ĳ˻ѡȡԪQ
        for(ccol = 1; ccol <= (*Q).nu; ++ccol) {
            // QеarowccolԪزΪ0
            if(ctemp[ccol]) {
                ++(*Q).tu;
                
                // Ԫ
                if((*Q).tu > MAXSIZE) {
                    return ERROR;
                }
                
                (*Q).data[(*Q).tu].i = arow;
                (*Q).data[(*Q).tu].j = ccol;
                (*Q).data[(*Q).tu].e = ctemp[ccol];
            }
        }
    }
    
    // Ϊrpos鸳ֵ
    AssignRpos(Q);
    
    return OK;
}

/*
 * ת
 */
Status TransposeSMatrix(RLSMatrix M, RLSMatrix* T) {
    int p, q, col;
    
    (*T).mu = M.nu;
    (*T).nu = M.mu;
    (*T).tu = M.tu;
    
    if((*T).tu) {
        q = 1;  // qTзԪļ
        
        // colMУT
        for(col = 1; col <= M.nu; ++col) {
            // MвҵjеԪأνתõT
            for(p = 1; p <= M.tu; ++p) {
                if(M.data[p].j == col) {
                    (*T).data[q].i = M.data[p].j;     // MбΪT
                    (*T).data[q].j = M.data[p].i;     // MбΪT
                    (*T).data[q].e = M.data[p].e;     // ÿԪֵ
                    
                    ++q;
                }
            }
        }
    }
    
    // Ϊrpos鸳ֵ
    AssignRpos(T);
    
    return OK;
}

/*
 * ת
 */
Status FastTransposeSMatrix(RLSMatrix M, RLSMatrix* T) {
    int col, t, p, q;
    int* num;      // num[col] ʾMcolзԪĸ
    int* copt;     // copt[col]ʾMcolеһԪתúеλ
    
    (*T).mu = M.nu;
    (*T).nu = M.mu;
    (*T).tu = M.tu;
    
    // ǰ
    if((*T).tu == 0) {
        return ERROR;
    }
    
    num  = (int*) malloc(M.nu * sizeof(int));
    copt = (int*) malloc(M.nu * sizeof(int));
    
    // ʼnum
    for(col = 1; col <= M.nu; ++col) {
        num[col] = 0;
    }
    
    // ͳMеķԪͳÿзԪĸ
    for(t = 1; t <= M.tu; ++t) {
        num[M.data[t].j]++;
    }
    
    // 1е1Ԫλתúеλ
    copt[1] = 1;
    // е1Ԫתþеλ
    for(col = 2; col <= M.nu; ++col) {
        copt[col] = copt[col - 1] + num[col - 1];
    }
    
    // ɨMеԪ
    for(p = 1; p <= M.tu; ++p) {
        col = M.data[p].j;              // 㵱ǰԪ
        q = copt[col];                  // 㵱ǰԪתþеλ
        (*T).data[q].i = M.data[p].j;
        (*T).data[q].j = M.data[p].i;
        (*T).data[q].e = M.data[p].e;
        ++copt[col];                    // ԪʱתþеλӦһòҪ
    }
    
    // Ϊrpos鸳ֵ
    AssignRpos(T);
    
    return OK;
}

/*
 * 
 */
void PrintSMatrix(RLSMatrix M) {
    int r, c;
    int k = 1;
    
    for(r = 1; r <= M.mu; ++r) {
        for(c = 1; c <= M.nu; ++c) {
            if(r == M.data[k].i && c == M.data[k].j) {
                printf("%3d ", M.data[k].e);
                k++;
            } else {
                printf("%3d ", 0);
            }
        }
        printf("\n");
    }
    
    printf("rpos = ");
    for(k = 1; k <= M.mu; ++k) {
        printf("%d ", M.rpos[k]);
    }
    printf("\n");
}

// Ϊrpos鸳ֵ
static void AssignRpos(RLSMatrix* M) {
    int k, m;
    
    // ʼrpos
    for(k = 0; k <= MAXRC; ++k) {
        (*M).rpos[k] = 0;
    }
    
    for(k = 1; k <= (*M).tu; k++) {
        m = (*M).data[k].i;     // ǰԪԪھеλ
        
        // ¼ÿеһԪԪеλ
        if((*M).rpos[m] == 0) {
            (*M).rpos[m] = k;   // ֻڵǰзԪ¼¼
        }
    }
    
    // ЩûзԪ
    for(k = (*M).mu; k >= 1; k--) {
        // ǰûзԪ˴ֱȡһеĲ
        if((*M).rpos[k] == 0) {
            // һ޷ԪΪѾһˣ⴦
            if(k == (*M).mu) {
                (*M).rpos[k] = (*M).tu + 1;
            } else {
                (*M).rpos[k] = (*M).rpos[k + 1];
            }
        }
    }
}
