#include <stdio.h>
#include "OLGraph.h"     //**07 ͼ**//

// ԺӡԪ
Status PrintElem(VertexType c) {
    printf("%c ", c);
    return OK;
}


int main(int argc, char* argv[]) {
    OLGraph G;
    
    printf(" CreateGraph \n");
    {
        char* path[4];
        
        path[0] = "TestData_DG.txt";
        path[1] = "TestData_DN.txt";
        path[2] = "TestData_UDG.txt";
        path[3] = "TestData_UDN.txt";
        
        printf("ͼ/...\n");
        CreateGraph(&G, path);
    }
    PressEnterToContinue(debug);
    
    printf(" PrintGraph \n");
    {
        printf("ͼ/ڽӾ... \n");
        PrintGraph(G);
    }
    PressEnterToContinue(debug);
    
    printf(" LocateVex \n");
    {
        VertexType u = 'X';
        printf(" '%c' λΪ %d\n", u, LocateVex(G, u));
    }
    PressEnterToContinue(debug);
    
    printf(" GetVex \n");
    {
        int v = 1;
        printf(" '%d' ĶֵΪ %c\n", v, GetVex(G, v));
    }
    PressEnterToContinue(debug);
    
    printf(" FirstAdjVex \n");
    {
        VertexType v = 'X';
        int k = FirstAdjVex(G, v);
        printf(" '%c' ĵһڽӶΪ '%c'\n", v, G.xlist[k].data);
    }
    PressEnterToContinue(debug);
    
    printf(" NextAdjVex \n");
    {
        VertexType v = 'X';
        VertexType w = 'A';
        int k = NextAdjVex(G, v, w);
        printf(" '%c' ڶ '%c' һڽӶΪ '%c'\n", v, w, G.xlist[k].data);
    }
    PressEnterToContinue(debug);
    
    printf(" DeleteVex \n");
    {
        VertexType v = 'X';
        
        printf("ɾ '%c' ...\n", v);
        DeleteVex(&G, v);
        
        PrintGraph(G);
    }
    PressEnterToContinue(debug);
    
    printf(" InsertVex \n");
    {
        VertexType v = 'Y';
        printf("붥 '%c' ...\n", v);
        InsertVex(&G, v);
        PrintGraph(G);
    }
    PressEnterToContinue(debug);
    
    printf(" InsertArc \n");
    {
        // ע<E, B>ظı
        VertexType v[10] = {'B', 'C', 'E', 'Y', 'Y', 'Y', 'D', 'D', 'E', 'E'};
        VertexType w[10] = {'Y', 'Y', 'Y', 'A', 'B', 'D', 'C', 'A', 'B', 'D'};
        InfoType info[10] = {{8}, {5}, {1}, {11}, {2}, {6}, {3}, {7}, {2}, {9}};
        int k;
        
        // ͼ
        if(G.kind == DG || G.kind == UDG) {
            for(k = 0; k < 10; k++) {
                printf("Ȩֵıߣ<%c, %c>...\n", v[k], w[k]);
                InsertArc(&G, v[k], w[k]);
            }
            
            // 
        } else if(G.kind == DN || G.kind == UDN) {
            for(k = 0; k < 10; k++) {
                printf("Ȩֵıߣ<%c, %c, %d>...\n", v[k], w[k], info[k].weight);
                InsertArc(&G, v[k], w[k], &info[k]);
            }
        } else {
            return ERROR;
        }
        
        PrintGraph(G);
    }
    PressEnterToContinue(debug);
    
    printf(" PutVex \n");
    {
        VertexType v = 'Y';
        VertexType value = 'F';
        printf("Զ '%c' ֵ '%c' ...\n", v, value);
        PutVex(&G, v, value);
        PrintGraph(G);
    }
    PressEnterToContinue(debug);
    
    printf(" DeleteArc \n");
    {
        VertexType v[3] = {'D', 'E', 'F'};
        VertexType w[3] = {'A', 'B', 'B'};
        int k;
        
        for(k = 0; k < 3; k++) {
            printf("ɾߣ<%c, %c>...\n", v[k], w[k]);
            DeleteArc(&G, v[k], w[k]);
        }
        PrintGraph(G);
    }
    PressEnterToContinue(debug);
    
    printf(" DFSTraverse \n");
    {
        printf("ȱͼ/...\n");
        DFSTraverse(G, PrintElem);
        printf("\n");
    }
    PressEnterToContinue(debug);
    
    printf(" BFSTraverse \n");
    {
        printf("ȱͼ/...\n");
        BFSTraverse(G, PrintElem);
        printf("\n");
    }
    PressEnterToContinue(debug);
    
    printf(" DestroyGraph \n");
    {
        printf("ͼ/G...\n");
        DestroyGraph(&G);
        PrintGraph(G);
    }
    PressEnterToContinue(debug);
    
}
