/*====================
 * շ
 *
 * 㷨: 6.126.13
 ====================*/

#include "HuffmanTree.h"

/*
 * ʼ
 *
 * ҪʼȨֵϢ
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status InitEnvironment(int** w, int* n, char* path) {
    FILE* fp;
    int readFromConsole;    // Ƿӿ̨ȡ
    
    // ûļ·Ϣӿ̨ȡ
    readFromConsole = path == NULL || strcmp(path, "") == 0;
    
    if(readFromConsole) {
        printf("շϢ...\n");
        Init(w, n, NULL);
    } else {
        // ļ׼ȡ
        fp = fopen(path, "r");
        if(fp == NULL) {
            return ERROR;
        }
        Init(w, n, fp);
        fclose(fp);
    }
    
    return OK;
}

/*
 *  㷨6.12 
 *
 * 
 * 1.ָnȨֵϢwշHT
 * 2.ɺշHTշֵHC
 *
 *ע
 * 㷨롾㷨6.13һ¡
 */
Status HuffmanCodeing_1(HuffmanTree* HT, HuffmanCode* HC, int* w, int n) {
    int m, i;
    HuffmanTree p;
    int s1, s2;
    char* cd;
    int start, c;
    unsigned int f;
    
    if(n <= 1) {
        return ERROR;
    }
    
    // շ
    m = 2 * n - 1;
    
    *HT = (HuffmanTree) malloc((m + 1) * sizeof(HTNode));   // 0ŵԪδʹãweight¼ԭʼȨֵ
    (*HT)[0].weight = n;
    
    // ¼ȨֵϢעpӦָ1Ϊ0ŵԪˣ̲дָ0ŵԪ
    for(p = (*HT) + 1, i = 1; i <= n; ++i, ++p, ++w) {
        (*p).weight = *w;
        (*p).parent = 0;
        (*p).lchild = 0;
        (*p).rchild = 0;
    }
    
    // ĲҪ
    for(; i <= m; ++i, ++p) {
        (*p).weight = 0;
        (*p).parent = 0;
        (*p).lchild = 0;
        (*p).rchild = 0;
    }
    
    // շ
    for(i = n + 1; i <= m; ++i) {
        // HT[1,i-1]ѡparentΪ0δweightС㣬ŷֱΪs1s2
        Select(*HT, i - 1, &s1, &s2);
        
        (*HT)[s1].parent = i;
        (*HT)[s2].parent = i;
        (*HT)[i].lchild = s1;
        (*HT)[i].rchild = s2;
        (*HT)[i].weight = (*HT)[s1].weight + (*HT)[s2].weight;
    }
    
    
    /* Ҷӵÿַĺշ */
    
    (*HC) = (HuffmanCode) malloc((n + 1) * sizeof(char*));  // nַͷָ0ŵԪã
    cd = (char*) malloc(n * sizeof(char));  // Ĺռ䣨ÿ볤Ϊn-1
    cd[n - 1] = '\0';   // 
    
    // ַշ
    for(i = 1; i <= n; ++i) {
        start = n - 1;    // λ
        
        // Ҷӵ
        for(c = i, f = (*HT)[i].parent; f != 0; c = f, f = (*HT)[f].parent) {
            if((*HT)[f].lchild == c) {
                cd[--start] = '0';
            } else {
                cd[--start] = '1';
            }
        }
        
        (*HC)[i] = (char*) malloc((n - start) * sizeof(char));  // Ϊiַռ
        strcpy((*HC)[i], &cd[start]);   // cdƱ루HC
    }
    
    free(cd);   // ͷŹռ
    
    return OK;
}

/*
 *  㷨6.13 
 *
 * 
 * 1.ָnȨֵϢwշHT
 * 2.շHTշֵHC
 *
 *ע
 * 㷨롾㷨6.12һ¡
 */
Status HuffmanCodeing_2(HuffmanTree* HT, HuffmanCode* HC, int* w, int n) {
    int m, i;
    HuffmanTree p;
    int s1, s2;
    unsigned int r;
    int cdlen;
    char* cd;
    HuffmanTree H;  // HTһ
    
    if(n <= 1) {
        return ERROR;
    }
    
    // շ
    m = 2 * n - 1;
    
    *HT = (HuffmanTree) malloc((m + 1) * sizeof(HTNode));   // 0ŵԪδʹãweight¼ԭʼȨֵ
    (*HT)[0].weight = n;
    
    // ¼ȨֵϢעpӦָ1Ϊ0ŵԪˣ̲дָ0ŵԪ
    for(p = (*HT) + 1, i = 1; i <= n; ++i, ++p, ++w) {
        (*p).weight = *w;
        (*p).parent = 0;
        (*p).lchild = 0;
        (*p).rchild = 0;
    }
    
    // ĲҪ
    for(; i <= m; ++i, ++p) {
        (*p).weight = 0;
        (*p).parent = 0;
        (*p).lchild = 0;
        (*p).rchild = 0;
    }
    
    // շ
    for(i = n + 1; i <= m; ++i) {
        // HT[1,i-1]ѡparentΪ0δweightС㣬ŷֱΪs1s2
        Select(*HT, i - 1, &s1, &s2);
        
        (*HT)[s1].parent = i;
        (*HT)[s2].parent = i;
        (*HT)[i].lchild = s1;
        (*HT)[i].rchild = s2;
        (*HT)[i].weight = (*HT)[s1].weight + (*HT)[s2].weight;
    }
    
    
    /* ջǵݹշշ */
    
    (*HC) = (HuffmanCode) malloc((n + 1) * sizeof(char*));  // nַͷָ0ŵԪã
    cd = (char*) malloc(n * sizeof(char));  // Ĺռ䣨ÿ볤Ϊn-1
    
    r = m;
    cdlen = 0;
    
    // ٺշĸϽв
    H = (HuffmanTree) malloc((m + 1) * sizeof(HTNode));
    for(i = 0; i <= m; ++i) {
        H[i] = (*HT)[i];
        H[i].weight = 0;
    }
    
    while(r != 0) {
        // һηʴ˽㣬Ҫ
        if(H[r].weight == 0) {
            H[r].weight = 1;
            
            // 
            if(H[r].lchild != 0) {
                // һ
                r = H[r].lchild;
                cd[cdlen++] = '0';
                
                // ӣҲҺӣҶӽ
            } else if(H[r].rchild == 0) {
                (*HC)[r] = (char*) malloc((cdlen + 1) * sizeof(char));
                cd[cdlen] = '\0';
                strcpy((*HC)[r], cd);   // Ʊ봮
            }
            
            // ڶηʴ˽㣬Ҫұ
        } else if(H[r].weight == 1) {
            H[r].weight = 2;
            
            if(H[r].rchild != 0) {
                r = H[r].rchild;
                cd[cdlen++] = '1';
            }
            
            // ηʣҪ˵
        } else {
            r = H[r].parent;    // ˻ص
            cdlen--;                // 볤ȼ1
        }
    }
    
    return OK;
}

/*
 * 
 * ݸnշHCȨֵ
 */
Status HuffmanDecoding(HuffmanTree HT, HuffmanCode HC, int** w, int n) {
    int i, j, k;
    int r;
    char* s;
    
    if(n <= 0) {
        return ERROR;
    }
    
    (*w) = (int*) malloc(n * sizeof(int));
    
    // λ
    r = 2 * n - 1;
    
    for(i = 1; i <= n; i++) {
        s = HC[i];
        
        k = r;
        
        // Ӹ
        for(j = 0; j < strlen(s); j++) {
            if(s[j] == '0') {
                k = HT[k].lchild;   // 
            } else if(s[j] == '1') {
                k = HT[k].rchild;   // 
            } else {
                return ERROR;
            }
        }
        
        (*w)[i - 1] = HT[k].weight;
    }
    
    return OK;
}


/* ڲʹõĺ */

// ʼڲʵ
static Status Init(int** w, int* n, FILE* fp) {
    int i;
    
    if(fp == NULL) {
        printf("շҶӽ");
        scanf("%d", n);
        
        if(*n <= 0) {
            *w = NULL;
            return ERROR;
        }
        
        *w = (int*) malloc((*n) * sizeof(int));
        
        printf(" %d ȨֵϢ", *n);
        for(i = 0; i < *n; i++) {
            scanf("%d", *w + i);
        }
    } else {
        // ¼Ԫ
        ReadData(fp, "%d", n);
        
        if(*n <= 0) {
            *w = NULL;
            return ERROR;
        }
        
        *w = (int*) malloc((*n) * sizeof(int));
        
        // ¼ȨֵϢ
        for(i = 0; i < *n; i++) {
            ReadData(fp, "%d", *w + i);
        }
    }
    
    return OK;
}

// ںշ[1...end]ѡȨֵСδs1s2
static void Select(HuffmanTree HT, int end, int* s1, int* s2) {
    int i;
    int w1, w2;
    
    w1 = w2 = INT_MAX;
    
    for(i = 1; i <= end; i++) {
        // ѾĽ
        if(HT[i].parent != 0) {
            continue;
        }
        
        if(HT[i].weight < w1) {
            *s2 = *s1;
            w2 = w1;
            
            *s1 = i;
            w1 = HT[i].weight;
        } else if(HT[i].weight >= w1 && HT[i].weight < w2) {
            *s2 = i;
            w2 = HT[i].weight;
        } else {
            // HT[i].weight>=w2
        }
    }
}


/* ͼλ */

// ӡշṹ
void PrintHuffmanTree(HuffmanTree HT) {
    int i;
    
    printf("+-------+--------+--------+--------+--------+\n");
    printf("| index | weight | parent | lchild | rchild |\n");
    printf("+-------+--------+--------+--------+--------+\n");
    printf("|  %3d  |  %4d  |        |        |        |\n", 0, HT[0].weight);
    printf("+-------+--------+--------+--------+--------+\n");
    for(i = 1; i <= 2 * HT[0].weight - 1; i++) {
        printf("|  %3d  |  %4d  |   %2d   |   %2d   |   %2d   |\n", i, HT[i].weight, HT[i].parent, HT[i].lchild, HT[i].rchild);
    }
    printf("+-------+--------+--------+--------+--------+\n");
}

// ӡշ롣
void PrintHuffmanCode(HuffmanTree HT, HuffmanCode HC) {
    int i;
    
    printf("+-------+--------+-------------\n");
    printf("| index | weight | HuffmanCode \n");
    printf("+-------+--------+-------------\n");
    printf("|  %3d  |  %4d  | \n", 0, HT[0].weight);
    printf("+-------+--------+-------------\n");
    for(i = 1; i <= HT[0].weight; i++) {
        printf("|  %3d  |  %4d  -> %s\n", i, HT[i].weight, HC[i]);
    }
    printf("+-------+--------+-------------\n");
}

// ӡշӦȨֵϢ
void PrintWeight(HuffmanCode HC, int* w, int n) {
    int i;
    
    printf("+-------+-------------+--------+\n");
    printf("| index | HuffmanCode | weight |\n");
    printf("+-------+-------------+--------+\n");
    for(i = 1; i <= n; i++) {
        printf("|  %3d  | %11s |  %4d  |\n", i, HC[i], w[i - 1]);
    }
    printf("+-------+-------------+--------+\n");
}
