/*===================================
 * Ķ-ֵܣṹ洢ʾ
 ====================================*/

#ifndef CSTREE_H
#define CSTREE_H

#include <stdio.h>
#include <stdlib.h>     // ṩ mallocfree ԭ
#include <string.h>     // ṩ memsetstrcmp ԭ
#include "Status.h"     //**01 **//

/* ĺ */
#define MAX_CHILD_COUNT 8

/* ԪͶ壬ԪΪchar */
typedef char TElemType;

/* (-ֵ)Ľ㶨 */
typedef struct CSNode {
    TElemType data;
    struct CSNode* firstchild;  // ָ
    struct CSNode* nextsibling; // ֵָ
} CSNode;

/* (-ֵ)Ͷ */
typedef CSNode* CSTree;


/*
 * ʼ
 *
 * 
 */
Status InitTree(CSTree* T);

/*
 * 
 *
 * ͷռڴ档
 *
 *ע
 * ÿղһµ
 */
Status DestroyTree(CSTree* T);

/*
 * ÿ
 *
 * еݣʹΪ
 */
Status ClearTree(CSTree* T);

/*
 * 
 *
 * ԤĶ
 * ԼʹáС
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateTree(CSTree* T, char* path);

/*
 * п
 *
 * жǷΪ
 */
Status TreeEmpty(CSTree T);

/*
 * 
 *
 * ȣ
 */
int TreeDepth(CSTree T);

/*
 * ȡֵ
 *
 * ֵָ
 */
TElemType Value(CSTree T, TElemType e);

/*
 * ֵ
 *
 * ΪָĽ㸳ֵ
 */
Status Assign(CSTree T, TElemType e, TElemType value);

/*
 * 
 *
 * ĸ㡣
 */
TElemType Root(CSTree T);

/*
 * ˫
 *
 * нe˫׽㡣
 */
TElemType Parent(CSTree T, TElemType e);

/*
 * 
 *
 * Tнeĺ
 */
int ChildCount(CSTree T, TElemType e);

/*
 * 
 *
 * нeĵiӡ
 */
TElemType Child(CSTree T, TElemType e, int i);

/*
 * ֵ
 *
 * нeֵܽ㡣
 */
TElemType LeftSibling(CSTree T, TElemType e);

/*
 * ֵ
 *
 * нeֵܽ㡣
 */
TElemType RightSibling(CSTree T, TElemType e);

/*
 * 
 *
 * cΪTpĵiӡ
 */
Status InsertChild(CSTree* T, TElemType p, int i, CSTree c);

/*
 * ɾ
 *
 * ɾTpĵiӡ
 */
Status DeleteChild(CSTree* T, TElemType p, int i);

/*
 * 
 */
Status PreOrderTraverse(CSTree T, Status(Visit)(TElemType));

/*
 * 
 */
Status PostOrderTraverse(CSTree T, Status(Visit)(TElemType));

/*
 * 
 */
Status LevelOrderTraverse(CSTree T, Status(Visit)(TElemType));


/* ڲʹõĺ */

// ڲ
static void Create(CSTree* T, FILE* fp);

// ȵڲʵ
static void Depth(CSTree T, int d, int *max);

// eָ룬ڣNULL
static CSTree EPtr(CSTree T, TElemType e);

// e˫׽ָ룬ڣNULL
static CSTree PPtr(CSTree T, TElemType e);

// eĵiӵָ룬ڣNULL
static CSTree CPtr(CSTree T, TElemType e, int i);

// ڲʵ
static Status PreTraverse(CSTree T, Status(Visit)(TElemType));

// ڲʵ
static Status PostTraverse(CSTree T, Status(Visit)(TElemType));


/* ͼλ */

// ͼλʽǰṹ
void PrintTree(CSTree T);

// ͼλǰṹڲʵ
static void Print(CSTree T, int row);

#endif
