/*=============================
 * ĺ(˫)Ĵ洢ʾ
 =============================*/

#include "CTree.h"

/*
 * ʼ
 *
 * 
 */
Status InitTree(CTree* T) {
    if(T == NULL) {
        return ERROR;
    }
    
    T->n = 0;
    
    // 
    memset(T->nodes, 0, sizeof(T->nodes));
    
    return OK;
}

/*
 * 
 *
 * ͷռڴ档
 *
 *ע
 * ÿղһµ
 */
Status DestroyTree(CTree* T) {
    // ٣ʹÿվͿ
    return ERROR;
}

/*
 * ÿ
 *
 * еݣʹΪ
 */
Status ClearTree(CTree* T) {
    int k;
    ChildPtr p, q;
    
    if(T == NULL) {
        return ERROR;
    }
    
    // ͷźӽռõĿռ
    for(k = T->r; k != (T->r + T->n) % MAX_TREE_SIZE; k = (k + 1) % MAX_TREE_SIZE) {
        p = T->nodes[k].firstchild;
        
        while(p != NULL) {
            q = p;
            p = p->next;
            free(q);
        }
    }
    
    // Ԫ㼴
    T->n = 0;
    
    // 
    memset(T->nodes, 0, sizeof(T->nodes));
    
    return OK;
}

/*
 * 
 *
 * ԤĶ
 * ԼʹáС
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateTree(CTree* T, char* path) {
    FILE* fp;
    int readFromConsole;    // Ƿӿ̨ȡ
    
    // ûļ·Ϣӿ̨ȡ
    readFromConsole = path == NULL || strcmp(path, "") == 0;
    
    if(readFromConsole) {
        printf("ԪϢڿս㣬ʹ^...\n");
        Create(T, NULL);
    } else {
        // ļ׼ȡ
        fp = fopen(path, "r");
        if(fp == NULL) {
            return ERROR;
        }
        Create(T, fp);
        fclose(fp);
    }
    
    return OK;
}

/*
 * п
 *
 * жǷΪ
 */
Status TreeEmpty(CTree T) {
    return T.n == 0 ? TRUE : FALSE;
}

/*
 * 
 *
 * ȣ
 */
int TreeDepth(CTree T) {
    int k, level;
    
    // 
    if(TreeEmpty(T)) {
        return 0;
    }
    
    /*
     * kʼΪһλ
     * Ľ㰴洢洢Ľضλ
     */
    k = (T.r + T.n - 1) % MAX_TREE_SIZE;
    level = 0;
    
    do {
        level++;
        k = T.nodes[k].parent;
    } while(k != -1);
    
    return level;
}

/*
 * ȡֵ
 *
 * ֵָ
 */
TElemType Value(CTree T, TElemType e) {
    int p;
    
    // 
    if(TreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe
    p = EIndex(T, e);
    
    // ûҵԪe
    if(p == -1) {
        return '\0';
    } else {
        return T.nodes[p].data;
    }
}

/*
 * ֵ
 *
 * ΪָĽ㸳ֵ
 */
Status Assign(CTree* T, TElemType e, TElemType value) {
    int p;
    
    // 
    if(TreeEmpty(*T)) {
        return ERROR;
    }
    
    // ȡe
    p = EIndex(*T, e);
    
    // ûҵԪe
    if(p == -1) {
        return ERROR;
    } else {
        // иֵ
        T->nodes[p].data = value;
        return OK;
    }
}

/*
 * 
 *
 * ĸ㡣
 */
TElemType Root(CTree T) {
    // 
    if(TreeEmpty(T)) {
        return '\0';
    }
    
    return T.nodes[T.r].data;
}

/*
 * ˫
 *
 * нe˫׽㡣
 */
TElemType Parent(CTree T, TElemType e) {
    int p, parent;
    
    // 
    if(TreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe
    p = EIndex(T, e);
    
    // ûҵԪe
    if(p == -1) {
        return '\0';
    } else {
        parent = T.nodes[p].parent;
        
        // ˫
        if(parent == -1) {
            return '\0';
        } else {
            return T.nodes[parent].data;
        }
    }
}

/*
 * 
 *
 * Tнeĺ
 */
int ChildCount(CTree T, TElemType e) {
    int p, count;
    ChildPtr r;
    
    // 
    if(TreeEmpty(T)) {
        return -1;
    }
    
    // ȡe
    p = EIndex(T, e);
    // e
    if(p == -1) {
        return -1;
    }
    
    r = T.nodes[p].firstchild;
    count = 0;
    
    // ͳƽeĺ
    while(r != NULL) {
        count++;
        r = r->next;
    }
    
    return count;
}

/*
 * 
 *
 * нeĵiӡ
 */
TElemType Child(CTree T, TElemType e, int i) {
    int p;
    
    // 
    if(TreeEmpty(T)) {
        return '\0';
    }
    
    // iķΧԽ
    if(i < 1 || i > MAX_CHILD_COUNT) {
        return '\0';
    }
    
    // ȡeĵi
    p = CIndex(T, e, i);
    // eiӲ
    if(p == -1) {
        return '\0';
    }
    
    return T.nodes[p].data;
}

/*
 * ֵ
 *
 * нeֵܽ㡣
 *
 *ע
 * Ľܻӣ
 * ֵָ߽ڸýֵܡ
 */
TElemType LeftSibling(CTree T, TElemType e) {
    int p, ls;
    
    // 
    if(TreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe
    p = EIndex(T, e);
    // e
    if(p == -1) {
        return '\0';
    }
    
    // ֵ
    ls = (p - 1 + MAX_TREE_SIZE) % MAX_TREE_SIZE;
    
    // ýЧe˫ͬ˵ֵ
    if(ls != p && T.nodes[ls].data != '\0' && T.nodes[ls].parent == T.nodes[p].parent) {
        return T.nodes[ls].data;
    }
    
    return '\0';
}

/*
 * ֵ
 *
 * нeֵܽ㡣
 *
 *ע
 * Ľܻӣ
 * ֵָұ߽ڸýֵܡ
 */
TElemType RightSibling(CTree T, TElemType e) {
    int p, rs;
    
    // 
    if(TreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe
    p = EIndex(T, e);
    // e
    if(p == -1) {
        return '\0';
    }
    
    // ֵ
    rs = (p + 1) % MAX_TREE_SIZE;
    
    // ýЧe˫ͬ˵ֵ
    if(rs != p && T.nodes[rs].data != '\0' && T.nodes[rs].parent == T.nodes[p].parent) {
        return T.nodes[rs].data;
    }
    
    return '\0';
}

/*
 * 
 *
 * cΪTpĵiӡ
 */
Status InsertChild(CTree* T, TElemType p, int i, CTree c) {
    Pos pt[MAX_TREE_SIZE], pc[MAX_TREE_SIZE];
    int pIndex;
    int lastChild, bound;
    int level;
    int m, n, k;
    int tCur, cCur;
    
    CTree R;
    int tParent[MAX_TREE_SIZE], cParent[MAX_TREE_SIZE];
    int x, y, z;
    
    ChildPtr cp, s;
    int count;
    
    // Ϊ
    if(TreeEmpty(*T) || TreeEmpty(c)) {
        return ERROR;
    }
    
    // iķΧС
    if(i < 1) {
        return ERROR;
    }
    
    // ȡp
    pIndex = EIndex(*T, p);
    
    // p㲻ڣ򷵻شʾ
    if(pIndex == -1) {
        return ERROR;
    }
    
    // TнλϢ
    getPos(*T, pt);
    
    // pһӵ
    lastChild = pt[pIndex].lastChild;
    
    // iķΧ
    if(lastChild != -1 && i > pt[lastChild].childIndex + 1) {
        return ERROR;
    }
    
    if(i == 1) {
        // pǵһ
        if(pt[pIndex].childIndex == 1) {
            bound = -1;
        } else {
            // pֵ
            for(k = (pIndex - 1) % MAX_TREE_SIZE; pt[k].lastChild == -1 && pt[k].childIndex != 1; k = (k - 1) % MAX_TREE_SIZE) {
                // ұ߽ĸ
            }
            
            // Ѿòһ㣬ýȻûк
            if(pt[k].lastChild == -1) {
                bound = -1;
            } else {
                bound = pt[k].lastChild;    // kһӵ
            }
        }
    } else {
        // pûк
        if(lastChild == -1) {
            return ERROR;
        } else {
            for(k = pt[pIndex].lastChild; pt[k].childIndex != i - 1; k = (k - 1) % MAX_TREE_SIZE) {
                // Ҳλõǰһӵ
            }
            bound = k;
        }
    }
    
    level = pt[pIndex].row + 1;   // ĸڵ
    
    // cнλϢ
    getPos(c, pc);
    // ²иԪص
    for(k = c.r; k != (c.r + c.n) % MAX_TREE_SIZE; k = (k + 1) % MAX_TREE_SIZE) {
        pc[k].row += level - 1;
    }
    
    // tCurָlevelеĵһ
    for(tCur = pIndex; tCur != (T->r + T->n) % MAX_TREE_SIZE; tCur = (tCur + 1) % MAX_TREE_SIZE) {
        if(pt[tCur].row == level) {
            break;
        }
    }
    
    // cCurָcеĸ㣬øҲӦ뵽Tеlevel
    cCur = c.r;
    
    while(tCur != (T->r + T->n) % MAX_TREE_SIZE && cCur != (c.r + c.n) % MAX_TREE_SIZE) {
        // Tҽǰ벿
        if(bound != -1) {
            tCur = (bound + 1) % MAX_TREE_SIZE;
        }
        
        if(bound == -1) {
            m = 0;
        } else {
            m = pt[bound].col;
        }
        
        n = 0;
        
        // c뵽Tм
        while(cCur != (c.r + c.n) % MAX_TREE_SIZE && pc[cCur].row == level) {
            // ı
            
            pc[cCur].col += m;
            n++;
            
            cCur++;
        }
        
        // Tĺ벿
        while(tCur != (T->r + T->n) % MAX_TREE_SIZE && pt[tCur].row == level) {
            
            pt[tCur].col += n;
            
            tCur++;
        }
        
        // һı߽
        if(bound != -1) {
            // bound
            for(k = bound; pt[k].lastChild == -1 && pt[k].childIndex != 1; k = (k - 1) % MAX_TREE_SIZE) {
                // ұ߽ĸ
            }
            
            // Ѿòһ㣬ýȻûк
            if(pt[k].lastChild == -1) {
                bound = -1;
            } else {
                bound = pt[k].lastChild;    // kһӵ
            }
        }
        
        level++;
    }
    
    // posϢ
//    printPos(*T, pt);
//    printPos(c, pc);
    
    InitTree(&R);
    
    R.r = T->r;
    n = 0;
    
    x = T->r;   // Tα
    y = c.r;    // cα
    z = R.r;    // Rα
    
    while(x != (T->r + T->n) % MAX_TREE_SIZE && y != (c.r + c.n) % MAX_TREE_SIZE) {
        if(pt[x].row < pc[y].row || (pt[x].row == pc[y].row && pt[x].col < pc[y].col)) {
            
            // ¼xλ
            tParent[x] = z;
            
            // ЧԪطŵλ
            R.nodes[z] = T->nodes[x];
            
            if(R.nodes[z].parent != -1) {
                // ¸λ
                R.nodes[z].parent = tParent[R.nodes[z].parent];
                
                // ָ򸸽ĵһ
                cp = R.nodes[R.nodes[z].parent].firstchild;
                
                // ǰ㲻ǵһӣҪѯȷλ
                if(pt[x].childIndex != 1) {
                    for(count = 1; count < pt[x].childIndex; count++) {
                        cp = cp->next;
                    }
                }
                
                /*
                 * µǰںеλ
                 *
                 * ע˴ĸ»ʹλñ󣬹Ҫ⸲ǺԪֵķ֧Դ
                 */
                cp->child = z;
            }
            
            x = (x + 1) % MAX_TREE_SIZE;
        } else if(pt[x].row > pc[y].row || (pt[x].row == pc[y].row && pt[x].col > pc[y].col)) {
            // ¼yλ
            cParent[y] = z;
            
            // ЧԪطŵλ
            R.nodes[z] = c.nodes[y];
            
            if(R.nodes[z].parent != -1) {
                // ¸λ
                R.nodes[z].parent = cParent[R.nodes[z].parent];
                
                // ָ򸸽ĵһ
                cp = R.nodes[R.nodes[z].parent].firstchild;
                
                // ǰ㲻ǵһӣҪѯȷλ
                if(pc[y].childIndex != 1) {
                    for(count = 1; count < pc[y].childIndex; count++) {
                        cp = cp->next;
                    }
                }
                
                // µǰںеλ
                cp->child = z;
            } else {
                // һ𣬼cĸĸΪp
                R.nodes[z].parent = tParent[pIndex];
                
                // װǰ
                s = (ChildPtr) malloc(sizeof(CTNode));
                s->child = z;
                
                // ָýĸ׸
                cp = R.nodes[R.nodes[z].parent].firstchild;
                
                if(cp == NULL || i == 1) {
                    s->next = R.nodes[R.nodes[z].parent].firstchild;
                    R.nodes[R.nodes[z].parent].firstchild = s;
                } else {
                    // 
                    count = 1;
                    
                    // ҵi-1
                    while(cp != NULL && count < i - 1) {
                        count++;
                        cp = cp->next;
                    }
                    
                    s->next = cp->next;
                    cp->next = s;
                }
            }
            
            y = (y + 1) % MAX_TREE_SIZE;
        }
        
        z = (z + 1) % MAX_TREE_SIZE;
        n++;
    }
    
    while(x != (T->r + T->n) % MAX_TREE_SIZE) {
        // ¼kλ
        tParent[x] = z;
        
        // ЧԪطŵλ
        R.nodes[z] = T->nodes[x];
        
        if(R.nodes[z].parent != -1) {
            // ¸λ
            R.nodes[z].parent = tParent[R.nodes[z].parent];
            
            // ָ򸸽׸
            cp = R.nodes[R.nodes[z].parent].firstchild;
            
            // ǰ㲻ǵһӣҪѯȷλ
            if(pt[x].childIndex != 1) {
                for(count = 1; count < pt[x].childIndex; count++) {
                    cp = cp->next;
                }
            }
            
            // µǰںеλ
            cp->child = z;
        }
        
        x = (x + 1) % MAX_TREE_SIZE;
        z = (z + 1) % MAX_TREE_SIZE;
        n++;
    }
    
    while(y != (c.r + c.n) % MAX_TREE_SIZE) {
        // ¼kλ
        cParent[y] = z;
        
        // ЧԪطŵλ
        R.nodes[z] = c.nodes[y];
        
        if(R.nodes[z].parent != -1) {
            // ¸λ
            R.nodes[z].parent = cParent[R.nodes[z].parent];
            
            // ָ򸸽׸
            cp = R.nodes[R.nodes[z].parent].firstchild;
            
            // ǰ㲻ǵһӣҪѯȷλ
            if(pc[y].childIndex != 1) {
                for(count = 1; count < pc[y].childIndex; count++) {
                    cp = cp->next;
                }
            }
            
            // µǰںеλ
            cp->child = z;
        } else {
            // һ𣬼cĸĸΪp
            R.nodes[z].parent = tParent[pIndex];
            
            // װǰ
            s = (ChildPtr) malloc(sizeof(CTNode));
            s->child = z;
            
            // ָýĸ׸
            cp = R.nodes[R.nodes[z].parent].firstchild;
            
            if(cp == NULL || i == 1) {
                s->next = R.nodes[R.nodes[z].parent].firstchild;
                R.nodes[R.nodes[z].parent].firstchild = s;
            } else {
                // 
                count = 1;
                
                // ҵi-1
                while(cp != NULL && count < i - 1) {
                    count++;
                    cp = cp->next;
                }
                
                s->next = cp->next;
                cp->next = s;
            }
        }
        
        y = (y + 1) % MAX_TREE_SIZE;
        z = (z + 1) % MAX_TREE_SIZE;
        n++;
    }
    
    R.n = n;
    *T = R;
    
    return OK;
}

/*
 * ɾ
 *
 * ɾTpĵiӡ
 */
Status DeleteChild(CTree* T, TElemType p, int i) {
    LinkQueue Q;
    QElemType e;    // Ԫָʾλ
    
    int index;
    int k, m, n;
    
    CTree R;
    int parent[MAX_TREE_SIZE];
    ChildPtr cp, q, s;
    
    // ɾΪ
    if(TreeEmpty(*T)) {
        return ERROR;
    }
    
    // iķΧԽ磨жϣ
    if(i < 1 || i > MAX_CHILD_COUNT) {
        return ERROR;
    }
    
    // ȡpĵi
    index = CIndex(*T, p, i);
    
    // ɾ㲻ڣ򷵻شʾ
    if(index == -1) {
        return ERROR;
    }
    
    // ָǰĸĵһ
    cp = T->nodes[T->nodes[index].parent].firstchild;
    
    // ڸҵ˵ǰӲƳ
    if(cp->child==index) {
        T->nodes[T->nodes[index].parent].firstchild = cp->next;
    } else {
        // ڸвҵǰӲƳһҵ
        while(cp != NULL && cp->child!=index) {
            s = cp;
            cp = cp->next;
        }
        
        s->next = cp->next;
    }
    free(cp);
    
    InitQueue(&Q);
    
    // ɾĸ
    EnQueue(&Q, index);
    
    while(!QueueEmpty(Q)) {
        DeQueue(&Q, &e);    // λó
        
        // Ĩǰ
        T->nodes[e].data = '\0';
        
        // ָýĺ
        cp = T->nodes[e].firstchild;
    
        // ͷŸý㴦ĺռڴ
        while(cp != NULL) {
            EnQueue(&Q, cp->child); // ǰλ
            
            q = cp;
            cp = cp->next;
            free(q);
        }
        
        T->nodes[e].firstchild = NULL;
    }
    
    InitTree(&R);
    
    R.r = T->r;
    n = 0;
    
    m = R.r;    // Rα
    
    for(k = T->r; k != (T->r + T->n) % MAX_TREE_SIZE; k = (k + 1) % MAX_TREE_SIZE) {
        if(T->nodes[k].data != '\0') {
            // ¼kλ
            parent[k] = m;
            
            // ЧԪطŵλ
            R.nodes[m] = T->nodes[k];
            
            if(R.nodes[m].parent!=-1) {
                // ¸λ
                R.nodes[m].parent = parent[R.nodes[m].parent];
    
                // ָ򸸽׸
                cp = R.nodes[R.nodes[m].parent].firstchild;
    
                // ڸĺвҵǰ
                while(cp->child != k) {
                    cp = cp->next;
                }
                
                /*
                 * µǰںеλ
                 *
                 * עֵλֻµСԲõĸǺԪλ
                 * ڲҸúʱҪȡInsertChildеĲ
                 */
                cp->child = m;
            }
            
            m = (m + 1) % MAX_TREE_SIZE;
            n++;
        }
    }
    
    R.n = n;
    *T = R;
    
    return OK;
}

/*
 * 
 */
Status PreOrderTraverse(CTree T, Status(Visit)(TElemType)) {
    // 
    if(TreeEmpty(T)) {
        printf("\n");
        return ERROR;
    }
    
    PreTraverse(T, T.r, Visit);
    
    printf("\n");
    
    return OK;
}

/*
 * 
 */
Status PostOrderTraverse(CTree T, Status(Visit)(TElemType)) {
    // 
    if(TreeEmpty(T)) {
        printf("\n");
        return ERROR;
    }
    
    PostTraverse(T, T.r, Visit);
    
    printf("\n");
    
    return OK;
}

/*
 * 
 */
Status LevelOrderTraverse(CTree T, Status(Visit)(TElemType)) {
    int i;
    
    // 
    if(TreeEmpty(T)) {
        printf("\n");
        return ERROR;
    }
    
    // ˳αԪ
    for(i = T.r; i != (T.r + T.n) % MAX_TREE_SIZE; i = (i + 1) % MAX_TREE_SIZE) {
        if(!Visit(T.nodes[i].data)) {
            return ERROR;
        }
    }
    
    printf("\n");
    
    return OK;
}


/* ڲʹõĺ */

// ڲ
static void Create(CTree* T, FILE* fp) {
    int r;          // ĸλã
    int n;          // ¼Ԫ
    int cur;        // α
    TElemType ch;
    LinkQueue Q;
    QElemType e;    // Ԫָʾλ
    char s[MAX_CHILD_COUNT + 1];
    int i;
    ChildPtr p, pc;
    
    InitQueue(&Q);
    
    n = 0;
    
    // ȡλ
    if(fp == NULL) {
        printf("λ(0~%d)", MAX_TREE_SIZE - 1);
        scanf("%d", &r);
        cur = r;
        
        printf("ֵ");
        scanf("%s", s);
        ch = s[0];
        
        // 
        EnQueue(&Q, cur);
        T->nodes[cur].data = ch;
        T->nodes[cur].parent = -1;
        T->nodes[cur].firstchild = NULL;
        cur = (cur + 1) % MAX_TREE_SIZE;
        n++;
        
        while(!QueueEmpty(Q)) {
            DeQueue(&Q, &e);    // λó
            
            printf(" %c ĺӽ㣬ںʱһ^", T->nodes[e].data);
            scanf("%s", s);
            for(i = 0; i < strlen(s); i++) {
                if(s[i] == '^') {
                    break;
                }
                
                EnQueue(&Q, cur); // ǰλ
                T->nodes[cur].data = s[i];
                T->nodes[cur].parent = e;
                T->nodes[cur].firstchild = NULL;
                
                // ĳ
                p = T->nodes[e].firstchild;
                
                // װǰ
                pc = (ChildPtr) malloc(sizeof(CTNode));
                pc->child = cur;
                pc->next = NULL;
                
                // ǰӵĺ
                if(p == NULL) {
                    T->nodes[e].firstchild = pc;
                } else {
                    // ҵβ
                    while(p->next != NULL) {
                        p = p->next;
                    }
                    
                    p->next = pc;
                }
                
                cur = (cur + 1) % MAX_TREE_SIZE;
                n++;
            }
        }
    } else {
        // ¼λ
        ReadData(fp, "%d", &r);
        cur = r;
        
        // ¼ֵ
        ReadData(fp, "%s", s);
        ch = s[0];
        printf("¼ֵ%c\n", ch);
        
        // 
        EnQueue(&Q, cur);
        T->nodes[cur].data = ch;
        T->nodes[cur].parent = -1;
        T->nodes[cur].firstchild = NULL;
        cur = (cur + 1) % MAX_TREE_SIZE;
        n++;
        
        while(!QueueEmpty(Q)) {
            ReadData(fp, "%s", s);
            ch = s[0];
            printf("¼ %c ĺӣ", ch);
            
            // ¼뺢ӽ
            ReadData(fp, "%s", s);
            printf("%s\n", s);
            
            DeQueue(&Q, &e);    // λó
            
            // 
            for(i = 0; i < strlen(s); i++) {
                if(s[i] == '^') {
                    break;
                }
                
                EnQueue(&Q, cur); // ǰλ
                T->nodes[cur].data = s[i];
                T->nodes[cur].parent = e;
                T->nodes[cur].firstchild = NULL;
                
                // װǰ
                pc = (ChildPtr) malloc(sizeof(CTNode));
                pc->child = cur;
                pc->next = NULL;
                
                // ĳ
                p = T->nodes[e].firstchild;
                
                // ǰӵĺ
                if(p == NULL) {
                    T->nodes[e].firstchild = pc;
                } else {
                    // ҵβ
                    while(p->next != NULL) {
                        p = p->next;
                    }
                    
                    p->next = pc;
                }
                
                cur = (cur + 1) % MAX_TREE_SIZE;
                n++;
            }
        }
    }
    
    T->r = r;
    T->n = n;
}

// eڣ-1
static int EIndex(CTree T, TElemType e) {
    int i = T.r;    // ָ
    int p = -1;
    
    // 
    if(TreeEmpty(T)) {
        return -1;
    }
    
    // вҽe
    while(i != (T.r + T.n) % MAX_TREE_SIZE) {
        if(T.nodes[i].data == e) {
            p = i;
            break;
        }
        
        i = (i + 1) % MAX_TREE_SIZE;
    }
    
    return p;
}

// eĵiڣ-1
static int CIndex(CTree T, TElemType e, int i) {
    int p, count;
    ChildPtr s;
    
    // 
    if(TreeEmpty(T)) {
        return -1;
    }
    
    // iķΧԽ
    if(i < 1 || i > MAX_CHILD_COUNT) {
        return -1;
    }
    
    // ȡe
    p = EIndex(T, e);
    // e
    if(p == -1) {
        return -1;
    }
    
    // ָý׸
    s = T.nodes[p].firstchild;
    // 
    count = 1;
    
    while(s != NULL && count < i) {
        count++;
        s = s->next;
    }
    
    if(s != NULL) {
        return s->child;
    } else {
        return -1;
    }
}

// ȡTĽϢЩϢPos͵Ķ
static void getPos(CTree T, Pos pt[]) {
    LinkQueue Q;
    QElemType e;
    ChildPtr cp;
    
    int level, n, count;
    
    memset(pt, 0, MAX_TREE_SIZE * sizeof(Pos));
    
    // 
    if(TreeEmpty(T)) {
        return;
    }
    
    InitQueue(&Q);
    
    // λ
    EnQueue(&Q, T.r);
    pt[T.r].row = 1;
    pt[T.r].col = 1;
    pt[T.r].childIndex = 1;
    
    // ڵĲ
    level = 0;
    
    while(!QueueEmpty(Q)) {
        DeQueue(&Q, &e);
        
        // ˸ı
        if(pt[e].row != level) {
            count = 0;
            level = pt[e].row;
        }
        
        n = 0;  // eĺӼ0
        
        // ÿʱһϢΪЧΪÿ㶼кӽ
        pt[e].lastChild = -1;
        
        // ָýĺ
        cp = T.nodes[e].firstchild;
        
        // ͷŸý㴦ĺռڴ
        while(cp != NULL) {
            // ǰλ
            EnQueue(&Q, cp->child);
            
            // ¼
            pt[cp->child].row = pt[e].row + 1;
            
            // ¼
            pt[cp->child].col = ++count;
            
            // ¼ǰǵڼ
            pt[cp->child].childIndex = ++n;
            
            // ΪһӵϢ
            pt[e].lastChild = cp->child;
            
            cp = cp->next;
        }
    }
}

// ڲʵ
static Status PreTraverse(CTree T, int i, Status(Visit)(TElemType)) {
    int firstChild = -1;    // ʼΪЧ
    int rightBrother;
    
    // ʵǰ
    if(!Visit(T.nodes[i].data)) {
        return ERROR;
    }
    
    // ˫ױ洢ṹӸ
    if(T.nodes[i].firstchild!=NULL) {
        firstChild = T.nodes[i].firstchild->child;
    }
    
    // ӣҪȷӵݣ
    if(firstChild != -1 && !PreTraverse(T, firstChild, Visit)) {
        return ERROR;
    }
    
    rightBrother = (i + 1) % MAX_TREE_SIZE;
    
    // ֵܣҪȷֵܵݣ
    if(T.nodes[i].parent == T.nodes[rightBrother].parent && !PreTraverse(T, rightBrother, Visit)) {
        return ERROR;
    }
    
    return OK;
}

// ڲʵ
static Status PostTraverse(CTree T, int i, Status(Visit)(TElemType)) {
    int firstChild = -1;    // ʼΪЧ
    int rightBrother;
    
    // ˫ױ洢ṹӸ
    if(T.nodes[i].firstchild!=NULL) {
        firstChild = T.nodes[i].firstchild->child;
    }
    
    // ӣҪȷӵݣ
    if(firstChild != -1 && !PostTraverse(T, firstChild, Visit)) {
        return ERROR;
    }
    
    // ʵǰ
    if(!Visit(T.nodes[i].data)) {
        return ERROR;
    }
    
    rightBrother = (i + 1) % MAX_TREE_SIZE;
    
    // ֵܣҪȷֵܵݣ
    if(T.nodes[i].parent == T.nodes[rightBrother].parent && !PostTraverse(T, rightBrother, Visit)) {
        return ERROR;
    }
    
    return OK;
}

// posϢڲʹ
static void printPos(CTree T, Pos pt[]) {
    int i;
    
    for(i = T.r; i != (T.r + T.n) % MAX_TREE_SIZE; i = (i + 1) % MAX_TREE_SIZE) {
        printf("%2c ", T.nodes[i].data);
    }
    printf("\n");
    
    for(i = T.r; i != (T.r + T.n) % MAX_TREE_SIZE; i = (i + 1) % MAX_TREE_SIZE) {
        printf("%2d ", pt[i].row);
    }
    printf("\n");
    
    for(i = T.r; i != (T.r + T.n) % MAX_TREE_SIZE; i = (i + 1) % MAX_TREE_SIZE) {
        printf("%2d ", pt[i].col);
    }
    printf("\n");
    
    for(i = T.r; i != (T.r + T.n) % MAX_TREE_SIZE; i = (i + 1) % MAX_TREE_SIZE) {
        printf("%2d ", pt[i].childIndex);
    }
    printf("\n");
    
}


/* ͼλ */

// ͼλʽǰṹ
void PrintTree(CTree T) {
    Pos pt[MAX_TREE_SIZE];
    
    // 
    if(TreeEmpty(T)) {
        printf("\n");
        return;
    }
    
    // TнλϢ
    getPos(T, pt);
    
    Print(T, pt, T.r);
    
    printf("\n");
    
    printf("洢ṹ\n");
    PrintFramework(T);
}

// ͼλǰṹڲʵ
static void Print(CTree T, Pos pt[], int i) {
    int firstChild = -1;    // ʼΪЧ
    int rightBrother;
    int k;
    
    // ʵǰ
    printf("%c ", T.nodes[i].data);
    
    // ˫ױ洢ṹӸ
    if(T.nodes[i].firstchild!=NULL) {
        firstChild = T.nodes[i].firstchild->child;
    }
    
    // ӣҪȷӵݣ
    if(firstChild != -1) {
        Print(T, pt, firstChild);
    }
    
    rightBrother = (i + 1) % MAX_TREE_SIZE;
    
    // ֵܣҪȷֵܵݣ
    if(rightBrother != (T.r + T.n) % MAX_TREE_SIZE && T.nodes[i].parent == T.nodes[rightBrother].parent) {
        // ʵǰֵǰǰ㲻һӣһλ
        if(pt[T.nodes[i].parent].lastChild != i) {
            printf("\n");
            
            for(k = 0; k < pt[rightBrother].row - 1; k++) {
                printf(". ");
            }
        }
        
        Print(T, pt, rightBrother);
    }
}

// ͼλнṹڲʹ
static void PrintFramework(CTree T) {
    int k;
    ChildPtr cp;
    
    if(T.n == 0) {
        return;
    }
    
    printf("+---------+-----------\n");
    printf("|  i e  p | child list\n");
    printf("+---------+-----------\n");
    
    for(k = T.r; k != (T.r + T.n) % MAX_TREE_SIZE; k = (k + 1) % MAX_TREE_SIZE) {
        
        printf("| %2d %c %2d", k, T.nodes[k].data, T.nodes[k].parent);
        
        cp = T.nodes[k].firstchild;
        if(cp != NULL) {
            printf(" ->");
        } else {
            printf(" | ");
        }
        
        while(cp != NULL) {
            printf(" %2d", cp->child);
            cp = cp->next;
        }
        
        printf("\n");
    }
    
    printf("+---------+-----------\n");
}
