/*==================
 * ˫ױ洢ʾ
 ===================*/

#ifndef PTREE_H
#define PTREE_H

#include <stdio.h>
#include <stdlib.h>     // ṩ mallocfree ԭ
#include <string.h>     // ṩ memsetstrcmp ԭ
#include "Status.h"     //**01 **//
#include "LinkList.h"   //**02 Ա**//
#include "LinkQueue.h"  //**03 ջͶ**//

/*  */
#define MAX_TREE_SIZE 1024

/* ĺ */
#define MAX_CHILD_COUNT 8

/* ԪͶ壬ԪΪchar */
typedef char TElemType;

/* (˫)Ľ㶨 */
typedef struct PTNode {
    TElemType data;
    int parent;         // ˫λ
} PTNode;

/*
 * (˫)Ͷ
 *
 *ע
 * 1.нnodes""洢ûп϶
 * 2.rܳnodesλ
 * 3.⣬ΰ˳ŸУһ̲ͼʾܻ
 * 4.nodesѭʹõģһ̲δᵽ
 * 5.nodesռ㹻ģΪ̬洢
 */
typedef struct {
    PTNode nodes[MAX_TREE_SIZE];    // 洢н
    int r;  // λ()
    int n;  // Ľ
} PTree;


/* ĳϢ */
typedef struct{
    int row;            // ǰ
    int col;            // ǰ
    int childIndex;     // ǰǵڼ
    int firstChild;     // ǰĵһе
    int lastChild;      // ǰһе
} Pos;


/*
 * ʼ
 *
 * 
 */
Status InitTree(PTree* T);

/*
 * 
 *
 * ͷռڴ档
 *
 *ע
 * ˫ױṹ޷
 */
Status DestroyTree(PTree* T);

/*
 * ÿ
 *
 * еݣʹΪ
 */
Status ClearTree(PTree* T);

/*
 * 
 *
 * ԤĶ
 * ԼʹáС
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateTree(PTree* T, char* path);

/*
 * п
 *
 * жǷΪ
 */
Status TreeEmpty(PTree T);

/*
 * 
 *
 * ȣ
 */
int TreeDepth(PTree T);

/*
 * ȡֵ
 *
 * ֵָ
 */
TElemType Value(PTree T, TElemType e);

/*
 * ֵ
 *
 * ΪָĽ㸳ֵ
 */
Status Assign(PTree* T, TElemType e, TElemType value);

/*
 * 
 *
 * ĸ㡣
 */
TElemType Root(PTree T);

/*
 * ˫
 *
 * нe˫׽㡣
 */
TElemType Parent(PTree T, TElemType e);

/*
 * 
 *
 * Tнeĺ
 */
int ChildCount(PTree T, TElemType e);

/*
 * 
 *
 * нeĵiӡ
 */
TElemType Child(PTree T, TElemType e, int i);

/*
 * ֵ
 *
 * нeֵܽ㡣
 *
 *ע
 * Ľܻӣ
 * ֵָ߽ڸýֵܡ
 */
TElemType LeftSibling(PTree T, TElemType e);

/*
 * ֵ
 *
 * нeֵܽ㡣
 *
 *ע
 * Ľܻӣ
 * ֵָұ߽ڸýֵܡ
 */
TElemType RightSibling(PTree T, TElemType e);

/*
 * 
 *
 * cΪTpĵiӡ
 */
Status InsertChild(PTree* T, TElemType p, int i, PTree c);

/*
 * ɾ
 *
 * ɾTpĵiӡ
 */
Status DeleteChild(PTree* T, TElemType p, int i);

/*
 * 
 */
Status PreOrderTraverse(PTree T, Status(Visit)(TElemType));

/*
 * 
 */
Status PostOrderTraverse(PTree T, Status(Visit)(TElemType));

/*
 * 
 */
Status LevelOrderTraverse(PTree T, Status(Visit)(TElemType));


/* ڲʹõĺ */

// ڲ
static void Create(PTree* T, FILE* fp);

// eڣ-1
static int EIndex(PTree T, TElemType e);

// eĵiڣ-1
static int CIndex(PTree T, TElemType e, int i);

// ȡTĽϢЩϢPos͵Ķ
static void getPos(PTree T, Pos pt[]);

// ڲʵ
static Status PreTraverse(PTree T, Pos pt[], int i, Status(Visit)(TElemType));

// ڲʵ
static Status PostTraverse(PTree T, Pos pt[], int i, Status(Visit)(TElemType));

// posϢڲʹ
static void printPos(PTree T, Pos pt[]);


/* ͼλ */

// ͼλʽǰṹ
void PrintTree(PTree T);

// ͼλǰṹڲʵ
static void Print(PTree T, Pos pt[], int i);

// ͼλнṹڲʹ
static void PrintFramework(PTree T);

#endif
