/*=======================
 * 洢ṹ
 ========================*/

#ifndef BITRITREE_H
#define BITRITREE_H

#include <stdio.h>
#include <stdlib.h>     // ṩ mallocfree ԭ
#include <string.h>     // ṩ memsetstrcmp ԭ
#include <math.h>       // ṩ pow ԭ
#include "Status.h"     //**01 **//

/* ԪͶ壬ԪΪchar */
typedef char TElemType;

/* 㶨壬˫׽Ķ */
typedef struct BiTriTNode {
    TElemType data;             // Ԫ
    struct BiTriTNode* lchild;  // ָ
    struct BiTriTNode* rchild;  // Һָ
    struct BiTriTNode* parent;  // ˫׽ָ
} BiTriTNode;

/* ָָ */
typedef BiTriTNode* BiTriTree;


/*
 * ʼ
 *
 * ն
 */
Status InitBiTree(BiTriTree* T);

/*
 * 
 *
 * ͷŶռڴ档
 *
 *ע
 * 洢ṹ٣ûҪ١
 * Ϊٺ״̬ÿպ״̬һµġ
 */
Status DestroyBiTree(BiTriTree* T);

/*
 * ÿ
 *
 * еݣʹΪ
 */
Status ClearBiTree(BiTriTree* T);

/*
 *  㷨6.4 
 *
 * 
 *
 * ԤĶ
 * ԼʹáС
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateBiTree(BiTriTree* T, char* path);

/*
 * п
 *
 * ж϶ǷΪ
 */
Status BiTreeEmpty(BiTriTree T);

/*
 * 
 *
 * ضȣ
 */
int BiTreeDepth(BiTriTree T);

/*
 * ȡֵ
 *
 * ضֵָ
 */
TElemType Value(BiTriTree T, TElemType e);

/*
 * ֵ
 *
 * ΪָĽ㸳ֵ
 */
Status Assign(BiTriTree T, TElemType e, TElemType value);

/*
 * 
 *
 * ضĸ㡣
 */
TElemType Root(BiTriTree T);

/*
 * ˫
 *
 * ضнe˫׽㡣
 */
TElemType Parent(BiTriTree T, TElemType e);

/*
 * 
 *
 * ضнeӽ㡣
 */
TElemType LeftChild(BiTriTree T, TElemType e);

/*
 * Һ
 *
 * ضнeҺӽ㡣
 */
TElemType RightChild(BiTriTree T, TElemType e);

/*
 * ֵ
 *
 * ضнeֵܽ㡣
 */
TElemType LeftSibling(BiTriTree T, TElemType e);

/*
 * ֵ
 *
 * ضнeֵܽ㡣
 */
TElemType RightSibling(BiTriTree T, TElemType e);

/*
 * 
 *
 * ֪cΪTཻķǿնcΪգ
 * LRȡֵ(01)cΪTнp/
 * ңpԭе/޽Ϊc
 */
Status InsertChild(BiTriTree T, TElemType p, int LR, BiTriTree c);

/*
 * ɾ
 *
 * LRȡֵ(01)ɾp/
 */
Status DeleteChild(BiTriTree T, TElemType p, int LR);

/*
 *  㷨6.1 
 *
 * 
 */
Status PreOrderTraverse(BiTriTree T, Status(Visit)(TElemType));

/*
 * 
 */
Status InOrderTraverse(BiTriTree T, Status(Visit)(TElemType));

/*
 * 
 */
Status PostOrderTraverse(BiTriTree T, Status(Visit)(TElemType));

/*
 * 
 */
Status LevelOrderTraverse(BiTriTree T, Status(Visit)(TElemType));


/* ڲʹõĺ */

// ڲ
static void CreateTree(BiTriTree* T, FILE* fp);

// ָeָ
static BiTriTree EPtr(BiTriTree T, TElemType e);

// ڲʵ
static Status PreTraverse(BiTriTree T, Status(Visit)(TElemType));

// ڲʵ
static Status InTraverse(BiTriTree T, Status(Visit)(TElemType));

// ڲʵ
static Status PostTraverse(BiTriTree T, Status(Visit)(TElemType));


/* ͼλ */

// ͼλʽǰṹڲʹ
void PrintTree(BiTriTree T);

#endif
