/*==================
 * ˳洢ṹ
 ===================*/

#include "SqBiTree.h"   //**06 Ͷ**//

/*
 * ʼ
 *
 * ն
 */
Status InitBiTree(SqBiTree T) {
    // ʹÿַ˳ṹ
    memset(T, '\0', sizeof(SqBiTree));
    
    return OK;
}

/*
 * 
 *
 * ͷŶռڴ档
 *
 *ע
 * ˳洢ṹ޷١
 */
Status DestroyBiTree(SqBiTree T) {
    // ˳洢ṹ޷
    return ERROR;
}

/*
 * ÿ
 *
 * еݣʹΪ
 */
Status ClearBiTree(SqBiTree T) {
    // ʹÿַ˳ṹ
    memset(T, '\0', sizeof(SqBiTree));
    
    return OK;
}

/*
 * 
 *
 * ԤĶ
 * ԼʹáС
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateBiTree(SqBiTree T, char* path) {
    FILE* fp;
    int readFromConsole;    // Ƿӿ̨ȡ
    
    // ûļ·Ϣӿ̨ȡ
    readFromConsole = path == NULL || strcmp(path, "") == 0;
    
    if(readFromConsole) {
        printf("Уûӽ㣬ʹ^棺");
        CreateTree(T, 0, NULL);
    } else {
        // ļ׼ȡ
        fp = fopen(path, "r");
        if(fp == NULL) {
            return ERROR;
        }
        CreateTree(T, 0, fp);
        fclose(fp);
    }
    
    return OK;
}

/*
 * п
 *
 * ж϶ǷΪ
 */
Status BiTreeEmpty(SqBiTree T) {
    return T[0] == '\0' ? TRUE : FALSE;
}

/*
 * 
 *
 * ضȣ
 */
int BiTreeDepth(SqBiTree T) {
    return TreeDepth(T, 0);
}

/*
 * ȡֵ
 *
 * ضֵָ
 */
TElemType Value(SqBiTree T, TElemType e) {
    int index;
    
    // 
    if(BiTreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe
    index = EIndex(T, e, 0);
    
    // ûҵԪe
    if(index == -1) {
        return '\0';
    } else {
        return T[index];
    }
}

/*
 * ֵ
 *
 * ΪָĽ㸳ֵ
 */
Status Assign(SqBiTree T, TElemType e, TElemType value) {
    int index;
    
    // 
    if(BiTreeEmpty(T)) {
        return ERROR;
    }
    
    // ȡe
    index = EIndex(T, e, 0);
    
    // ûҵԪe
    if(index == -1) {
        return ERROR;
    } else {
        // иֵ
        T[index] = value;
        return OK;
    }
}

/*
 * 
 *
 * ضĸ㡣
 */
TElemType Root(SqBiTree T) {
    // 
    if(BiTreeEmpty(T)) {
        return '\0';
    }
    
    return T[0];
}

/*
 * ˫
 *
 * ضнe˫׽㡣
 */
TElemType Parent(SqBiTree T, TElemType e) {
    int index;
    
    // 
    if(BiTreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe
    index = EIndex(T, e, 0);
    
    // ûҵԪe
    if(index == -1) {
        return '\0';
        
        // eǸ
    } else if(index == 0) {
        return '\0';
    } else {
        // ظ
        return T[(index - 1) / 2];
    }
}

/*
 * 
 *
 * ضнeӽ㡣
 */
TElemType LeftChild(SqBiTree T, TElemType e) {
    int index;
    
    // 
    if(BiTreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe
    index = EIndex(T, e, 0);
    
    // ûҵԪe
    if(index == -1) {
        return '\0';
    } else {
        // 
        return T[2 * index + 1];
    }
}

/*
 * Һ
 *
 * ضнeҺӽ㡣
 */
TElemType RightChild(SqBiTree T, TElemType e) {
    int index;
    
    // 
    if(BiTreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe
    index = EIndex(T, e, 0);
    
    // ûҵԪe
    if(index == -1) {
        return '\0';
    } else {
        // Һ
        return T[2 * index + 2];
    }
}

/*
 * ֵ
 *
 * ضнeֵܽ㡣
 */
TElemType LeftSibling(SqBiTree T, TElemType e) {
    int index, p;
    
    // 
    if(BiTreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe
    index = EIndex(T, e, 0);
    
    // ûҵԪe
    if(index == -1) {
        return '\0';
        
        // eǸ
    } else if(index == 0) {
        return '\0';
    } else {
        // ȡ
        p = (index - 1) / 2;
        
        // eҺӣ򷵻ֵ
        if(T[2 * p + 2] == e) {
            return T[2 * p + 1];
        } else {
            return '\0';
        }
    }
}

/*
 * ֵ
 *
 * ضнeֵܽ㡣
 */
TElemType RightSibling(SqBiTree T, TElemType e) {
    int index, p;
    
    // 
    if(BiTreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe
    index = EIndex(T, e, 0);
    
    // ûҵԪe
    if(index == -1) {
        return '\0';
        
        // eǸ
    } else if(index == 0) {
        return '\0';
    } else {
        // ȡ
        p = (index - 1) / 2;
        
        // eӣ򷵻ֵ
        if(T[2 * p + 1] == e) {
            return T[2 * p + 2];
        } else {
            return '\0';
        }
    }
}

/*
 * 
 *
 * ֪cΪTཻķǿնcΪգ
 * LRȡֵ(01)cΪTнp/
 * ңpԭе/޽Ϊc
 */
Status InsertChild(SqBiTree T, TElemType p, int LR, SqBiTree c) {
    int index;
    
    // Ϊ
    if(BiTreeEmpty(c)) {
        return ERROR;
    }
    
    // ȡp
    index = EIndex(T, p, 0);
    
    // p㲻ڣ򷵻شʾ
    if(index == -1) {
        return ERROR;
    }
    
    // cΪp
    if(LR==0) {
        // p
        if(T[2*index+1]!='\0') {
            // pΪc
            Transfer(T, 2*index+1, c, 2);
        }
    
        Transfer(c, 0, T, 2*index+1);
        
        // cΪp
    } else {
        // p
        if(T[2*index+2]!='\0') {
            // pΪc
            Transfer(T, 2*index+2, c, 2);
        }
    
        Transfer(c, 0, T, 2*index+2);
    }
    
    return OK;
}

/*
 * ɾ
 *
 * LRȡֵ(01)ɾp/
 */
Status DeleteChild(SqBiTree T, TElemType p, int LR) {
    int index;
    
    // ɾΪ
    if(BiTreeEmpty(T)) {
        return ERROR;
    }
    
    // ȡp
    index = EIndex(T, p, 0);
    
    // ɾ㲻ڣ򷵻شʾ
    if(index == -1) {
        return ERROR;
    }
    
    // Ҫɾp
    if(LR == 0) {
        Delete(T, 2 * index + 1);
        
        // Ҫɾp
    } else {
        Delete(T, 2 * index + 2);
    }
    
    return OK;
}

/*
 * 
 */
Status PreOrderTraverse(SqBiTree T, Status(Visit)(TElemType)) {
    Status status;
    
    status = PreTraverse(T, Visit, 0);
    printf("\n");
    
    return status;
}

/*
 * 
 */
Status InOrderTraverse(SqBiTree T, Status(Visit)(TElemType)) {
    Status status;
    
    status = InTraverse(T, Visit, 0);
    printf("\n");
    
    return status;
}

/*
 * 
 */
Status PostOrderTraverse(SqBiTree T, Status(Visit)(TElemType)) {
    Status status;
    
    status = PostTraverse(T, Visit, 0);
    printf("\n");
    
    return status;
}

/*
 * 
 */
Status LevelOrderTraverse(SqBiTree T, Status(Visit)(TElemType)) {
    int i;
    int deep;
    int len;
    
    // 
    deep = BiTreeDepth(T);
    if(deep == 0) {
        return OK;
    }
    
    // Ԫֵ
    len = (int) pow(2, deep) - 1;
    
    for(i = 0; i < len; i++) {
        if(T[i] != '\0') {
            if(!Visit(T[i])) {
                // ʴ󣬻ἴʱ
                return ERROR;
            }
        }
    }
    
    printf("\n");
    
    return OK;
}


/* ڲʹõĺ */

// ڲ
static void CreateTree(SqBiTree T, int i, FILE* fp) {
    char ch;
    
    // ȡǰֵ
    if(fp == NULL) {
        scanf("%c", &ch);
    } else {
        ReadData(fp, "%c", &ch);
    }
    
    if(ch == '^') {
        T[i] = '\0';
    } else {
        T[i] = ch;
        CreateTree(T, 2 * i + 1, fp); // 
        CreateTree(T, 2 * i + 2, fp); // 
    }
}

// ȵڲ
static int TreeDepth(SqBiTree T, int i) {
    int ld, rd;     // ¼
    
    if(T[i] == '\0') {
        return 0;
    } else {
        ld = TreeDepth(T, 2 * i + 1);
        rd = TreeDepth(T, 2 * i + 2);
        
        return (ld >= rd ? ld : rd) + 1;
    }
}

// ضeţiǽp
static int EIndex(SqBiTree T, TElemType e, int i) {
    int cl, cr;
    
    // ѾԽ
    if(i >= MAX_TREE_SIZE) {
        return -1;
    }
    
    // eֵϹ
    if(e == '\0') {
        return -1;
    }
    
    // ҵԪe
    if(T[i] == e) {
        return i;
    }
    
    // в
    cl = EIndex(T, e, 2 * i + 1);
    if(cl != -1) {
        return cl;
    }
    
    // в
    cr = EIndex(T, e, 2 * i + 2);
    if(cr != -1) {
        return cr;
    }
    
    return -1;
}

// ժ¶TеiΪRj
static void Transfer(SqBiTree T, int i, SqBiTree R, int j) {
    R[j] = T[i];
    
    if(T[i] != '\0') {
        Transfer(T, 2 * i + 1, R, 2 * j + 1);
        Transfer(T, 2 * i + 2, R, 2 * j + 2);
        T[i] = '\0';
    }
}

// ɾTеi
static void Delete(SqBiTree T, int i) {
    if(T[i] != '\0') {
        T[i] = '\0';
        Delete(T, 2 * i + 1);
        Delete(T, 2 * i + 2);
    }
}

// ڲʵ
static Status PreTraverse(SqBiTree T, Status(Visit)(TElemType), int i) {
    // Խ
    if(i >= MAX_TREE_SIZE) {
        return ERROR;
    }
    
    if(T[i]) {
        if(Visit(T[i])) {
            if(PreTraverse(T, Visit, 2 * i + 1)) {
                if(PreTraverse(T, Visit, 2 * i + 2)) {
                    return OK;
                }
            }
        }
    
        return ERROR;
    
        // 
    } else {
        return OK;
    }
}

// ڲʵ
static Status InTraverse(SqBiTree T, Status(Visit)(TElemType), int i) {
    // Խ
    if(i >= MAX_TREE_SIZE) {
        return ERROR;
    }
    
    if(T[i]) {
        if(InTraverse(T, Visit, 2 * i + 1)) {
            if(Visit(T[i])) {
                if(InTraverse(T, Visit, 2 * i + 2)) {
                    return OK;
                }
            }
            
        }
        
        return ERROR;
        
        // 
    } else {
        return OK;
    }
}

// ڲʵ
static Status PostTraverse(SqBiTree T, Status(Visit)(TElemType), int i) {
    // Խ
    if(i >= MAX_TREE_SIZE) {
        return ERROR;
    }
    
    if(T[i]) {
        if(PostTraverse(T, Visit, 2 * i + 1)) {
            if(PostTraverse(T, Visit, 2 * i + 2)) {
                if(Visit(T[i])) {
                    return OK;
                }
                
            }
        }
        
        return ERROR;
        
        // 
    } else {
        return OK;
    }
}


/* ͼλ */

void PrintTree(SqBiTree T) {
    int level, width;
    int i, j, k, w;
    int begin;
    int distance;
    TElemType** tmp;
    
    // 
    if(BiTreeEmpty(T)) {
        printf("\n");
        return;
    }
    
    level = BiTreeDepth(T);         // ȫṹ߶
    width = (int)pow(2, level)-1;   // ȫṹ
    
    // ̬
    tmp = (TElemType**)malloc(level* sizeof(TElemType*));
    
    // ̬
    for(i = 0; i < level; i++) {
        tmp[i] = (TElemType*)malloc(width* sizeof(TElemType));
    
        // ʼڴֵΪַ
        memset(tmp[i], '\0', width);
    }
    
    // Ԫأ䰲ŵάtmpкʵλ
    for(i = 0; i < level; i++) {
        w        = (int) pow(2, i);             // ǰĿ
        distance = width / w;                   // ǰԪؼ
        begin    = width / (int) pow(2, i + 1); // ǰ׸Ԫ֮ǰĿո
        
        for(k = 0; k < w; k++) {
            j = begin + k * (1 + distance);
            tmp[i][j] = T[(int) pow(2, i) + k - 1];
        }
    }

    for(i = 0; i < level; i++) {
        for(j = 0; j < width; j++) {
            if(tmp[i][j] != '\0') {
                printf("%c", tmp[i][j]);
            } else {
                printf(" ");
            }
        }
        printf("\n");
    }
}
