/*=============================
 * Ŀ洢ʾ
 ==============================*/

#include "LString.h"    //**04 **//

/*
 * ʼ
 *
 * һֵΪcharsĴT
 *
 *ע
 * òСӼ
 */
Status StrAssign(LString* T, const char* chars) {
    int len;        // charsĳ
    int i, count;   // ַcharsα
    int m;          // ܿ
    int n;          // δĿ飬洢ÿеЧԪ
    Chunk* r;
    
    // charsĳ
    len = (int) strlen(chars);
    
    // ûЧԪ
    if(len == 0) {
        (*T).head = NULL;
        (*T).tail = NULL;
        (*T).curlen = 0;
        
        return OK;
    }
    
    m = len / CHUNKSIZE;    // ȼҪĿ
    n = len % CHUNKSIZE;    // δĿ飬ÿЧԪ
    if(n != 0) {
        m++;                // ܿ
    }
    
    // 1.Ľṹ
    for(i = 1; i <= m; i++) {
        // ¿
        r = (Chunk*) malloc(sizeof(Chunk));
        if(r == NULL) {
            exit(OVERFLOW);
        }
        r->next = NULL;
        
        // һ
        if(i == 1) {
            (*T).head = (*T).tail = r;
            
            // ӺĿ
        } else {
            (*T).tail->next = r;
            (*T).tail = r;
        }
    }
    
    r = (*T).head;
    i = 0;      // Tα
    count = 0;  // ͳƱԪأ˳Ϊcharsα
    
    // 2.Ϊ
    while(count < len) {
        r->ch[i] = chars[count];
        
        i = (i + 1) % CHUNKSIZE;
        if(i == 0) {
            r = r->next;    // ָһ
        }
        
        count++;
    }
    
    // 3.δĿ
    if(n != 0) {
        // Ǵֵ('\0')
        while(i < CHUNKSIZE) {
            (*T).tail->ch[i] = '\0';
            i++;
        }
    }
    
    // 4.¼Ϣ
    (*T).curlen = len;
    
    return OK;
}

/*
 * 
 *
 *ע
 * Ľṹ٣ٲ
 */
Status DestroyString(LString* S) {
    return OK;
}

/*
 * 
 *
 * Sա
 */
Status ClearString(LString* S) {
    Chunk* p, * q;
    
    p = (*S).head;
    
    // ͷдռõĿռ
    while(p != NULL) {
        q = p->next;
        free(p);
        p = q;
    }
    
    (*S).head = NULL;
    (*S).tail = NULL;
    (*S).curlen = 0;
    
    return OK;
}

/*
 * п
 *
 * жϴSǷЧݡ
 *
 * ֵ
 * TRUE : SΪ
 * FALSE: SΪ
 */
Status StrEmpty(LString S) {
    return S.curlen == 0 ? TRUE : FALSE;
}

/*
 * 
 *
 * شSԪصĸ
 *
 *ע
 * òСӼ
 */
int StrLength(LString S) {
    return S.curlen;
}

/*
 * Ӵ
 *
 * SubS[pos, pos+len-1]
 * ֵָʾǷȡɹ
 *
 *ע
 * òСӼ
 */
Status SubString(LString* Sub, LString S, int pos, int len) {
    int m;      // Subܿ
    int n;      // SubδĿ飬洢ÿеЧԪ
    int i, j, count;
    Chunk* r, * p;
    
    if(pos < 1 || pos > S.curlen || len < 0 || pos + len - 1 > S.curlen) {
        return ERROR;
    }
    
    // ǽȡ0ַҪռ
    if(len == 0) {
        (*Sub).head = NULL;
        (*Sub).tail = NULL;
        (*Sub).curlen = 0;
        
        return OK;
    }
    
    m = len / CHUNKSIZE;    // ȼҪĿ
    n = len % CHUNKSIZE;    // SubδĿ飬ÿЧԪ
    if(n != 0) {
        m++;                // Subܿ
    }
    
    // 1.SubĽṹ
    for(i = 1; i <= m; i++) {
        // ¿
        r = (Chunk*) malloc(sizeof(Chunk));
        if(r == NULL) {
            exit(OVERFLOW);
        }
        r->next = NULL;
        
        // һ
        if(i == 1) {
            (*Sub).head = (*Sub).tail = r;
            
            // ӺĿ
        } else {
            (*Sub).tail->next = r;
            (*Sub).tail = r;
        }
    }
    
    // SеposԪڵĿ飬ָpָ
    for(count = 1, p = S.head; pos > count * CHUNKSIZE; count++, p = p->next) {
        // ѭ
    }
    
    r = (*Sub).head;            // ָSubĿ
    
    i = 0;                      // Subα
    j = (pos - 1) % CHUNKSIZE;  // S  α
    count = 0;                  // ͳƱԪ
    
    // 2.ΪSub
    while(count < len) {
        r->ch[i] = p->ch[j];
        
        i = (i + 1) % CHUNKSIZE;
        if(i == 0) {
            r = r->next;    // ָSubһ
        }
        
        j = (j + 1) % CHUNKSIZE;
        if(j == 0) {
            p = p->next;    // ָSһ
        }
        
        count++;
    }
    
    // 3.δĿ
    if(n != 0) {
        // Ǵֵ('\0')
        while(i < CHUNKSIZE) {
            (*Sub).tail->ch[i] = '\0';
            i++;
        }
    }
    
    // 4.¼Ϣ
    (*Sub).curlen = len;
    
    return OK;
}

/*
 * 
 *
 * posʼģʽTS״γֵλãڣ򷵻0
 * ҳɹƥλá
 *
 *ע
 * 1.ʵҪСӼ
 * 2.ʵֱȽϵЧ
 */
int Index(LString S, LString T, int pos) {
    int i, s, t;
    LString sub;
    
    if(pos < 1 || pos > S.curlen || StrEmpty(T)) {
        return 0;
    }
    
    s = S.curlen;                //S
    t = T.curlen;                //ģʽT
    i = pos;
    
    while(i + t - 1 <= s) {
        // ȡS[i, i+m-1]
        SubString(&sub, S, i, t);
        
        // Ӵģʽƥ䣬Ҫƽ
        if(StrCompare(sub, T) != 0) {
            ++i;
        } else {
            return i;
        }
    }
    
    return 0;                        //Ҳƥ򷵻0
}

/*
 * 
 *
 * T뵽Sposλô
 */
Status StrInsert(LString* S, int pos, LString T) {
    Chunk* pre, * p;    // preָĿǰpָĿ
    Chunk* h, * t;      // ָĿͷβ
    Chunk* r;
    Chunk* s;
    int i, j, count;

    if(pos < 1 || pos > (*S).curlen + 1) {
        return ERROR;
    }

    // ĴΪգǰ
    if(StrEmpty(T)) {
        return OK;
    }

    // ¼ʼֹ
    h = t = NULL;

    // TеĿ飨ֻƽṹ
    for(r = T.head; r != NULL; r = r->next) {
        s = (Chunk*) malloc(sizeof(Chunk));
        if(s == NULL) {
            exit(OVERFLOW);
        }
        s->next = NULL;

        if(r == T.head) {
            h = t = s;
        } else {
            t->next = s;
            t = s;
        }
    }

    // SеposԪڵĿ飨עΪĿ飩ָpreָǰ
    if(pos >= 1 && pos <= CHUNKSIZE) {
        pre = NULL;     // ˵posԪڿΪhead
        p = (*S).head;
    } else {
        for(count = 1, pre = (*S).head; count < (pos - 1) / CHUNKSIZE; count++, pre = pre->next) {
            // ѭ
        }
        p = pre->next;
    }

    /*
     * htΧĿ뵽posڵĿ֮ǰ
     */

    if(pre == NULL) {
        t->next = (*S).head;
        (*S).head = h;
    } else {
        pre->next = h;
        t->next = p;
    }

    if(pre == (*S).tail) {
        (*S).tail = t;
    }

    /*
     * ƶ/Ԫ
     */

    j = 0;

    // 뵽ĳġм䡱
    if((pos - 1) % CHUNKSIZE != 0) {
        // ƶĿposλ֮ǰԪ
        for(i = 1; i <= (pos - 1) % CHUNKSIZE; i++) {
            h->ch[j++] = p->ch[i - 1];
            p->ch[i - 1] = '\0';
        }
    }

    r = T.head;
    i = 0;

    // TеԪصS
    for(count = 1; count <= T.curlen; count++) {
        h->ch[j] = r->ch[i];

        j = (j + 1) % CHUNKSIZE;
        i = (i + 1) % CHUNKSIZE;

        if(j == 0) {
            h = h->next;
        }

        if(i == 0) {
            r = r->next;
        }
    }

    // Tһа'\0'
    if(T.curlen % CHUNKSIZE != 0) {
        r = p;  // ָĿ
        i = (pos - 1) % CHUNKSIZE;

        // ƶĿposλü֮Ԫ
        for(count = pos; count <= (*S).curlen; count++) {
            h->ch[j] = r->ch[i];
            r->ch[i] = '\0';

            j = (j + 1) % CHUNKSIZE;
            i = (i + 1) % CHUNKSIZE;

            if(j == 0) {
                h = h->next;
            }

            if(i == 0) {
                r = r->next;
            }
        }
    }

    (*S).curlen += T.curlen;

    return OK;
}

/*
 * ɾ
 *
 * ɾS[pos, pos+len-1]
 */
Status StrDelete(LString* S, int pos, int len) {
    Chunk* pre;     // ָԪS[pos]ڵĿǰ
    Chunk* p;       // ָԪS[pos]ڵĿ
    Chunk* q;       // ָԪS[pos+len]ڵĿ
    Chunk* r;
    int i, j, count, total;
    
    if(pos < 1 || pos > (*S).curlen || len < 0 || pos + len - 1 > (*S).curlen) {
        return ERROR;
    }
    
    // ɾĳΪ0ǰ
    if(len == 0) {
        return OK;
    }
    
    // S[pos]ڵĿ飬ָpreָǰ
    if(pos >= 1 && pos <= CHUNKSIZE) {
        pre = NULL;     // ˵posԪڿΪhead
        p = (*S).head;
    } else {
        for(count = 1, pre = (*S).head; count < (pos - 1) / CHUNKSIZE; count++, pre = pre->next) {
            // ѭ
        }
        p = pre->next;
    }
    
    // S[pos+len]ڵĿ
    for(count = (pos - 1) / CHUNKSIZE, q = p; count < (pos + len - 1) / CHUNKSIZE; count++, q = q->next) {
        // ѭ
    }
    
    // ҪƶԪظ
    total = (*S).curlen - (pos + len) + 1;
    
    // յĳȶ
    (*S).curlen -= len;
    
    i = (pos - 1) % CHUNKSIZE;
    j = (pos + len - 1) % CHUNKSIZE;
    
    if(p != q) {
        // ɾpq֮Ŀ
        r = p->next;
        while(r != q) {
            p->next = r->next;
            free(r);
            r = p->next;
        }
        
        if(q == NULL) {
            (*S).tail = p;
        }
        
        // Ҫɾpָ
        if((pos - 1) % CHUNKSIZE == 0) {
            // pѾָͷ
            if(pre == NULL) {
                (*S).head = q;
            } else {
                pre->next = q;
            }
            
            free(p);
            p = q;
            
            if(q == NULL) {
                (*S).tail = pre;
            }
        }
    }
    
    // Ѿλ
    if(p == q && i == j) {
        return OK;
    }
    
    for(count = 1; count <= total; count++) {
        // ƶԪ
        p->ch[i] = q->ch[j];
        
        i = (i + 1) % CHUNKSIZE;
        j = (j + 1) % CHUNKSIZE;
        
        if(i == 0) {
            pre = p;
            p = p->next;
        }
        
        if(j == 0) {
            q = q->next;
        }
    }
    
    // ǡĿ
    if(i == 0) {
        (*S).tail = pre;
        r = p;
    } else {
        (*S).tail = p;
        
        // ʣಿǴֵַ
        while(i < CHUNKSIZE) {
            p->ch[i++] = '\0';
        }
        
        r = p->next;
    }
    
    // ͷŶĿռ
    while(r != NULL) {
        (*S).tail->next = r->next;
        free(r);
        r = (*S).tail->next;
    }
    
    return OK;
}

/*
 * Ƚ
 *
 * ȽϴSʹTرȽϽ
 *
 *ע
 * òСӼ
 */
int StrCompare(LString S, LString T) {
    int i;
    Chunk* s = S.head;
    Chunk* t = T.head;
    
    while(s != NULL && t != NULL) {
        for(i = 0; i < CHUNKSIZE; i++) {
            if(s->ch[i] != t->ch[i]) {
                return s->ch[i] - t->ch[i];
            }
        }
        
        s = s->next;
        t = t->next;
    }
    
    if(s != NULL) {
        return 1;
    } else if(t != NULL) {
        return -1;
    } else {
        return 0;
    }
}

/*
 * 
 *
 * SƵT
 */
Status StrCopy(LString* T, LString S) {
    int i;
    Chunk* s, * p;
    
    for(p = S.head; p; p = p->next) {
        s = (Chunk*) malloc(sizeof(Chunk));
        if(s == NULL) {
            exit(OVERFLOW);
        }
        s->next = NULL;
        
        if(p == S.head) {
            (*T).head = (*T).tail = s;
        } else {
            (*T).tail->next = s;
            (*T).tail = s;
        }
        
        for(i = 0; i < CHUNKSIZE; i++) {
            (*s).ch[i] = (*p).ch[i];
        }
    }
    
    (*T).curlen = S.curlen;
    
    return OK;
}

/*
 * 滻
 *
 * V滻SгֵTȵҲصӴ
 *
 *ע
 * 1.òСӼ
 * 2.ʵֱȽϵЧ
 */
Status Replace(LString* S, LString T, LString V) {
    int i;
    
    if(StrEmpty(*S) || StrEmpty(T)) {
        return ERROR;
    }
    
    // SѰģʽTһγֵλ
    i = Index(*S, T, 1);
    
    // ƥַ
    while(i != 0) {
        StrDelete(S, i, StrLength(T));  // SɾT
        StrInsert(S, i, V);             // SвV
        
        i += StrLength(V);      // iлһλ
        
        i = Index(*S, T, i);    // һƥַ
    }
    
    return OK;
}

/*
 * 
 *
 * S1S2洢TзءӺĳֻδĲ֡
 * ֵʾӺĴǷ
 *
 *ע
 * òСӼ
 */
Status Concat(LString* T, LString S1, LString S2) {
    Chunk* p;   // S1S2
    Chunk* r;   // T
    Chunk* s;
    int i, j, count;
    
    // 㳤Ϣ
    (*T).curlen = S1.curlen + S2.curlen;
    
    // Ҫٸ
    count = (*T).curlen / CHUNKSIZE + ((*T).curlen % CHUNKSIZE == 0 ? 0 : 1);
    
    // S1Ľṹ
    for(i = 1; i <= count; i++) {
        s = (Chunk*) malloc(sizeof(Chunk));
        if(s == NULL) {
            exit(OVERFLOW);
        }
        s->next = NULL;
        
        if(i == 1) {
            (*T).head = (*T).tail = s;
        } else {
            (*T).tail->next = s;
            (*T).tail = s;
        }
    }
    
    i = 0;
    r = (*T).head;
    
    // S1е
    j = 0;
    p = S1.head;
    for(count = 0; count < S1.curlen; count++) {
        r->ch[i] = p->ch[j];
        
        i = (i + 1) % CHUNKSIZE;
        j = (j + 1) % CHUNKSIZE;
        
        if(i == 0) {
            r = r->next;
        }
        
        if(j == 0) {
            p = p->next;
        }
    }
    
    // S2е
    j = 0;
    p = S2.head;
    for(count = 0; count < S2.curlen; count++) {
        r->ch[i] = p->ch[j];
        
        i = (i + 1) % CHUNKSIZE;
        j = (j + 1) % CHUNKSIZE;
        
        if(i == 0) {
            r = r->next;
        }
        
        if(j == 0) {
            p = p->next;
        }
    }
    
    // ĿռǴֵַ
    if(i != 0) {
        while(i < CHUNKSIZE) {
            r->ch[i] = '\0';
            i++;
        }
    }
    
    return OK;
}
