/*=========================
 * Ķѷ洢ʾѴ
 *
 * 㷨: 4.4
 ==========================*/

#include "HString.h"    //**04 **//

/*
 * ʼ
 *
 * һֵΪcharsĴT
 *
 *ע
 * òСӼ
 */
Status StrAssign(HString* T, const char* chars) {
    int i, j;
    
    // charsĳ
    i = (int) strlen(chars);
    
    // ûЧԪ
    if(i == 0) {
        (*T).ch = NULL;
        (*T).length = 0;
    
        return OK;
    }
    
    // ЧԪʱҪ洢ռ
    (*T).ch = (char*) malloc(i * sizeof(char));
    if(!((*T).ch)) {
        exit(OVERFLOW);
    }
    
    for(j = 0; j < i; j++) {
        (*T).ch[j] = chars[j];
    }
    
    (*T).length = i;
    
    return OK;
}

/*
 * 
 *
 * S١
 *
 *ע
 * ѴĽṹ٣ٲ
 */
Status DestroyString(HString* S) {
    return OK;
}

/*
 * 
 *
 * Sա
 */
Status ClearString(HString* S) {
    // ûЧԪʱٶѴṹ
    if((*S).ch != 0) {
        free((*S).ch);
        (*S).ch = NULL;
    }
    
    (*S).length = 0;
    
    return OK;
}

/*
 * п
 *
 * жϴSǷЧݡ
 *
 * ֵ
 * TRUE : SΪ
 * FALSE: SΪ
 */
Status StrEmpty(HString S) {
    return S.length == 0 ? TRUE : FALSE;
}

/*
 * 
 *
 * شSԪصĸ
 *
 *ע
 * òСӼ
 */
int StrLength(HString S) {
    return S.length;
}

/*
 * Ӵ
 *
 * SubS[pos, pos+len-1]
 * ֵָʾǷȡɹ
 *
 *ע
 * òСӼ
 */
Status SubString(HString* Sub, HString S, int pos, int len) {
    int i;
    
    if(pos < 1 || pos > S.length || len < 0 || pos + len - 1 > S.length) {
        return ERROR;
    }
    
    // ǽȡ0ַҪռ
    if(len == 0) {
        (*Sub).ch = NULL;
        (*Sub).length = 0;
    
        return OK;
    }
    
    (*Sub).ch = (char*) malloc(len * sizeof(char));
    if(!(*Sub).ch) {
        exit(OVERFLOW);
    }
    
    // Ԫ
    for(i = 0; i < len; i++) {
        (*Sub).ch[i] = S.ch[i + pos - 1];
    }
    
    // ȷ³
    (*Sub).length = len;
    
    return OK;
}

/*
 * 
 *
 * posʼģʽTS״γֵλãڣ򷵻0
 * ҳɹƥλá
 *
 *ע
 * 1.ʵҪСӼ
 * 2.ʵֱȽϵЧ
 */
int Index(HString S, HString T, int pos) {
    int i, s, t;
    HString sub;
    
    if(pos < 1 || pos > S.length || StrEmpty(T)) {
        return 0;
    }
    
    s = S.length;
    t = T.length;
    i = pos;
    
    // ֤ȲԽ
    while(i + t - 1 <= s) {
        // ȡS[i, i+t-1]
        SubString(&sub, S, i, t);
        
        // Ӵģʽƥ䣬Ҫƽ
        if(StrCompare(sub, T) != 0) {
            ++i;
        } else {
            return i;
        }
    }
    
    return 0;
}

/*
 *  㷨4.4 
 *
 * 
 *
 * T뵽Sposλô
 */
Status StrInsert(HString* S, int pos, HString T) {
    int i;
    
    if(pos < 1 || pos > (*S).length + 1) {
        return ERROR;
    }
    
    // ĴΪգǰ
    if(StrEmpty(T)) {
        return OK;
    }
    
    // ¿ռ䣬ὫԪһƹȥ
    (*S).ch = (char*) realloc((*S).ch, ((*S).length + T.length) * sizeof(char));
    if(!(*S).ch) {
        exit(OVERFLOW);
    }
    
    // SڳλãΪT׼
    for(i = (*S).length - 1; i >= pos - 1; i--) {
        // ӺǰǰԪŲ
        (*S).ch[i + T.length] = (*S).ch[i];
    }
    
    // TSڳλ
    for(i = pos - 1; i <= pos + T.length - 2; i++) {
        (*S).ch[i] = T.ch[i - pos + 1];
    }
    
    // 
    (*S).length += T.length;
    
    return OK;
}

/*
 * ɾ
 *
 * ɾS[pos, pos+len-1]
 */
Status StrDelete(HString* S, int pos, int len) {
    int i;
    
    if(pos < 1 || pos + len - 1 > (*S).length || len < 0) {
        return ERROR;
    }
    
    // ɾĳΪ0ǰ
    if(len == 0) {
        return OK;
    }
    
    // ѺԪŲǰ棬ǵɾԪ
    for(i = pos + len - 1; i <= (*S).length - 1; i++) {
        (*S).ch[i - len] = (*S).ch[i];
    }
    
    // ȼ
    (*S).length -= len;
    
    // Ŀռ䣨ȼΪ0᷵ؿָ룩
    (*S).ch = (char*) realloc((*S).ch, (*S).length * sizeof(char));
    
    return OK;
}

/*
 * Ƚ
 *
 * ȽϴSʹTرȽϽ
 *
 *ע
 * òСӼ
 */
Status StrCompare(HString S, HString T) {
    int i;
    
    for(i = 0; i < S.length && i < T.length; i++) {
        // ַͬʱȽС
        if(S.ch[i] != T.ch[i]) {
            return S.ch[i] - T.ch[i];
        }
    }
    
    return S.length - T.length;
}

/*
 * 
 *
 * SƵT
 */
Status StrCopy(HString* T, HString S) {
    int i;
    
    if(StrEmpty(S)) {
        (*T).ch = NULL;
        (*T).length = 0;
    } else {
        // ռ
        (*T).ch = (char*) malloc(S.length * sizeof(char));
        if(!(*T).ch) {
            exit(OVERFLOW);
        }
        
        // Ԫ
        for(i = 0; i < S.length; i++) {
            (*T).ch[i] = S.ch[i];
        }
        
        // ƳϢ
        (*T).length = S.length;
    }
    
    return OK;
}

/*
 * 滻
 *
 * V滻SгֵTȵҲصӴ
 *
 *ע
 * 1.òСӼ
 * 2.ʵֱȽϵЧ
 */
Status Replace(HString* S, HString T, HString V) {
    int i;
    
    if(StrEmpty(*S) || StrEmpty(T)) {
        return ERROR;
    }
    
    // SѰģʽTһγֵλ
    i = Index(*S, T, 1);
    
    // ƥַ
    while(i != 0) {
        StrDelete(S, i, StrLength(T));  // SɾT
        StrInsert(S, i, V);             // SвV
        
        i += StrLength(V);          // iлһλ
        
        i = Index(*S, T, i);        // һƥַ
    }
    
    return OK;
}

/*
 * 
 *
 * S1S2洢TзءӺĳֻδĲ֡
 * ֵʾӺĴǷ
 * ѴĿռ䱻Ϊ޵ģǷTRUEָʾᱻü
 *
 *ע
 * òСӼ
 */
Status Concat(HString* T, HString S1, HString S2) {
    int i;
    
    // ȷ³
    (*T).length = S1.length + S2.length;
    
    // ռ
    (*T).ch = (char*) malloc((*T).length * sizeof(char));
    if(!(*T).ch) {
        exit(OVERFLOW);
    }
    
    // ȰS1ݿ
    for(i = 0; i < S1.length; i++) {
        (*T).ch[i] = S1.ch[i];
    }
    
    // ٿS2
    for(i = 0; i < S2.length; i++) {
        (*T).ch[S1.length + i] = S2.ch[i];
    }
    
    return TRUE;
}
