/*=============================
 * е˳洢ṹ˳У
 ==============================*/

#include "SqQueue.h"                //**03 ջͶ**//

/*
 * ʼ
 *
 * һյ˳С
 * ʼɹ򷵻OK򷵻ERROR
 *
 *ע
 * Ķѭ
 */
Status InitQueue(SqQueue* Q) {
    if(Q == NULL) {
        return ERROR;
    }
    
    (*Q).base = (QElemType*) malloc(MAXQSIZE * sizeof(QElemType));
    if(!(*Q).base) {
        exit(OVERFLOW);
    }
    
    (*Q).front = (*Q).rear = 0;
    
    return OK;
}

/*
 * (ṹ)
 *
 * ͷѭ˳ռڴ档
 */
Status DestroyQueue(SqQueue* Q) {
    if(Q == NULL) {
        return ERROR;
    }
    
    if((*Q).base) {
        free((*Q).base);
    }
    
    (*Q).base = NULL;
    (*Q).front = (*Q).rear = 0;
    
    return ERROR;
}

/*
 * ÿ()
 *
 * ֻѭ˳д洢ݣͷ˳ռڴ档
 */
Status ClearQueue(SqQueue* Q) {
    if(Q == NULL || (*Q).base == NULL) {
        return ERROR;
    }
    
    (*Q).front = (*Q).rear = 0;
    
    return OK;
}

/*
 * п
 *
 * жѭ˳ǷЧݡ
 *
 * ֵ
 * TRUE : ѭ˳Ϊ
 * FALSE: ѭ˳вΪ
 */
Status QueueEmpty(SqQueue Q) {
    // пյı־
    if(Q.front == Q.rear) {
        return TRUE;
    } else {
        return FALSE;
    }
}

/*
 * 
 *
 * ѭ˳аЧԪص
 */
int QueueLength(SqQueue Q) {
    if(Q.base == NULL) {
        return 0;
    }
    
    // г
    return (Q.rear - Q.front + MAXQSIZE) % MAXQSIZE;
}

/*
 * ȡֵ
 *
 * ȡͷԪأ洢eС
 * ҵOK򣬷ERROR
 */
Status GetHead(SqQueue Q, QElemType* e) {
    // пյı־
    if(Q.base == NULL || Q.front == Q.rear) {
        return ERROR;
    }
    
    *e = Q.base[Q.front];
    
    return OK;
}

/*
 * 
 *
 * Ԫeӵβ
 */
Status EnQueue(SqQueue* Q, QElemType e) {
    if(Q == NULL || (*Q).base == NULL) {
        return ERROR;
    }
    
    // ı־˷һռֶпպͶ
    if(((*Q).rear + 1) % MAXQSIZE == (*Q).front) {
        return ERROR;
    }
    
    // 
    (*Q).base[(*Q).rear] = e;
    
    // βָǰ
    (*Q).rear = ((*Q).rear + 1) % MAXQSIZE;
    
    return OK;
}

/*
 * 
 *
 * ƳͷԪأ洢eС
 */
Status DeQueue(SqQueue* Q, QElemType* e) {
    if(Q == NULL || (*Q).base == NULL) {
        return ERROR;
    }
    
    // пյı־
    if((*Q).front == (*Q).rear) {
        return ERROR;
    }
    
    // 
    *e = (*Q).base[(*Q).front];
    
    // ͷָǰ
    (*Q).front = ((*Q).front + 1) % MAXQSIZE;
    
    return OK;
}

/*
 * 
 *
 * visitʶQ
 */
Status QueueTraverse(SqQueue Q, void(Visit)(QElemType)) {
    int i;
    
    if(Q.base == NULL) {
        return ERROR;
    }
    
    for(i = Q.front; i != Q.rear; i = (i + 1) % MAXQSIZE) {
        Visit(Q.base[i]);
    }
    
    printf("\n");
    
    return OK;
}
