/*=================================
 * ̬
 *
 * 㷨: 2.132.142.152.16
 ==================================*/

#include "SLinkList.h"

/*
 *  ʾ 
 *
 * кβУ
 * spaceָʾÿռ
 * S    ָʾ̬ͷ
 */

/* ÿռ */

/*
 *  㷨2.14 
 *
 * ʼÿռ
 *
 * ÿռΪ̬ṩõڴ档
 */
void InitSpace(SLinkList space) {
    int i;
    
    for(i = 0; i < MAXSIZE - 1; ++i) {
        space[i].cur = i + 1;
    }
    
    space[MAXSIZE - 1].cur = 0;
}

/*
 *  㷨2.15 
 *
 * ռ
 *
 * Ϊ̬ӱÿռռ䣬
 * ɹؿÿռ
 * ʧʱ0
 */
int Malloc(SLinkList space) {
    int i = space[0].cur;
    
    if(i != 0) {
        // 뵽Ŀռӱÿռɾȥ
        space[0].cur = space[i].cur;
    }
    
    // ±
    return i;
}

/*
 *  㷨2.16 
 *
 * տռ
 *
 * kĽռԹ̬ã
 * շʽǽýռӾ̬Ƴ
 * ӵÿռбС
 */
void Free(SLinkList space, int k) {
    space[k].cur = space[0].cur;
    space[0].cur = k;
}


/* ̬ */

/*
 * ʼ
 *
 * ȳʼÿռ䣬ӱÿռͷĿռ䣬ɾ̬ĳʼ
 * ʼɹʹS洢ͷҷOK򷵻ERROR
 */
Status InitList(SLinkList space, int* S) {
    int index;
    
    // ʼÿռ
    InitSpace(space);
    
    // ͷռ
    index = Malloc(space);
    
    if(index == 0) {
        return ERROR;
    }
    
    space[index].cur = 0;
    
    *S = index;
    
    return OK;
}

/*
 * (ṹ)
 *
 * ͷž̬ռڴ棬̬нռ뱸ÿռбС
 */
Status DestroyList(SLinkList space, int* S) {
    int cur;
    
    // ȷ̬
    if(S == NULL || *S == 0) {
        return ERROR;
    }
    
    while(*S != 0) {
        // ݴһ
        cur = space[*S].cur;
        // յǰռռ
        Free(space, *S);
        // ǰһ
        *S = cur;
    }
    
    return OK;
}

/*
 * ÿ()
 *
 * Ҫͷž̬зͷ㴦Ŀռ䡣
 */
Status ClearList(SLinkList space, int S) {
    int P;
    int cur;
    
    // ȷ̬
    if(S == 0) {
        return ERROR;
    }
    
    // ȡ̬׸
    P = space[S].cur;
    
    while(P != 0) {
        // ݴһ
        cur = space[P].cur;
        // յǰռռ
        Free(space, P);
        // ǰһ
        P = cur;
    }
    
    space[S].cur = 0;
    
    return OK;
}

/*
 * п
 *
 * жϾ̬ǷЧݡ
 *
 * ֵ
 * TRUE : ̬Ϊ
 * FALSE: ̬Ϊ
 */
Status ListEmpty(SLinkList space, int S) {
    // ֻͷľ̬Ϊձ
    if(S != 0 && space[S].cur == 0) {
        return TRUE;
    } else {
        return FALSE;
    }
}

/*
 * 
 *
 * ؾ̬ЧԪص
 */
int ListLength(SLinkList space, int S) {
    int count;
    
    // ̬ڣ̬Ϊʱ0
    if(S == 0 || space[S].cur == 0) {
        return 0;
    }
    
    // ȡ̬׸Ԫص
    S = space[S].cur;
    count = 0;
    
    while(S != 0) {
        count++;
        S = space[S].cur;
    }
    
    return count;
}

/*
 * ȡֵ
 *
 * ȡ̬еiԪأ洢eС
 * ҵOK򣬷ERROR
 *
 *ע
 * ̲iĺԪλã1ʼⲻϱͨԼ
 * ͨiĺӦָ0ʼ
 */
Status GetElem(SLinkList space, int S, int i, ElemType* e) {
    int count;
    
    // ȷ̬ҲΪ
    if(S == 0 || space[S].cur == 0) {
        return ERROR;
    }
    
    // ȡ̬׸Ԫص
    S = space[S].cur;
    count = 0;
    
    while(S != 0 && count < i - 1) {
        count++;
        S = space[S].cur;
    }
    
    if(S == 0 || count > i - 1) {
        return ERROR;
    }
    
    *e = space[S].data;
    
    return OK;
}

/*
 *  㷨2.13 
 *
 * 
 *
 * ؾ̬׸eCompareϵԪλ
 * Ԫأ򷵻0
 *
 *ע
 * 1.ԪeCompareڶβ
 * 2.ʵ̲ϵ㷨2.13ͬԭμġע⡱Ϣ
 */
int LocateElem(SLinkList space, int S, ElemType e, Status(Compare)(ElemType, ElemType)) {
    int i;
    int p;
    
    // ȷ̬ҲΪ
    if(S == 0 || space[S].cur == 0) {
        return 0;
    }
    
    i = 1;              // iĳֵΪ1Ԫصλ
    p = space[S].cur;   // pĳֵΪ1Ԫص
    
    while(p != 0 && !Compare(space[p].data, e)) {
        i++;
        p = space[p].cur;
    }
    
    if(p != 0) {
        return i;
    } else {
        return 0;
    }
}

/*
 * ǰ
 *
 * ȡԪcur_eǰ
 * ڣ洢pre_eУOK
 * ڣ򷵻ERROR
 */
Status PriorElem(SLinkList space, int S, ElemType cur_e, ElemType* pre_e) {
    int pre, next;
    
    // ȷ̬ҲΪ
    if(S == 0 || space[S].cur == 0) {
        return ERROR;
    }
    
    // ָ1Ԫ
    pre = space[S].cur;
    
    // 1Ԫûǰ
    if(space[pre].data == cur_e) {
        return ERROR;
    }
    
    // ָ2Ԫ
    next = space[pre].cur;
    
    // ӵ2Ԫؿʼcur_eλ
    while(next != 0 && space[next].data != cur_e) {
        pre = next;
        next = space[next].cur;
    }
    
    // ûҵԪcur_eʧܣERROR
    if(next == 0) {
        return ERROR;
    }
    
    *pre_e = space[pre].data;
    
    return OK;
}

/*
 * 
 *
 * ȡԪcur_eḷ́
 * ڣ洢next_eУOK
 * ڣ򷵻ERROR
 */
Status NextElem(SLinkList space, int S, ElemType cur_e, ElemType* next_e) {
    int pre;
    
    // ȷ̬ҲΪ
    if(S == 0 || space[S].cur == 0) {
        return ERROR;
    }
    
    // ָ1Ԫ
    pre = space[S].cur;
    
    // ӵ1Ԫؿʼcur_eλãұ֤ýĺ̴
    while(space[pre].cur != 0 && space[pre].data != cur_e) {
        pre = space[pre].cur;
    }
    
    // ûҵcur_eҵˣûк̣ERROR
    if(space[pre].cur == 0) {
        return ERROR;
    }
    
    *next_e = space[space[pre].cur].data;
    
    return OK;
}

/*
 * 
 *
 * ̬iλϲeɹ򷵻OK򷵻ERROR
 *
 *ע
 * ̲iĺԪλã1ʼ
 */
Status ListInsert(SLinkList space, int S, int i, ElemType e) {
    int p, s;
    int j;
    
    // ȷ̬
    if(S == 0) {
        return ERROR;
    }
    
    p = S;
    j = 0;
    
    // Ѱҵi-1㣬ұ֤ý㱾
    while(p != 0 && j < i - 1) {
        p = space[p].cur;
        ++j;
    }
    
    // ͷˣiֵϹ(i<=0)˵ûҵϺĿĽ
    if(p == 0 || j > i - 1) {
        return ERROR;
    }
    
    // ½
    s = Malloc(space);
    space[s].data = e;
    space[s].cur = space[p].cur;
    space[p].cur = s;
    
    return OK;
}

/*
 * ɾ
 *
 * ɾ̬iλϵԪأɾԪش洢eС
 * ɾɹ򷵻OK򷵻ERROR
 *
 *ע
 * ̲iĺԪλã1ʼ
 */
Status ListDelete(SLinkList space, int S, int i, ElemType* e) {
    int p, q;
    int j;
    
    // ȷ̬
    if(S == 0) {
        return ERROR;
    }
    
    p = S;
    j = 0;
    
    // Ѱҵi-1㣬ұ֤ýĺ̴
    while(space[p].cur != 0 && j < i - 1) {
        p = space[p].cur;
        ++j;
    }
    
    // ͷˣiֵϹ(i<=0)˵ûҵϺĿĽ
    if(space[p].cur == 0 || j > i - 1) {
        return ERROR;
    }
    
    // ɾi
    q = space[p].cur;
    space[p].cur = space[q].cur;
    *e = space[q].data;
    Free(space, q);
    
    return OK;
}

/*
 * 
 *
 * visitʾ̬S
 */
void ListTraverse(SLinkList space, int S, void(Visit)(ElemType)) {
    int p;
    
    // ȷ
    if(S == 0 || space[S].cur == 0) {
        return;
    }
    
    p = space[S].cur;
    
    while(p != 0) {
        Visit(space[p].data);
        p = space[p].cur;
    }
    
    printf("\n");
}


/* ͼλ */

// ͼλʽǰṹڲʹ
void PrintList(SLinkList space, int S) {
    int i = 0;
    
    printf("==== ÿռ ====\n");
    while(i < 20) {
        printf("%2d    | %2d | %2d |\n", i, space[i].data, space[i].cur);
        i = space[i].cur;
    }
    
    printf("==== ̬ ====\n");
    i = S;
    while(i>0 && i < 20) {
        printf("%2d    | %2d | %2d |\n", i, space[i].data, space[i].cur);
        i = space[i].cur;
    }
}

