/*===============================
 * Աʽ洢ṹ
 *
 * 㷨: 2.82.92.102.11
 ================================*/

#include "LinkList.h" //**02 Ա**//

/*
 * ʼ
 *
 * ֻǳʼһͷ㡣
 * ʼɹ򷵻OK򷵻ERROR
 */
Status InitList(LinkList* L) {
    (*L) = (LinkList) malloc(sizeof(LNode));
    if(*L == NULL) {
        exit(OVERFLOW);
    }
    
    (*L)->next = NULL;
    
    return OK;
}

/*
 * (ṹ)
 *
 * ͷռڴ棬ͷҲᱻ
 */
Status DestroyList(LinkList* L) {
    LinkList p;
    
    // ȷṹ
    if(L == NULL || *L == NULL) {
        return ERROR;
    }
    
    p = *L;
    
    while(p != NULL) {
        p = (*L)->next;
        free(*L);
        (*L) = p;
    }
    
    *L = NULL;
    
    return OK;
}

/*
 * ÿ()
 *
 * Ҫͷзͷ㴦Ŀռ䡣
 */
Status ClearList(LinkList L) {
    LinkList pre, p;
    
    // ȷ
    if(L == NULL) {
        return ERROR;
    }
    
    p = L->next;
    
    // ͷнռڴ
    while(p != NULL) {
        pre = p;
        p = p->next;
        free(pre);
    }
    
    L->next = NULL;
    
    return OK;
}

/*
 * п
 *
 * жǷЧݡ
 *
 * ֵ
 * TRUE : Ϊ
 * FALSE: Ϊ
 */
Status ListEmpty(LinkList L) {
    // ֻͷʱΪΪ
    if(L != NULL && L->next == NULL) {
        return TRUE;
    } else {
        return FALSE;
    }
}

/*
 * 
 *
 * ЧԪص
 */
int ListLength(LinkList L) {
    LinkList p;
    int i;
    
    // ȷҲΪձ
    if(L == NULL || L->next == NULL) {
        return 0;
    }
    
    i = 0;
    p = L->next;
    
    // н
    while(p != NULL) {
        i++;
        p = p->next;
    }
    
    return i;
}

/*
 *  㷨2.8 
 *
 * ȡֵ
 *
 * ȡеiԪأ洢eС
 * ҵOK򣬷ERROR
 *
 *ע
 * ̲iĺԪλã1ʼⲻϱͨԼ
 * ͨiĺӦָ0ʼ
 */
Status GetElem(LinkList L, int i, ElemType* e) {
    LinkList p;
    int j;
    
    // ȷҲΪձ
    if(L == NULL || L->next == NULL) {
        return ERROR;
    }
    
    p = L;
    j = 0;
    
    // Ѱҵi-1㣬ұ֤ýĺ̲ΪNULL
    while(p->next != NULL && j < i - 1) {
        p = p->next;
        ++j;
    }
    
    // ͷˣiֵϹ(i<=0)˵ûҵϺĿĽ
    if(p->next == NULL || j > i - 1) {
        return ERROR;
    }
    
    *e = p->next->data;
    
    return OK;
}

/*
 * 
 *
 * ׸eCompareϵԪλ
 * Ԫأ򷵻0
 *
 *ע
 * ԪeCompareڶβ
 */
int LocateElem(LinkList L, ElemType e, Status(Compare)(ElemType, ElemType)) {
    int i;
    LinkList p;
    
    // ȷҲΪձ
    if(L == NULL || L->next == NULL) {
        return 0;
    }
    
    i = 1;          // iĳֵΪ1Ԫصλ
    p = L->next;    // pĳֵΪ1Ԫصָ
    
    while(p != NULL && !Compare(p->data, e)) {
        i++;
        p = p->next;
    }
    
    if(p != NULL) {
        return i;
    } else {
        return 0;
    }
}

/*
 * ǰ
 *
 * ȡԪcur_eǰ
 * ڣ洢pre_eУOK
 * ڣ򷵻ERROR
 */
Status PriorElem(LinkList L, ElemType cur_e, ElemType* pre_e) {
    LinkList pre, next;
    
    // ȷҲΪձ
    if(L == NULL || L->next == NULL) {
        return ERROR;
    }
    
    // ָ1Ԫ
    pre = L->next;
    
    // 1Ԫûǰ
    if(pre->data == cur_e) {
        return ERROR;
    }
    
    // ָ2Ԫ
    next = pre->next;
    
    // ӵ2Ԫؿʼcur_eλ
    while(next != NULL && next->data != cur_e) {
        pre = next;
        next = next->next;
    }
    
    // ûҵԪcur_eʧܣERROR
    if(next == NULL) {
        return ERROR;
    }
    
    *pre_e = pre->data;
    
    return OK;
}

/*
 * 
 *
 * ȡԪcur_eḷ́
 * ڣ洢next_eУOK
 * ڣ򷵻ERROR
 */
Status NextElem(LinkList L, ElemType cur_e, ElemType* next_e) {
    LinkList pre;
    
    // ȷҲΪձ
    if(L == NULL || L->next == NULL) {
        return ERROR;
    }
    
    // ָ1Ԫ
    pre = L->next;
    
    // ӵ1Ԫؿʼcur_eλãұ֤ýĺ̲ΪNULL
    while(pre->next != NULL && pre->data != cur_e) {
        pre = pre->next;
    }
    
    // ûҵcur_eҵˣûк̣ERROR
    if(pre->next == NULL) {
        return ERROR;
    }
    
    *next_e = pre->next->data;
    
    return OK;
}

/*
 *  㷨2.9 
 *
 * 
 *
 * iλϲeɹ򷵻OK򷵻ERROR
 *
 *ע
 * ̲iĺԪλã1ʼ
 */
Status ListInsert(LinkList L, int i, ElemType e) {
    LinkList p, s;
    int j;
    
    // ȷ
    if(L == NULL) {
        return ERROR;
    }
    
    p = L;
    j = 0;
    
    // Ѱҵi-1㣬ұ֤ý㱾ΪNULL
    while(p != NULL && j < i - 1) {
        p = p->next;
        ++j;
    }
    
    // ͷˣiֵϹ(i<=0)˵ûҵϺĿĽ
    if(p == NULL || j > i - 1) {
        return ERROR;
    }
    
    // ½
    s = (LinkList) malloc(sizeof(LNode));
    if(s == NULL) {
        exit(OVERFLOW);
    }
    s->data = e;
    s->next = p->next;
    p->next = s;
    
    return OK;
}

/*
 *  㷨2.10 
 *
 * ɾ
 *
 * ɾiλϵԪأɾԪش洢eС
 * ɾɹ򷵻OK򷵻ERROR
 *
 *ע
 * ̲iĺԪλã1ʼ
 */
Status ListDelete(LinkList L, int i, ElemType* e) {
    LinkList p, q;
    int j;
    
    // ȷҲΪձ
    if(L == NULL || L->next == NULL) {
        return ERROR;
    }
    
    p = L;
    j = 0;
    
    // Ѱҵi-1㣬ұ֤ýĺ̲ΪNULL
    while(p->next != NULL && j < i - 1) {
        p = p->next;
        ++j;
    }
    
    // ͷˣiֵϹ(i<=0)˵ûҵϺĿĽ
    if(p->next == NULL || j > i - 1) {
        return ERROR;
    }
    
    // ɾi
    q = p->next;
    p->next = q->next;
    *e = q->data;
    free(q);
    
    return OK;
}

/*
 * 
 *
 * visitL
 */
void ListTraverse(LinkList L, void(Visit)(ElemType)) {
    LinkList p;
    
    // ȷҲΪձ
    if(L == NULL || L->next == NULL) {
        return;
    }
    
    p = L->next;
    
    while(p != NULL) {
        Visit(p->data);
        p = p->next;
    }
    
    printf("\n");
}

/*
 *  㷨2.11 
 *
 * ͷ巨
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateList_Head(LinkList* L, int n, char* path) {
    int i;
    LinkList p;
    FILE* fp;
    int readFromConsole;    // Ƿӿ̨ȡ

    // ûļ·Ϣӿ̨ȡ
    readFromConsole = path == NULL || strcmp(path, "") == 0;

    if(readFromConsole) {
        // ͷ
        *L = (LinkList) malloc(sizeof(LNode));
        (*L)->next = NULL;

        printf("%dԪأ", n);

        for(i = 1; i <= n; ++i) {
            // ½
            p = (LinkList) malloc(sizeof(LNode));

            // ݣ뵽
            scanf("%d", &(p->data));

            p->next = (*L)->next;
            (*L)->next = p;
        }
    } else {
        // ļ׼ȡ
        fp = fopen(path, "r");
        if(fp == NULL) {
            return ERROR;
        }

        // ͷ
        *L = (LinkList) malloc(sizeof(LNode));
        (*L)->next = NULL;

        for(i = 1; i <= n; ++i) {
            // ½
            p = (LinkList) malloc(sizeof(LNode));

            // ݣ뵽
            ReadData(fp, "%d", &(p->data));

            p->next = (*L)->next;
            (*L)->next = p;
        }

        fclose(fp);
    }

    return OK;
}

/*
 * β巨
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateList_Tail(LinkList* L, int n, char* path) {
    int i;
    LinkList p, q;
    FILE* fp;
    int readFromConsole;    // Ƿӿ̨ȡ

    // ûļ·Ϣӿ̨ȡ
    readFromConsole = path == NULL || strcmp(path, "") == 0;

    if(readFromConsole) {
        // ͷ
        *L = (LinkList) malloc(sizeof(LNode));
        (*L)->next = NULL;

        printf("%dԪأ", n);

        for(i = 1, q = *L; i <= n; ++i) {
            // ½
            p = (LinkList) malloc(sizeof(LNode));

            // ݣ뵽
            scanf("%d", &(p->data));

            q->next = p;
            q = q->next;
        }

        q->next = NULL;
    } else {
        // ļ׼ȡ
        fp = fopen(path, "r");
        if(fp == NULL) {
            return ERROR;
        }

        // ͷ
        *L = (LinkList) malloc(sizeof(LNode));
        (*L)->next = NULL;

        for(i = 1, q = *L; i <= n; ++i) {
            // ½
            p = (LinkList) malloc(sizeof(LNode));

            // ݣ뵽
            ReadData(fp, "%d", &(p->data));

            q->next = p;
            q = q->next;
        }

        q->next = NULL;

        fclose(fp);
    }

    return OK;
}

