/*=============================
 * Ա˳洢ṹ˳
 *
 * 㷨: 2.32.42.52.6
 =============================*/

#include "SqList.h"

/*
 *  㷨2.3 
 *
 * ʼ
 *
 * ʼɹ򷵻OK򷵻ERROR
 */
Status InitList(SqList* L) {
    // ָڴ棬ʧܣ򷵻NULL
    (*L).elem = (ElemType*) malloc(LIST_INIT_SIZE * sizeof(ElemType));
    if((*L).elem == NULL) {
        // 洢ڴʧ
        exit(OVERFLOW);
    }

    (*L).length = 0;                    // ʼ˳Ϊ0
    (*L).listsize = LIST_INIT_SIZE;     // ˳ʼڴ

    return OK;                          // ʼɹ
}

/*
 * (ṹ)
 *
 * ͷ˳ռڴ档
 */
Status DestroyList(SqList* L) {
    // ȷ˳ṹ
    if(L == NULL || (*L).elem == NULL) {
        return ERROR;
    }

    // ͷ˳ڴ
    free((*L).elem);

    // ͷڴÿָ
    (*L).elem = NULL;

    // ˳ȸ
    (*L).length = 0;
    (*L).listsize = 0;

    return OK;
}

/*
 * ÿ()
 *
 * ֻ˳д洢ݣͷ˳ռڴ档
 */
Status ClearList(SqList* L) {
    // ȷ˳ṹ
    if(L == NULL || (*L).elem == NULL) {
        return ERROR;
    }

    (*L).length = 0;

    return OK;
}

/*
 * п
 *
 * ж˳ǷЧݡ
 *
 * ֵ
 * TRUE : ˳Ϊ
 * FALSE: ˳Ϊ
 */
Status ListEmpty(SqList L) {
    return L.length == 0 ? TRUE : FALSE;
}

/*
 * 
 *
 * ˳ЧԪص
 */
int ListLength(SqList L) {
    return L.length;
}

/*
 * ȡֵ
 *
 * ȡ˳еiԪأ洢eС
 * ҵOK򣬷ERROR
 *
 *ע
 * ̲iĺԪλã1ʼⲻϱͨԼ
 * ͨiĺӦָ0ʼ
 */
Status GetElem(SqList L, int i, ElemType* e) {
    // ΪiĺλãϷΧǣ[1, length]
    if(i < 1 || i > L.length) {
        return ERROR;                    //iֵϷ
    }

    *e = L.elem[i - 1];

    return OK;
}

/*
 *  㷨2.6 
 *
 * 
 *
 * ˳׸eCompareϵԪλ
 * Ԫأ򷵻0
 *
 *ע
 * ԪeCompareڶβ
 */
int LocateElem(SqList L, ElemType e, Status(Compare)(ElemType, ElemType)) {
    int i;
    ElemType* p;

    // ȷ˳ṹ
    if(L.elem == NULL) {
        return ERROR;
    }

    /*
     * iĳֵΪ1Ԫصλ
     *
     * ʵȻдǽiʼΪ1Ԫص
     * ڽ̲ǰλģдλ
     */
    i = 1;

    // pĳֵΪ1ԪصĴ洢λ
    p = L.elem;

    // ˳
    while(i <= L.length && !Compare(*p++, e)) {
        ++i;
    }

    if(i <= L.length) {
        return i;
    } else {
        return 0;
    }
}

/*
 * ǰ
 *
 * ȡԪcur_eǰ
 * ڣ洢pre_eУOK
 * ڣ򷵻ERROR
 */
Status PriorElem(SqList L, ElemType cur_e, ElemType* pre_e) {
    int i;

    // ȷ˳ṹڣٰԪ
    if(L.elem == NULL || L.length < 2) {
        return ERROR;
    }

    // iʼΪ1Ԫصġ
    i = 0;

    // ӵ1Ԫؿʼcur_eλ
    while(i < L.length && L.elem[i] != cur_e) {
        ++i;
    }

    // cur_e׸Ԫ(ûǰ)ûҵԪcur_eERROR
    if(i==0 || i >= L.length) {
        return ERROR;
    }

    // 洢cur_eǰ
    *pre_e = L.elem[i - 1];

    return OK;
}

/*
 * 
 *
 * ȡԪcur_eḷ́
 * ڣ洢next_eУOK
 * ڣ򷵻ERROR
 */
Status NextElem(SqList L, ElemType cur_e, ElemType* next_e) {
    int i;

    // ȷ˳ṹڣٰԪ
    if(L.elem == NULL || L.length < 2) {
        return ERROR;
    }

    // iʼΪ1Ԫصġ
    i = 0;

    // ӵ1Ԫؿʼcur_eλ
    while(i < L.length-1 && L.elem[i] != cur_e) {
        ++i;
    }

    // cur_e1Ԫ(ûǰ)ûҵԪcur_eERROR
    if(i >= L.length-1) {
        return ERROR;
    }

    // 洢cur_eǰ
    *next_e = L.elem[i + 1];

    return OK;
}

/*
 *  㷨2.4 
 *
 * 
 *
 * ˳iλϲeɹ򷵻OK򷵻ERROR
 *
 *ע
 * ̲iĺԪλã1ʼ
 */
Status ListInsert(SqList* L, int i, ElemType e) {
    ElemType* newbase;
    ElemType* p, * q;

    // ȷ˳ṹ
    if(L == NULL || (*L).elem == NULL) {
        return ERROR;
    }

    // iֵԽ
    if(i < 1 || i > (*L).length + 1) {
        return ERROR;
    }

    // 洢ռ¿ռ
    if((*L).length >= (*L).listsize) {
        // пռ
        newbase = (ElemType*) realloc((*L).elem, ((*L).listsize + LISTINCREMENT) * sizeof(ElemType));
        if(newbase == NULL) {
            // 洢ڴʧ
            exit(OVERFLOW);
        }

        // »ַ
        (*L).elem = newbase;
        // Ĵ洢ռ
        (*L).listsize += LISTINCREMENT;
    }

    // qΪλ
    q = &(*L).elem[i - 1];

    // 1.Ԫأڳλ
    for(p = &(*L).elem[(*L).length - 1]; p >= q; --p) {
        *(p + 1) = *p;
    }

    // 2.e
    *q = e;

    // 3.1
    (*L).length++;

    return OK;
}

/*
 *  㷨2.5 
 *
 * ɾ
 *
 * ɾ˳iλϵԪأɾԪش洢eС
 * ɾɹ򷵻OK򷵻ERROR
 *
 *ע
 * ̲iĺԪλã1ʼ
 */
Status ListDelete(SqList* L, int i, ElemType* e) {
    ElemType* p, * q;

    // ȷ˳ṹ
    if(L == NULL || (*L).elem == NULL) {
        return ERROR;
    }

    // iֵԽ
    if(i < 1 || i > (*L).length) {
        return ERROR;
    }

    // pΪɾԪصλ
    p = &(*L).elem[i - 1];

    // 1.ȡɾԪ
    *e = *p;

    // βԪλ
    q = (*L).elem + (*L).length - 1;

    // 2.ԪأɾԪصλϻԪؽ
    for(++p; p <= q; ++p) {
        *(p - 1) = *p;
    }

    // 3.1
    (*L).length--;

    return OK;
}

/*
 * 
 *
 * visit˳L
 */
void ListTraverse(SqList L, void(Visit)(ElemType)) {
    int i;

    for(i = 0; i < L.length; i++) {
        Visit(L.elem[i]);
    }

    printf("\n");
}

