import asyncio
import inspect

from selenium_driverless.input.pointer import Pointer as AsyncPointer, PointerType


class Pointer(AsyncPointer):
    def __init__(self, target, pointer_type: str = PointerType.MOUSE, loop: asyncio.AbstractEventLoop = None):
        super().__init__(target=target, pointer_type=pointer_type)
        if not loop:
            loop = asyncio.new_event_loop()
            asyncio.set_event_loop(loop)
        self._loop = loop

    def __exit__(self, *args, **kwargs):
        return self.__aexit__(*args, **kwargs)

    def __getattribute__(self, item):
        res = super().__getattribute__(item)
        if res is None or item == "_loop":
            return res
        loop = self._loop
        if loop and (not loop.is_running()):
            if inspect.iscoroutinefunction(res):
                def syncified(*args, **kwargs):
                    return self._loop.run_until_complete(res(*args, **kwargs))

                return syncified
            if inspect.isawaitable(res):
                return self._loop.run_until_complete(res)
        return res
