# Configuration file for the Sphinx documentation builder.
#
# For the full list of built-in configuration values, see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Project information -----------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#project-information
import sys

sys.path.insert(0, r"/")
from selenium_driverless import __version__

project = 'Selenium-Driverless'
# noinspection PyShadowingBuiltins
copyright = '2024, Aurin Aegerter (aka Steve, kaliiiiiiiiii)'
author = 'Aurin Aegerter (aka Steve, kaliiiiiiiiii)'
release = __version__

# -- General configuration ---------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#general-configuration

extensions = [
    'sphinx.ext.duration',
    'sphinx.ext.doctest',
    'sphinx.ext.autodoc',
    'sphinx.ext.autosummary',
    "sphinx_autodoc_typehints",
    "sphinx.ext.viewcode"
]

templates_path = ['_templates']
exclude_patterns = []

# -- Options for HTML output -------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#options-for-html-output

html_theme = 'sphinx_rtd_theme'
html_static_path = ['_static']


# -- autodoc options --

autodoc_member_order = 'bysource'
