/* 
 **************************************************************************************************
 *
 * @file    : button.h
 * @author  : Bayrem GHARSELLAOUI
 * @date    : October 2021
 * @brief   : STM32 bluepill button BSP header file
 * 
 **************************************************************************************************
 */

#ifndef __BUTTON_H__
#define __BUTTON_H__

/*-----------------------------------------------------------------------------------------------*/
/* Includes                                                                                      */
/*-----------------------------------------------------------------------------------------------*/
#include <stdbool.h>

/*-----------------------------------------------------------------------------------------------*/
/* Types                                                                                         */
/*-----------------------------------------------------------------------------------------------*/
typedef void (*button_callback_t)(void);

/*-----------------------------------------------------------------------------------------------*/
/* Functions                                                                                     */
/*-----------------------------------------------------------------------------------------------*/
void button_init(void);
void button_register_callback(button_callback_t);
bool button_is_pressed(void);

#endif /* __BUTTON_H__ */