package com.anafthdev.musicompose2.foundation.uicomponent

import androidx.compose.animation.core.*
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.*
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.unit.dp
import com.anafthdev.musicompose2.foundation.theme.circle

@Composable
fun AudioWave(
	isMusicPlaying: Boolean,
	modifier: Modifier = Modifier
) {
	
	val transition1 = rememberInfiniteTransition()
	val transition2 = rememberInfiniteTransition()
	val transition3 = rememberInfiniteTransition()
	
	val fraction1 by transition1.animateFloat(
		initialValue = 0.3f,
		targetValue = 1f,
		animationSpec = infiniteRepeatable(
			repeatMode = RepeatMode.Reverse,
			animation = tween(
				durationMillis = 1600,
				easing = LinearEasing
			)
		)
	)
	
	val fraction2 by transition2.animateFloat(
		initialValue = 0.3f,
		targetValue = 1f,
		animationSpec = infiniteRepeatable(
			repeatMode = RepeatMode.Reverse,
			animation = tween(
				durationMillis = 800,
				easing = LinearEasing
			)
		)
	)
	
	val fraction3 by transition3.animateFloat(
		initialValue = 0.3f,
		targetValue = 1f,
		animationSpec = infiniteRepeatable(
			repeatMode = RepeatMode.Reverse,
			animation = tween(
				durationMillis = 1200,
				easing = LinearEasing
			)
		)
	)
	
	Row(
		verticalAlignment = Alignment.CenterVertically,
		horizontalArrangement = Arrangement.SpaceEvenly,
		modifier = modifier
			.size(
				width = 24.dp,
				height = 20.dp
			)
	) {
		Box(
			modifier = Modifier
				.width(4.dp)
				.fillMaxHeight(if (!isMusicPlaying) 0.3f else fraction1)
				.clip(circle)
				.background(MaterialTheme.colorScheme.primary)
		)
		
		Box(
			modifier = Modifier
				.width(4.dp)
				.fillMaxHeight(if (!isMusicPlaying) 0.5f else fraction2)
				.clip(circle)
				.background(MaterialTheme.colorScheme.primary)
		)
		
		Box(
			modifier = Modifier
				.width(4.dp)
				.fillMaxHeight(if (!isMusicPlaying) 0.3f else fraction3)
				.clip(circle)
				.background(MaterialTheme.colorScheme.primary)
		)
	}
}
