package com.anafthdev.musicompose2.foundation.extension

import androidx.compose.material3.TabPosition
import androidx.compose.ui.Modifier
import androidx.compose.ui.layout.layout
import androidx.compose.ui.unit.Constraints
import androidx.compose.ui.unit.lerp
import com.google.accompanist.pager.ExperimentalPagerApi
import com.google.accompanist.pager.PagerState

/**
 * pagerTabIndicatorOffset for Material Design 3
 */
@ExperimentalPagerApi
fun Modifier.pagerTabIndicatorOffset(
	pagerState: PagerState,
	tabPositions: List<TabPosition>,
	pageIndexMapping: (Int) -> Int = { it },
): Modifier = layout { measurable, constraints ->
	if (tabPositions.isEmpty()) {
		// If there are no pages, nothing to show
		layout(constraints.maxWidth, 0) {}
	} else {
		val currentPage = minOf(tabPositions.lastIndex, pageIndexMapping(pagerState.currentPage))
		val currentTab = tabPositions[currentPage]
		val previousTab = tabPositions.getOrNull(currentPage - 1)
		val nextTab = tabPositions.getOrNull(currentPage + 1)
		val fraction = pagerState.currentPageOffset
		val indicatorWidth = if (fraction > 0 && nextTab != null) {
			lerp(currentTab.width, nextTab.width, fraction).roundToPx()
		} else if (fraction < 0 && previousTab != null) {
			lerp(currentTab.width, previousTab.width, -fraction).roundToPx()
		} else {
			currentTab.width.roundToPx()
		}
		val indicatorOffset = if (fraction > 0 && nextTab != null) {
			lerp(currentTab.left, nextTab.left, fraction).roundToPx()
		} else if (fraction < 0 && previousTab != null) {
			lerp(currentTab.left, previousTab.left, -fraction).roundToPx()
		} else {
			currentTab.left.roundToPx()
		}
		val placeable = measurable.measure(
			Constraints(
				minWidth = indicatorWidth,
				maxWidth = indicatorWidth,
				minHeight = 0,
				maxHeight = constraints.maxHeight
			)
		)
		layout(constraints.maxWidth, maxOf(placeable.height, constraints.minHeight)) {
			placeable.place(
				indicatorOffset,
				maxOf(constraints.minHeight - placeable.height, 0)
			)
		}
	}
}
