// Generated by CoffeeScript 1.4.0
(function() {
  var timeParser,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  timeParser = function(str) {
    var key, number, timeUnits, unit, _i, _len, _ref;
    timeUnits = {
      year: {
        patterns: ["year", "years", "Y"],
        period: 365 * 24 * 60 * 60 * 1000
      },
      month: {
        patterns: ["month", "months", "M"],
        period: 30 * 7 * 24 * 60 * 60 * 1000
      },
      week: {
        patterns: ["week", "weeks", "W"],
        period: 7 * 24 * 60 * 60 * 1000
      },
      day: {
        patterns: ["day", "days", "D"],
        period: 24 * 60 * 60 * 1000
      },
      hour: {
        patterns: ["hour", "hours", "h"],
        period: 60 * 60 * 1000
      },
      minute: {
        patterns: ["minute", "minutes", "m"],
        period: 60 * 1000
      },
      second: {
        patterns: ["second", "seconds", "s"],
        period: 1000
      }
    };
    number = parseFloat(str.replace(/[a-zA-Z]+/g, "").trim());
    unit = str.replace(/[^a-zA-Z]+/g, "").trim();
    _ref = Object.keys(timeUnits);
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      key = _ref[_i];
      if (__indexOf.call(timeUnits[key].patterns, unit) >= 0) {
        return timeUnits[key].period * (number > 0 ? number : 1);
      }
    }
  };

  module.exports = {
    delayed: function(options) {
      var period;
      if (((options != null ? options.task : void 0) != null) && ((options != null ? options.period : void 0) != null) && typeof options.task === "function") {
        period = timeParser(options.period);
        return setTimeout(function() {
          return process.nextTick(function() {
            return options.task();
          });
        }, period);
      }
    },
    repeat: function(options) {
      var period;
      if (((options != null ? options.task : void 0) != null) && ((options != null ? options.period : void 0) != null) && typeof options.task === "function") {
        period = timeParser(options.period);
        process.nextTick(function() {
          return options.task();
        });
        return setInterval(function() {
          return process.nextTick(function() {
            return options.task();
          });
        }, period);
      }
    }
  };

}).call(this);
