# Intro
Storybook is a development environment for UI components. It allows you to browse a component library, view the different states of each component, and interactively develop and test components.

Storybook runs outside of your app. This allows you to develop UI components in isolation, which can improve component reuse, testability, and development speed. You can build quickly without having to worry about application-specific dependencies.

# Usage

### Storybook story file location
`packages/f-<component-name>/stories/*.stories.js`

### Running Storybook locally
`yarn storybook:deploy`


### Using the Vue Dev tools
To use the Vue Dev tools you need to open the canvas in a new tab (using the link in the top right of Storybook).

### Global css styles
If you need to add styles that should be available in every story you can add them to `config/storybook/scss-loader.scss`. For example we import our glodal fozzie styles and some optional mixins which will be added in concuming application, not the components themselves.


## More Info

### [Just Eat Storybook production](https://vue.pie.design/)

### [Storybook Documentation - Writing Stories](https://storybook.js.org/docs/basics/writing-stories/)
