const messages = {
    locale: 'en-GB',
    percentage: '10',
    currency: 'pound',
    currencySymbol: '£',
    termsUrl: '/info/terms-and-conditions#stampcards-terms-conditions',
    termsText: 'See Terms & Conditions',
    header: {
        title: 'StampCards',
        text: 'See the stamps you’ve collected and any discounts you’ve earned.',
        alt: 'Collect your stamps image'
    },
    tabs: {
        stamps: {
            title: 'Your StampCards',
            readyToClaimTitle: 'Ready To Claim',
            inProgressTitle: 'In Progress',
            participatingRestaurantsTitle: 'Participating Restaurants',
            participatingRestaurantsSubtitle: 'What’s cooking in {location}'
        },
        howItWorks: {
            title: 'How it works'
        }
    },
    stamps: {
        errorNoCards: {
            title: 'When you order from a participating restaurant, your stamps will be shown here.',
            subTitle: 'Expecting to see your stamps? Try refreshing this screen by going back to the home screen then coming back here.'
        }
    },
    unauthenticated: {
        loginTitle: 'Log in to get started',
        loginButtonText: 'Log in'
    },
    howItWorks: {
        imagePath: 'https://just-eat-prod-eu-res.cloudinary.com/image/upload/v1630068495/Experiments/Homeweb-Coreweb/',
        title: 'Save on your favourite flavours',
        text: 'Get rewarded for your loyalty. Start collecting stamps from your favourite restaurants and unlock a tasty little discount on the way…',
        exampleSection: {
            title: 'For example',
            orders: 'Your Orders',
            percentage: '10% from each order',
            total: 'Total discount for 6th order',
            accessibilityText: 'If you place 5 orders totalling $230, you would earn a discount worth $34.50 for your sixth order.'
        },
        media: {
            title: 'How does it work?',
            cards: {
                order: {
                    title: 'Order',
                    text: 'Collect a stamp every time you order from a participating restaurant.',
                    image: 'https://just-eat-prod-eu-res.cloudinary.com/image/upload/v1630068495/Experiments/Homeweb-Coreweb/stampcards-complex-object-restaurant-promo.svg'
                },
                earn: {
                    title: 'Earn',
                    text: 'Each stamp is worth 10% of your order’s value (exc. fees and charges) and will be saved on its own StampCard.',
                    image: 'https://just-eat-prod-eu-res.cloudinary.com/image/upload/v1630068495/Experiments/Homeweb-Coreweb/stampcards-complex-object-login-promo-full-colour-10.svg'
                },
                collect: {
                    title: 'Collect',
                    text: 'Once you’ve collected five stamps from the same restaurant you’ll unlock a discount for your sixth order.',
                    image: 'https://just-eat-prod-eu-res.cloudinary.com/image/upload/v1630068495/Experiments/Homeweb-Coreweb/stampcards-complex-object-stampcard-colour-03-10-full.svg'
                },
                reward: {
                    title: 'Get rewarded',
                    text: 'Your discount is the total of your five saved stamps and will be automatically applied when you place your sixth order.',
                    image: 'https://just-eat-prod-eu-res.cloudinary.com/image/upload/v1630068495/Experiments/Homeweb-Coreweb/stampcards-bag-order-refund.svg'
                }
            }
        }
    }
};

export default {
    messages
};
