# Jupyter Notebook Documentation

Welcome to the **Jupyter Notebook** documentation site. **Jupyter Notebook**
is a simplified notebook authoring application, and is a part of [Project
Jupyter](https://docs.jupyter.org/en/latest/), a large umbrella project
centered around the goal of providing tools (and [standards](https://docs.jupyter.org/en/latest/#sub-project-documentation))
for interactive computing with [computational notebooks](https://docs.jupyter.org/en/latest/#what-is-a-notebook).

A [computational notebook](https://docs.jupyter.org/en/latest/#what-is-a-notebook)
is a shareable document that combines computer
code, plain language descriptions, data, rich visualizations like 3D models,
charts, graphs and figures, and interactive controls. A notebook, along with
an editor like **Jupyter Notebook**, provides a fast interactive environment for
prototyping and explaining code, exploring and visualizing data, and sharing
ideas with others.

**Jupyter Notebook** is a sibling to other notebook authoring applications under
the Project Jupyter umbrella, like [JupyterLab](https://jupyterlab.readthedocs.io/en/stable/)
and [Jupyter Desktop](https://github.com/jupyterlab/jupyterlab-desktop).
Jupyter Notebook offers a lightweight, simplified experience compared to JupyterLab.

Read more about how to use **Jupyter Notebook** on this site, in the [User
Documentation](notebook.md).

```{image} ./_static/images/notebook-running-code.png

```

- [Installation](https://jupyter.readthedocs.io/en/latest/install.html)
- [Starting the Notebook](https://jupyter.readthedocs.io/en/latest/running.html)

```{toctree}
:maxdepth: 2

user-documentation
configuration
migrate_to_notebook7
contributor
changelog
```
