/*
 * Decompiled with CFR 0.152.
 */
package com.baeldung.axon.querymodel;

import com.baeldung.axon.coreapi.queries.FindAllOrderedProductsQuery;
import com.baeldung.axon.coreapi.queries.Order;
import com.baeldung.axon.coreapi.queries.OrderUpdatesQuery;
import com.baeldung.axon.coreapi.queries.TotalProductsShippedQuery;
import com.baeldung.axon.querymodel.OrderResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.reactivestreams.Publisher;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

@Service
public class OrderQueryService {
    private final QueryGateway queryGateway;

    public OrderQueryService(QueryGateway queryGateway) {
        this.queryGateway = queryGateway;
    }

    public CompletableFuture<List<OrderResponse>> findAllOrders() {
        return this.queryGateway.query((Object)new FindAllOrderedProductsQuery(), ResponseTypes.multipleInstancesOf(Order.class)).thenApply(r -> r.stream().map(OrderResponse::new).collect(Collectors.toList()));
    }

    public Flux<OrderResponse> allOrdersStreaming() {
        Publisher publisher = this.queryGateway.streamingQuery((Object)new FindAllOrderedProductsQuery(), Order.class);
        return Flux.from((Publisher)publisher).map(OrderResponse::new);
    }

    public Integer totalShipped(String productId) {
        return this.queryGateway.scatterGather((Object)new TotalProductsShippedQuery(productId), ResponseTypes.instanceOf(Integer.class), 10L, TimeUnit.SECONDS).reduce(0, Integer::sum);
    }

    public Flux<OrderResponse> orderUpdates(String orderId) {
        return this.subscriptionQuery(new OrderUpdatesQuery(orderId), ResponseTypes.instanceOf(Order.class)).map(OrderResponse::new);
    }

    private <Q, R> Flux<R> subscriptionQuery(Q query, ResponseType<R> resultType) {
        SubscriptionQueryResult result = this.queryGateway.subscriptionQuery(query, resultType, resultType);
        return result.initialResult().concatWith((Publisher)result.updates()).doFinally(signal -> result.close());
    }
}

