/*
 * Decompiled with CFR 0.152.
 */
package com.baeldung.axon.querymodel;

import com.baeldung.axon.coreapi.events.OrderConfirmedEvent;
import com.baeldung.axon.coreapi.events.OrderCreatedEvent;
import com.baeldung.axon.coreapi.events.OrderShippedEvent;
import com.baeldung.axon.coreapi.events.ProductAddedEvent;
import com.baeldung.axon.coreapi.events.ProductCountDecrementedEvent;
import com.baeldung.axon.coreapi.events.ProductCountIncrementedEvent;
import com.baeldung.axon.coreapi.events.ProductRemovedEvent;
import com.baeldung.axon.coreapi.queries.FindAllOrderedProductsQuery;
import com.baeldung.axon.coreapi.queries.Order;
import com.baeldung.axon.coreapi.queries.OrderStatus;
import com.baeldung.axon.coreapi.queries.OrderUpdatesQuery;
import com.baeldung.axon.coreapi.queries.TotalProductsShippedQuery;
import com.baeldung.axon.querymodel.OrdersEventHandler;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.result.UpdateResult;
import groovyjarjarantlr4.v4.runtime.misc.NotNull;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.axonframework.config.ProcessingGroup;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

@Service
@ProcessingGroup(value="orders")
@Profile(value={"mongo"})
public class MongoOrdersEventHandler
implements OrdersEventHandler {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MongoCollection<Document> orders;
    private final QueryUpdateEmitter emitter;
    private static final String ORDER_COLLECTION_NAME = "orders";
    private static final String AXON_FRAMEWORK_DATABASE_NAME = "axonframework";
    private static final String ORDER_ID_PROPERTY_NAME = "orderId";
    private static final String PRODUCTS_PROPERTY_NAME = "products";
    private static final String ORDER_STATUS_PROPERTY_NAME = "orderStatus";

    public MongoOrdersEventHandler(MongoClient client, QueryUpdateEmitter emitter) {
        this.orders = client.getDatabase(AXON_FRAMEWORK_DATABASE_NAME).getCollection(ORDER_COLLECTION_NAME);
        this.orders.createIndex(Indexes.ascending((String[])new String[]{ORDER_ID_PROPERTY_NAME}), new IndexOptions().unique(true));
        this.emitter = emitter;
    }

    @Override
    @EventHandler
    public void on(OrderCreatedEvent event) {
        this.orders.insertOne((Object)this.orderToDocument(new Order(event.getOrderId())));
    }

    @Override
    @EventHandler
    public void on(ProductAddedEvent event) {
        this.update(event.getOrderId(), o -> o.addProduct(event.getProductId()));
    }

    @Override
    @EventHandler
    public void on(ProductCountIncrementedEvent event) {
        this.update(event.getOrderId(), o -> o.incrementProductInstance(event.getProductId()));
    }

    @Override
    @EventHandler
    public void on(ProductCountDecrementedEvent event) {
        this.update(event.getOrderId(), o -> o.decrementProductInstance(event.getProductId()));
    }

    @Override
    @EventHandler
    public void on(ProductRemovedEvent event) {
        this.update(event.getOrderId(), o -> o.removeProduct(event.getProductId()));
    }

    @Override
    @EventHandler
    public void on(OrderConfirmedEvent event) {
        this.update(event.getOrderId(), Order::setOrderConfirmed);
    }

    @Override
    @EventHandler
    public void on(OrderShippedEvent event) {
        this.update(event.getOrderId(), Order::setOrderShipped);
    }

    @Override
    @QueryHandler
    public List<Order> handle(FindAllOrderedProductsQuery query) {
        ArrayList<Order> orderList = new ArrayList<Order>();
        this.orders.find().forEach(d -> orderList.add(this.documentToOrder((Document)d)));
        return orderList;
    }

    @Override
    public Publisher<Order> handleStreaming(FindAllOrderedProductsQuery query) {
        return Flux.fromIterable((Iterable)this.orders.find()).map(this::documentToOrder);
    }

    @Override
    @QueryHandler
    public Integer handle(TotalProductsShippedQuery query) {
        AtomicInteger result = new AtomicInteger();
        this.orders.find(this.shippedProductFilter(query.getProductId())).map(d -> (Document)d.get((Object)PRODUCTS_PROPERTY_NAME, Document.class)).map(d -> d.getInteger((Object)query.getProductId(), 0)).forEach(result::addAndGet);
        return result.get();
    }

    @Override
    @QueryHandler
    public Order handle(OrderUpdatesQuery query) {
        return this.getOrder(query.getOrderId()).orElse(null);
    }

    @Override
    public void reset(List<Order> orderList) {
        this.orders.deleteMany((Bson)new Document());
        orderList.forEach(o -> this.orders.insertOne((Object)this.orderToDocument((Order)o)));
    }

    private Optional<Order> getOrder(String orderId) {
        return Optional.ofNullable((Document)this.orders.find(Filters.eq((String)ORDER_ID_PROPERTY_NAME, (Object)orderId)).first()).map(this::documentToOrder);
    }

    private Order emitUpdate(Order order) {
        this.emitter.emit(OrderUpdatesQuery.class, q -> order.getOrderId().equals(q.getOrderId()), (Object)order);
        return order;
    }

    private Order updateOrder(Order order, Consumer<Order> updateFunction) {
        updateFunction.accept(order);
        return order;
    }

    private UpdateResult persistUpdate(Order order) {
        return this.orders.replaceOne(Filters.eq((String)ORDER_ID_PROPERTY_NAME, (Object)order.getOrderId()), (Object)this.orderToDocument(order));
    }

    private void update(String orderId, Consumer<Order> updateFunction) {
        UpdateResult result = this.getOrder(orderId).map(o -> this.updateOrder((Order)o, updateFunction)).map(this::emitUpdate).map(this::persistUpdate).orElse(null);
        logger.info("Result of updating order with orderId '{}': {}", (Object)orderId, (Object)result);
    }

    private Document orderToDocument(Order order) {
        return new Document(ORDER_ID_PROPERTY_NAME, (Object)order.getOrderId()).append(PRODUCTS_PROPERTY_NAME, order.getProducts()).append(ORDER_STATUS_PROPERTY_NAME, (Object)order.getOrderStatus().toString());
    }

    private Order documentToOrder(@NotNull Document document) {
        Order order = new Order(document.getString((Object)ORDER_ID_PROPERTY_NAME));
        Document products = (Document)document.get((Object)PRODUCTS_PROPERTY_NAME, Document.class);
        products.forEach((k, v) -> order.getProducts().put((String)k, (Integer)v));
        String status = document.getString((Object)ORDER_STATUS_PROPERTY_NAME);
        if (OrderStatus.CONFIRMED.toString().equals(status)) {
            order.setOrderConfirmed();
        } else if (OrderStatus.SHIPPED.toString().equals(status)) {
            order.setOrderShipped();
        }
        return order;
    }

    private Bson shippedProductFilter(String productId) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)ORDER_STATUS_PROPERTY_NAME, (Object)OrderStatus.SHIPPED.toString()), Filters.exists((String)String.format("products.%s", productId))});
    }
}

