/*
 * Decompiled with CFR 0.152.
 */
package com.baeldung.axon.querymodel;

import com.baeldung.axon.coreapi.events.OrderConfirmedEvent;
import com.baeldung.axon.coreapi.events.OrderCreatedEvent;
import com.baeldung.axon.coreapi.events.OrderShippedEvent;
import com.baeldung.axon.coreapi.events.ProductAddedEvent;
import com.baeldung.axon.coreapi.events.ProductCountDecrementedEvent;
import com.baeldung.axon.coreapi.events.ProductCountIncrementedEvent;
import com.baeldung.axon.coreapi.events.ProductRemovedEvent;
import com.baeldung.axon.coreapi.queries.FindAllOrderedProductsQuery;
import com.baeldung.axon.coreapi.queries.Order;
import com.baeldung.axon.coreapi.queries.OrderStatus;
import com.baeldung.axon.coreapi.queries.OrderUpdatesQuery;
import com.baeldung.axon.coreapi.queries.TotalProductsShippedQuery;
import com.baeldung.axon.querymodel.OrdersEventHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.axonframework.config.ProcessingGroup;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.reactivestreams.Publisher;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
@ProcessingGroup(value="orders")
@Profile(value={"!mongo"})
public class InMemoryOrdersEventHandler
implements OrdersEventHandler {
    private final Map<String, Order> orders = new HashMap<String, Order>();
    private final QueryUpdateEmitter emitter;

    public InMemoryOrdersEventHandler(QueryUpdateEmitter emitter) {
        this.emitter = emitter;
    }

    @Override
    @EventHandler
    public void on(OrderCreatedEvent event) {
        String orderId = event.getOrderId();
        this.orders.put(orderId, new Order(orderId));
    }

    @Override
    @EventHandler
    public void on(ProductAddedEvent event) {
        this.orders.computeIfPresent(event.getOrderId(), (orderId, order) -> {
            order.addProduct(event.getProductId());
            this.emitUpdate((Order)order);
            return order;
        });
    }

    @Override
    @EventHandler
    public void on(ProductCountIncrementedEvent event) {
        this.orders.computeIfPresent(event.getOrderId(), (orderId, order) -> {
            order.incrementProductInstance(event.getProductId());
            this.emitUpdate((Order)order);
            return order;
        });
    }

    @Override
    @EventHandler
    public void on(ProductCountDecrementedEvent event) {
        this.orders.computeIfPresent(event.getOrderId(), (orderId, order) -> {
            order.decrementProductInstance(event.getProductId());
            this.emitUpdate((Order)order);
            return order;
        });
    }

    @Override
    @EventHandler
    public void on(ProductRemovedEvent event) {
        this.orders.computeIfPresent(event.getOrderId(), (orderId, order) -> {
            order.removeProduct(event.getProductId());
            this.emitUpdate((Order)order);
            return order;
        });
    }

    @Override
    @EventHandler
    public void on(OrderConfirmedEvent event) {
        this.orders.computeIfPresent(event.getOrderId(), (orderId, order) -> {
            order.setOrderConfirmed();
            this.emitUpdate((Order)order);
            return order;
        });
    }

    @Override
    @EventHandler
    public void on(OrderShippedEvent event) {
        this.orders.computeIfPresent(event.getOrderId(), (orderId, order) -> {
            order.setOrderShipped();
            this.emitUpdate((Order)order);
            return order;
        });
    }

    @Override
    @QueryHandler
    public List<Order> handle(FindAllOrderedProductsQuery query) {
        return new ArrayList<Order>(this.orders.values());
    }

    @Override
    @QueryHandler
    public Publisher<Order> handleStreaming(FindAllOrderedProductsQuery query) {
        return Mono.fromCallable(this.orders::values).flatMapMany(Flux::fromIterable);
    }

    @Override
    @QueryHandler
    public Integer handle(TotalProductsShippedQuery query) {
        return this.orders.values().stream().filter(o -> o.getOrderStatus() == OrderStatus.SHIPPED).map(o -> Optional.ofNullable(o.getProducts().get(query.getProductId())).orElse(0)).reduce(0, Integer::sum);
    }

    @Override
    @QueryHandler
    public Order handle(OrderUpdatesQuery query) {
        return this.orders.get(query.getOrderId());
    }

    private void emitUpdate(Order order) {
        this.emitter.emit(OrderUpdatesQuery.class, q -> order.getOrderId().equals(q.getOrderId()), (Object)order);
    }

    @Override
    public void reset(List<Order> orderList) {
        this.orders.clear();
        orderList.forEach(o -> this.orders.put(o.getOrderId(), (Order)o));
    }
}

