/*
 * Decompiled with CFR 0.152.
 */
package com.baeldung.axon.gui;

import com.baeldung.axon.coreapi.commands.AddProductCommand;
import com.baeldung.axon.coreapi.commands.ConfirmOrderCommand;
import com.baeldung.axon.coreapi.commands.CreateOrderCommand;
import com.baeldung.axon.coreapi.commands.DecrementProductCountCommand;
import com.baeldung.axon.coreapi.commands.IncrementProductCountCommand;
import com.baeldung.axon.coreapi.commands.ShipOrderCommand;
import com.baeldung.axon.querymodel.OrderQueryService;
import com.baeldung.axon.querymodel.OrderResponse;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
public class OrderRestEndpoint {
    private final CommandGateway commandGateway;
    private final OrderQueryService orderQueryService;

    public OrderRestEndpoint(CommandGateway commandGateway, OrderQueryService orderQueryService) {
        this.commandGateway = commandGateway;
        this.orderQueryService = orderQueryService;
    }

    @PostMapping(value={"/ship-order"})
    public CompletableFuture<Void> shipOrder() {
        String orderId = UUID.randomUUID().toString();
        return ((CompletableFuture)((CompletableFuture)this.commandGateway.send((Object)new CreateOrderCommand(orderId)).thenCompose(result -> this.commandGateway.send((Object)new AddProductCommand(orderId, "Deluxe Chair")))).thenCompose(result -> this.commandGateway.send((Object)new ConfirmOrderCommand(orderId)))).thenCompose(result -> this.commandGateway.send((Object)new ShipOrderCommand(orderId)));
    }

    @PostMapping(value={"/ship-unconfirmed-order"})
    public CompletableFuture<Void> shipUnconfirmedOrder() {
        String orderId = UUID.randomUUID().toString();
        return ((CompletableFuture)this.commandGateway.send((Object)new CreateOrderCommand(orderId)).thenCompose(result -> this.commandGateway.send((Object)new AddProductCommand(orderId, "Deluxe Chair")))).thenCompose(result -> this.commandGateway.send((Object)new ShipOrderCommand(orderId)));
    }

    @PostMapping(value={"/order"})
    public CompletableFuture<String> createOrder() {
        return this.createOrder(UUID.randomUUID().toString());
    }

    @PostMapping(value={"/order/{order-id}"})
    public CompletableFuture<String> createOrder(@PathVariable(value="order-id") String orderId) {
        return this.commandGateway.send((Object)new CreateOrderCommand(orderId));
    }

    @PostMapping(value={"/order/{order-id}/product/{product-id}"})
    public CompletableFuture<Void> addProduct(@PathVariable(value="order-id") String orderId, @PathVariable(value="product-id") String productId) {
        return this.commandGateway.send((Object)new AddProductCommand(orderId, productId));
    }

    @PostMapping(value={"/order/{order-id}/product/{product-id}/increment"})
    public CompletableFuture<Void> incrementProduct(@PathVariable(value="order-id") String orderId, @PathVariable(value="product-id") String productId) {
        return this.commandGateway.send((Object)new IncrementProductCountCommand(orderId, productId));
    }

    @PostMapping(value={"/order/{order-id}/product/{product-id}/decrement"})
    public CompletableFuture<Void> decrementProduct(@PathVariable(value="order-id") String orderId, @PathVariable(value="product-id") String productId) {
        return this.commandGateway.send((Object)new DecrementProductCountCommand(orderId, productId));
    }

    @PostMapping(value={"/order/{order-id}/confirm"})
    public CompletableFuture<Void> confirmOrder(@PathVariable(value="order-id") String orderId) {
        return this.commandGateway.send((Object)new ConfirmOrderCommand(orderId));
    }

    @PostMapping(value={"/order/{order-id}/ship"})
    public CompletableFuture<Void> shipOrder(@PathVariable(value="order-id") String orderId) {
        return this.commandGateway.send((Object)new ShipOrderCommand(orderId));
    }

    @GetMapping(value={"/all-orders"})
    public CompletableFuture<List<OrderResponse>> findAllOrders() {
        return this.orderQueryService.findAllOrders();
    }

    @GetMapping(path={"/all-orders-streaming"}, produces={"text/event-stream"})
    public Flux<OrderResponse> allOrdersStreaming() {
        return this.orderQueryService.allOrdersStreaming();
    }

    @GetMapping(value={"/total-shipped/{product-id}"})
    public Integer totalShipped(@PathVariable(value="product-id") String productId) {
        return this.orderQueryService.totalShipped(productId);
    }

    @GetMapping(path={"/order-updates/{order-id}"}, produces={"text/event-stream"})
    public Flux<OrderResponse> orderUpdates(@PathVariable(value="order-id") String orderId) {
        return this.orderQueryService.orderUpdates(orderId);
    }
}

