/*
 * Decompiled with CFR 0.152.
 */
package com.baeldung.axon.coreapi.queries;

import com.baeldung.axon.coreapi.queries.OrderStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Order {
    private final String orderId;
    private final Map<String, Integer> products;
    private OrderStatus orderStatus;

    public Order(String orderId) {
        this.orderId = orderId;
        this.products = new HashMap<String, Integer>();
        this.orderStatus = OrderStatus.CREATED;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public Map<String, Integer> getProducts() {
        return this.products;
    }

    public OrderStatus getOrderStatus() {
        return this.orderStatus;
    }

    public void addProduct(String productId) {
        this.products.putIfAbsent(productId, 1);
    }

    public void incrementProductInstance(String productId) {
        this.products.computeIfPresent(productId, (id, count) -> {
            count = count + 1;
            return count;
        });
    }

    public void decrementProductInstance(String productId) {
        this.products.computeIfPresent(productId, (id, count) -> {
            count = count - 1;
            return count;
        });
    }

    public void removeProduct(String productId) {
        this.products.remove(productId);
    }

    public void setOrderConfirmed() {
        this.orderStatus = OrderStatus.CONFIRMED;
    }

    public void setOrderShipped() {
        this.orderStatus = OrderStatus.SHIPPED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Order that = (Order)o;
        return Objects.equals(this.orderId, that.orderId) && Objects.equals(this.products, that.products) && this.orderStatus == that.orderStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.orderId, this.products, this.orderStatus});
    }

    public String toString() {
        return "Order{orderId='" + this.orderId + '\'' + ", products=" + this.products + ", orderStatus=" + (Object)((Object)this.orderStatus) + '}';
    }
}

