/*
 * Decompiled with CFR 0.152.
 */
package com.baeldung.axon.commandmodel.order;

import com.baeldung.axon.coreapi.commands.DecrementProductCountCommand;
import com.baeldung.axon.coreapi.commands.IncrementProductCountCommand;
import com.baeldung.axon.coreapi.events.OrderConfirmedEvent;
import com.baeldung.axon.coreapi.events.ProductCountDecrementedEvent;
import com.baeldung.axon.coreapi.events.ProductCountIncrementedEvent;
import com.baeldung.axon.coreapi.events.ProductRemovedEvent;
import com.baeldung.axon.coreapi.exceptions.OrderAlreadyConfirmedException;
import java.util.Objects;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.eventsourcing.EventSourcingHandler;
import org.axonframework.modelling.command.AggregateLifecycle;
import org.axonframework.modelling.command.EntityId;

public class OrderLine {
    @EntityId
    private final String productId;
    private Integer count;
    private boolean orderConfirmed;

    public OrderLine(String productId) {
        this.productId = productId;
        this.count = 1;
    }

    @CommandHandler
    public void handle(IncrementProductCountCommand command) {
        if (this.orderConfirmed) {
            throw new OrderAlreadyConfirmedException(command.getOrderId());
        }
        AggregateLifecycle.apply((Object)new ProductCountIncrementedEvent(command.getOrderId(), this.productId));
    }

    @CommandHandler
    public void handle(DecrementProductCountCommand command) {
        if (this.orderConfirmed) {
            throw new OrderAlreadyConfirmedException(command.getOrderId());
        }
        if (this.count <= 1) {
            AggregateLifecycle.apply((Object)new ProductRemovedEvent(command.getOrderId(), this.productId));
        } else {
            AggregateLifecycle.apply((Object)new ProductCountDecrementedEvent(command.getOrderId(), this.productId));
        }
    }

    @EventSourcingHandler
    public void on(ProductCountIncrementedEvent event) {
        Integer n = this.count;
        this.count = this.count + 1;
    }

    @EventSourcingHandler
    public void on(ProductCountDecrementedEvent event) {
        Integer n = this.count;
        this.count = this.count - 1;
    }

    @EventSourcingHandler
    public void on(OrderConfirmedEvent event) {
        this.orderConfirmed = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderLine orderLine = (OrderLine)o;
        return Objects.equals(this.productId, orderLine.productId) && Objects.equals(this.count, orderLine.count);
    }

    public int hashCode() {
        return Objects.hash(this.productId, this.count);
    }
}

