/*
 * Decompiled with CFR 0.152.
 */
package sift.core.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.github.ajalt.mordant.rendering.TextStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sift.core.terminal.Gruvbox;
import sift.core.tree.Tree;
import sift.core.tree.TreeWalker;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, scope=Tree.class)
@JsonIgnoreProperties(value={"depth", "prev", "next"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\u000b\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\"\u001a\u00020\u0006H\u0016J&\u0010#\u001a\b\u0012\u0004\u0012\u0002H$0\u0000\"\u0004\b\u0001\u0010$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H$0&J\u0012\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u001cJ\"\u0010(\u001a\u00020\u001e2\u001a\u0010)\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u00000*j\n\u0012\u0006\b\u0000\u0012\u00028\u0000`+J\b\u0010,\u001a\u00020-H\u0016J:\u0010,\u001a\u00020-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020-0&2\u0014\b\u0002\u0010/\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020-0&2\b\b\u0002\u00100\u001a\u000201J\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u000003R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0019\u0010\u0013\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00064"}, d2={"Lsift/core/tree/Tree;", "T", "", "value", "(Ljava/lang/Object;)V", "depth", "", "getDepth", "()I", "<set-?>", "index", "getIndex", "next", "getNext", "()Lsift/core/tree/Tree;", "nodes", "", "parent", "getParent", "prev", "getPrev", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "add", "(Ljava/lang/Object;)Lsift/core/tree/Tree;", "node", "children", "", "delete", "", "equals", "", "other", "hashCode", "map", "U", "f", "Lkotlin/Function1;", "parents", "sort", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "toString", "", "format", "prefix", "structure", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "walk", "Lsift/core/tree/TreeWalker;", "core"})
@SourceDebugExtension(value={"SMAP\nTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tree.kt\nsift/core/tree/Tree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,116:1\n1864#2,3:117\n1549#2:120\n1620#2,3:121\n1855#2,2:124\n1864#2,3:129\n1#3:126\n1295#4,2:127\n*S KotlinDebug\n*F\n+ 1 Tree.kt\nsift/core/tree/Tree\n*L\n39#1:117,3\n67#1:120\n67#1:121,3\n67#1:124,2\n91#1:129,3\n107#1:127,2\n*E\n"})
public final class Tree<T> {
    private final T value;
    @Nullable
    private Tree<T> parent;
    @NotNull
    private final List<Tree<T>> nodes;
    private int index;

    public Tree(T value) {
        this.value = value;
        this.nodes = new ArrayList();
    }

    public final T getValue() {
        return this.value;
    }

    @Nullable
    public final Tree<T> getParent() {
        return this.parent;
    }

    public final int getDepth() {
        return ((Collection)this.parents()).size();
    }

    public final int getIndex() {
        return this.index;
    }

    @Nullable
    public final Tree<T> getNext() {
        Tree<T> tree;
        Integer n;
        Tree<T> tree2 = this.parent;
        Integer n2 = tree2 != null && (tree2 = tree2.nodes) != null ? Integer.valueOf(tree2.size()) : (n = null);
        if (n == null) {
            tree = null;
        } else {
            int n3 = this.index;
            if (n == n3) {
                tree = null;
            } else {
                Tree<T> tree3 = this.parent;
                Intrinsics.checkNotNull(tree3);
                tree = tree3.nodes.get(this.index + 1);
            }
        }
        return tree;
    }

    @Nullable
    public final Tree<T> getPrev() {
        Tree<T> tree;
        if (this.index == 0) {
            tree = this.parent;
        } else {
            Tree<T> tree2 = this.parent;
            Intrinsics.checkNotNull(tree2);
            tree = tree2.nodes.get(this.index - 1);
        }
        return tree;
    }

    public final void delete() {
        Object object;
        Tree<T> tree = this.parent;
        if (tree != null) {
            Tree<T> it = tree;
            boolean bl = false;
            this.nodes.remove(this);
            Iterable $this$forEachIndexed$iv = this.nodes;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Tree tree2 = (Tree)item$iv;
                int index = n;
                boolean bl2 = false;
                node.index = index;
            }
        }
        if ((object = this.parent) != null && (object = ((Tree)object).nodes) != null) {
            object.remove(this);
        }
        this.parent = null;
    }

    @NotNull
    public final Tree<T> add(@NotNull Tree<T> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        node.delete();
        node.parent = this;
        node.index = this.nodes.size();
        ((Collection)this.nodes).add(node);
        return node;
    }

    @NotNull
    public final Tree<T> add(T value) {
        return this.add((T)new Tree<T>(value));
    }

    @NotNull
    public final List<Tree<T>> children() {
        return CollectionsKt.toList((Iterable)this.nodes);
    }

    public boolean equals(@Nullable Object other) {
        Tree tree = other instanceof Tree ? (Tree)other : null;
        return Intrinsics.areEqual(tree != null ? tree.value : null, this.value);
    }

    public int hashCode() {
        T t = this.value;
        return t != null ? t.hashCode() : 0;
    }

    @NotNull
    public final TreeWalker<T> walk() {
        return new TreeWalker(this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <U> Tree<U> map(@NotNull Function1<? super T, ? extends U> f2) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Tree<Object> tree;
        Intrinsics.checkNotNullParameter(f2, (String)"f");
        Tree<Object> tree2 = tree = new Tree<Object>(f2.invoke(this.value));
        boolean bl = false;
        Iterable $this$map$iv = this.children();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tree tree3 = (Tree)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.map(f2));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tree p0 = (Tree)element$iv;
            boolean bl3 = false;
            tree2.add((Object)p0);
        }
        return tree;
    }

    @NotNull
    public String toString() {
        return Tree.toString$default(this, toString.1.INSTANCE, null, null, 6, null);
    }

    @NotNull
    public final String toString(@NotNull Function1<? super T, String> format2, @NotNull Function1<? super T, String> prefix, @NotNull TextStyle structure) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(format2, (String)"format");
        Intrinsics.checkNotNullParameter(prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        StringBuilder it = stringBuilder = Tree.toString$print(format2, prefix, structure, this, "", true, new StringBuilder());
        boolean bl = false;
        it.setCharAt(StringsKt.indexOf$default((CharSequence)it, (char)'\u2514', (int)0, (boolean)false, (int)6, null), '\u2500');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(this, \"\", true, St\u2026}\n            .toString()");
        return string;
    }

    public static /* synthetic */ String toString$default(Tree tree, Function1 function1, Function1 function12, TextStyle textStyle, int n, Object object) {
        if ((n & 2) != 0) {
            function12 = toString.2.INSTANCE;
        }
        if ((n & 4) != 0) {
            textStyle = Gruvbox.INSTANCE.getLight2();
        }
        return tree.toString(function1, function12, textStyle);
    }

    public final void sort(@NotNull Comparator<? super T> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)this.walk(), (Function1)sort.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tree it = (Tree)element$iv;
            boolean bl = false;
            CollectionsKt.sortWith(it.nodes, (arg_0, arg_1) -> Tree.sort$lambda$7$lambda$6((Function2)new Function2<Tree<T>, Tree<T>, Integer>(comparator){
                final /* synthetic */ Comparator<? super T> $comparator;
                {
                    this.$comparator = $comparator;
                    super(2);
                }

                @NotNull
                public final Integer invoke(Tree<T> o1, Tree<T> o2) {
                    return this.$comparator.compare(o1.getValue(), o2.getValue());
                }
            }, arg_0, arg_1));
        }
    }

    @NotNull
    public final List<Tree<T>> parents() {
        return this.parent == null ? CollectionsKt.emptyList() : SequencesKt.toList((Sequence)SequencesKt.generateSequence(this.parent, (Function1)((Function1)parents.1.INSTANCE)));
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> StringBuilder toString$print(Function1<? super T, String> $format, Function1<? super T, String> $prefix, TextStyle $structure, Tree<T> node, String indent, boolean last, StringBuilder out) {
        char delim = last ? (char)'\u2514' : '\u251c';
        String value = (String)$format.invoke(node.value);
        out.append($prefix.invoke(node.value) + $structure.invoke(indent + delim + "\u2500") + " " + value + "\n");
        String nextIndent = indent + (last ? "   " : "\u2502  ");
        Iterable $this$forEachIndexed$iv = node.nodes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void n;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Tree tree = (Tree)item$iv;
            int i = n2;
            boolean bl = false;
            boolean isLast = i == CollectionsKt.getLastIndex(node.nodes);
            Tree.toString$print($format, $prefix, $structure, n, nextIndent, isLast, out);
        }
        return out;
    }

    private static final int sort$lambda$7$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    public static final /* synthetic */ List access$getNodes$p(Tree $this) {
        return $this.nodes;
    }

    public static final /* synthetic */ void access$setParent$p(Tree $this, Tree tree) {
        $this.parent = tree;
    }
}

