/*
 * Decompiled with CFR 0.152.
 */
package sift.core.terminal;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.github.ajalt.mordant.rendering.TextStyle;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import sift.core.terminal.ChangeCase;
import sift.core.terminal.Deduplicate;
import sift.core.terminal.IdSequencer;
import sift.core.terminal.Replace;
import sift.core.terminal.TextEdit;
import sift.core.terminal.TextTransformerKt;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=TextEdit.class, name="edit"), @JsonSubTypes.Type(value=Deduplicate.class, name="dedupe"), @JsonSubTypes.Type(value=IdSequencer.class, name="id-sequence"), @JsonSubTypes.Type(value=Replace.class, name="replace"), @JsonSubTypes.Type(value=ChangeCase.class, name="change-case")})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bw\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0011\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u00a6\u0002\u0082\u0001\u0005\u0007\b\t\n\u000b\u00a8\u0006\f"}, d2={"Lsift/core/terminal/TextTransformer;", "", "invoke", "", "any", "s", "Companion", "Lsift/core/terminal/ChangeCase;", "Lsift/core/terminal/Deduplicate;", "Lsift/core/terminal/IdSequencer;", "Lsift/core/terminal/Replace;", "Lsift/core/terminal/TextEdit;", "core"})
public interface TextTransformer {
    @NotNull
    public static final Companion Companion = sift.core.terminal.TextTransformer$Companion.$$INSTANCE;

    @NotNull
    public String invoke(@NotNull String var1);

    @NotNull
    public String invoke(@NotNull Object var1);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001f\u0010\u0007\u001a\u00020\u00042\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\t\"\u00020\u0004\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0004J\u0006\u0010\u0019\u001a\u00020\u0004\u00a8\u0006\u001a"}, d2={"Lsift/core/terminal/TextTransformer$Companion;", "", "()V", "dedupe", "Lsift/core/terminal/TextTransformer;", "char", "", "edit", "transformers", "", "([Lsift/core/terminal/TextTransformer;)Lsift/core/terminal/TextTransformer;", "idSequence", "regex", "Lkotlin/text/Regex;", "group", "", "lowercase", "replace", "text", "", "with", "stylize", "style", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "uppercase", "uuidSequence", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final TextTransformer edit(TextTransformer ... transformers) {
            Intrinsics.checkNotNullParameter((Object)transformers, (String)"transformers");
            return new TextEdit(ArraysKt.toList((Object[])transformers));
        }

        @NotNull
        public final TextTransformer dedupe(char c) {
            return new Deduplicate(c);
        }

        @NotNull
        public final TextTransformer idSequence(@NotNull Regex regex, int group) {
            Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
            return new IdSequencer(regex, group);
        }

        public static /* synthetic */ TextTransformer idSequence$default(Companion companion, Regex regex, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.idSequence(regex, n);
        }

        @NotNull
        public final TextTransformer uuidSequence() {
            return sift.core.terminal.TextTransformer$Companion.idSequence$default(this, TextTransformerKt.access$getUuidRegex$p(), 0, 2, null);
        }

        @NotNull
        public final TextTransformer replace(@NotNull String text, @NotNull String with) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)with, (String)"with");
            String string = Pattern.quote(text);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"quote(text)");
            String string2 = string;
            return new Replace(new Regex(string2), with);
        }

        @NotNull
        public final TextTransformer replace(@NotNull Regex regex, @NotNull String with) {
            Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
            Intrinsics.checkNotNullParameter((Object)with, (String)"with");
            return new Replace(regex, with);
        }

        @NotNull
        public final TextTransformer stylize(@NotNull TextStyle style) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            return new Replace(TextTransformerKt.access$getEverythingRegex$p(), style.invoke("$0"));
        }

        @NotNull
        public final TextTransformer uppercase() {
            return new ChangeCase(ChangeCase.Convention.uppercase);
        }

        @NotNull
        public final TextTransformer lowercase() {
            return new ChangeCase(ChangeCase.Convention.lowercase);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static String invoke(@NotNull TextTransformer $this, @NotNull Object any) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            return $this.invoke(any.toString());
        }
    }
}

