/*
 * Decompiled with CFR 0.152.
 */
package sift.core.terminal;

import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyles;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import sift.core.entity.Entity;
import sift.core.terminal.StyleKt;
import sift.core.tree.DiffNode;
import sift.core.tree.EntityNode;
import sift.core.tree.Tree;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u0000 \n2\u00020\u0001:\u0006\n\u000b\f\r\u000e\u000fJ-\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00000\bH&\u00f8\u0001\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lsift/core/terminal/Style;", "", "format", "", "e", "Lsift/core/tree/Tree;", "Lsift/core/tree/EntityNode;", "theme", "", "Lsift/core/entity/Entity$Type;", "Companion", "Diff", "FromEntityRef", "FromParent", "FromProperty", "Plain", "core"})
public interface Style {
    @NotNull
    public static final Companion Companion = sift.core.terminal.Style$Companion.$$INSTANCE;

    @NotNull
    public String format(@NotNull Tree<EntityNode> var1, @NotNull Map<Entity.Type, ? extends Style> var2);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lsift/core/terminal/Style$Companion;", "", "()V", "diff", "Lsift/core/terminal/Style$Diff;", "wrap", "Lsift/core/terminal/Style;", "entityRef", "Lsift/core/terminal/Style$FromEntityRef;", "key", "", "fallback", "fromParent", "Lsift/core/terminal/Style$FromParent;", "fromProperty", "Lsift/core/terminal/Style$FromProperty;", "plain", "Lsift/core/terminal/Style$Plain;", "textStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final Plain plain(@NotNull TextStyle textStyle) {
            Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
            return new Plain(textStyle);
        }

        @NotNull
        public final FromEntityRef entityRef(@NotNull String key, @NotNull Style fallback) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
            return new FromEntityRef(key, fallback);
        }

        public static /* synthetic */ FromEntityRef entityRef$default(Companion companion, String string, Style style, int n, Object object) {
            if ((n & 1) != 0) {
                string = "@style-as";
            }
            return companion.entityRef(string, style);
        }

        @NotNull
        public final Diff diff(@NotNull Style wrap) {
            Intrinsics.checkNotNullParameter((Object)wrap, (String)"wrap");
            return new Diff(wrap);
        }

        @NotNull
        public final FromParent fromParent() {
            return FromParent.INSTANCE;
        }

        @NotNull
        public final FromProperty fromProperty(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new FromProperty(key);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J-\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fH\u0016\u00f8\u0001\u0000R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"Lsift/core/terminal/Style$Diff;", "Lsift/core/terminal/Style;", "wrapped", "(Lsift/core/terminal/Style;)V", "getWrapped", "()Lsift/core/terminal/Style;", "format", "", "e", "Lsift/core/tree/Tree;", "Lsift/core/tree/EntityNode;", "theme", "", "Lsift/core/entity/Entity$Type;", "core"})
    public static final class Diff
    implements Style {
        @NotNull
        private final Style wrapped;

        public Diff(@NotNull Style wrapped) {
            Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
            this.wrapped = wrapped;
        }

        @NotNull
        public final Style getWrapped() {
            return this.wrapped;
        }

        @Override
        @NotNull
        public String format(@NotNull Tree<EntityNode> e, @NotNull Map<Entity.Type, ? extends Style> theme) {
            Intrinsics.checkNotNullParameter(e, (String)"e");
            Intrinsics.checkNotNullParameter(theme, (String)"theme");
            String formatted = this.wrapped.format(e, theme);
            Object object = e.getValue().get("@diff");
            DiffNode.State state = object instanceof DiffNode.State ? (DiffNode.State)((Object)object) : null;
            return switch (state == null ? -1 : WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case -1 -> formatted;
                case 1 -> formatted;
                case 2 -> TextStyles.bold.plus(TextStyles.underline).plus(TextStyles.italic).invoke(formatted);
                case 3 -> TextStyles.strikethrough.invoke(formatted);
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DiffNode.State.values().length];
                try {
                    nArray[DiffNode.State.Unchanged.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DiffNode.State.Added.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DiffNode.State.Removed.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J-\u0010\n\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00010\u000fH\u0016\u00f8\u0001\u0000R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lsift/core/terminal/Style$FromEntityRef;", "Lsift/core/terminal/Style;", "key", "", "fallback", "(Ljava/lang/String;Lsift/core/terminal/Style;)V", "getFallback", "()Lsift/core/terminal/Style;", "getKey", "()Ljava/lang/String;", "format", "e", "Lsift/core/tree/Tree;", "Lsift/core/tree/EntityNode;", "theme", "", "Lsift/core/entity/Entity$Type;", "core"})
    @SourceDebugExtension(value={"SMAP\nStyle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Style.kt\nsift/core/terminal/Style$FromEntityRef\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
    public static final class FromEntityRef
    implements Style {
        @NotNull
        private final String key;
        @NotNull
        private final Style fallback;

        public FromEntityRef(@NotNull String key, @NotNull Style fallback) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
            this.key = key;
            this.fallback = fallback;
        }

        public /* synthetic */ FromEntityRef(String string, Style style, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "@style-as";
            }
            this(string, style);
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final Style getFallback() {
            return this.fallback;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public String format(@NotNull Tree<EntityNode> e, @NotNull Map<Entity.Type, ? extends Style> theme) {
            Style style;
            Intrinsics.checkNotNullParameter(e, (String)"e");
            Intrinsics.checkNotNullParameter(theme, (String)"theme");
            List<Object> list = StyleKt.access$getEntity(e).get(this.key);
            if (list != null) {
                List<Object> it = list;
                boolean bl = false;
                Map<Entity.Type, ? extends Style> map2 = theme;
                Object object = CollectionsKt.first(it);
                String string = object instanceof Entity.Type ? ((Entity.Type)object).unbox-impl() : null;
                Style style2 = map2.get(string != null ? Entity.Type.box-impl(string) : null);
                if (style2 != null) {
                    style = style2;
                    return style.format(e, theme);
                }
            }
            style = this.fallback;
            return style.format(e, theme);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tH\u0016\u00f8\u0001\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000b"}, d2={"Lsift/core/terminal/Style$FromParent;", "Lsift/core/terminal/Style;", "()V", "format", "", "e", "Lsift/core/tree/Tree;", "Lsift/core/tree/EntityNode;", "theme", "", "Lsift/core/entity/Entity$Type;", "core"})
    public static final class FromParent
    implements Style {
        @NotNull
        public static final FromParent INSTANCE = new FromParent();

        private FromParent() {
        }

        @Override
        @NotNull
        public String format(@NotNull Tree<EntityNode> e, @NotNull Map<Entity.Type, ? extends Style> theme) {
            Intrinsics.checkNotNullParameter(e, (String)"e");
            Intrinsics.checkNotNullParameter(theme, (String)"theme");
            Tree<EntityNode> tree = e.getParent();
            Intrinsics.checkNotNull(tree);
            EntityNode entityNode = tree.getValue();
            Intrinsics.checkNotNull((Object)entityNode, (String)"null cannot be cast to non-null type sift.core.tree.EntityNode.Entity");
            String parentType = ((EntityNode.Entity)entityNode).getEntity().getType-f7BBXPQ();
            Style style = theme.get(Entity.Type.box-impl(parentType));
            Intrinsics.checkNotNull((Object)style);
            return style.format(e, theme);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010\u0007\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fH\u0016\u00f8\u0001\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"Lsift/core/terminal/Style$FromProperty;", "Lsift/core/terminal/Style;", "typeKey", "", "(Ljava/lang/String;)V", "getTypeKey", "()Ljava/lang/String;", "format", "e", "Lsift/core/tree/Tree;", "Lsift/core/tree/EntityNode;", "theme", "", "Lsift/core/entity/Entity$Type;", "core"})
    public static final class FromProperty
    implements Style {
        @NotNull
        private final String typeKey;

        public FromProperty(@NotNull String typeKey) {
            Intrinsics.checkNotNullParameter((Object)typeKey, (String)"typeKey");
            this.typeKey = typeKey;
        }

        @NotNull
        public final String getTypeKey() {
            return this.typeKey;
        }

        @Override
        @NotNull
        public String format(@NotNull Tree<EntityNode> e, @NotNull Map<Entity.Type, ? extends Style> theme) {
            String string;
            String type;
            Intrinsics.checkNotNullParameter(e, (String)"e");
            Intrinsics.checkNotNullParameter(theme, (String)"theme");
            List<Object> list = StyleKt.access$getEntity(e).get(this.typeKey);
            Entity.Type type2 = (Entity.Type)(list != null ? CollectionsKt.firstOrNull(list) : null);
            String string2 = type = type2 != null ? type2.unbox-impl() : null;
            if (type == null) {
                string = e.getValue().getLabel();
            } else {
                String string3 = type;
                Style style = theme.get(string3 != null ? Entity.Type.box-impl(string3) : null);
                Intrinsics.checkNotNull((Object)style);
                string = style.format(e, theme);
            }
            return string;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\rH\u0016\u00f8\u0001\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000f"}, d2={"Lsift/core/terminal/Style$Plain;", "Lsift/core/terminal/Style;", "styling", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "(Lcom/github/ajalt/mordant/rendering/TextStyle;)V", "getStyling", "()Lcom/github/ajalt/mordant/rendering/TextStyle;", "format", "", "e", "Lsift/core/tree/Tree;", "Lsift/core/tree/EntityNode;", "theme", "", "Lsift/core/entity/Entity$Type;", "core"})
    public static final class Plain
    implements Style {
        @NotNull
        private final TextStyle styling;

        public Plain(@NotNull TextStyle styling) {
            Intrinsics.checkNotNullParameter((Object)styling, (String)"styling");
            this.styling = styling;
        }

        @NotNull
        public final TextStyle getStyling() {
            return this.styling;
        }

        @Override
        @NotNull
        public String format(@NotNull Tree<EntityNode> e, @NotNull Map<Entity.Type, ? extends Style> theme) {
            Intrinsics.checkNotNullParameter(e, (String)"e");
            Intrinsics.checkNotNullParameter(theme, (String)"theme");
            return this.styling.invoke(e.getValue().getLabel());
        }
    }
}

