/*
 * Decompiled with CFR 0.152.
 */
package sift.core.terminal;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import sift.core.terminal.ChangeCase;
import sift.core.terminal.Deduplicate;
import sift.core.terminal.IdSequencer;
import sift.core.terminal.Replace;
import sift.core.terminal.StringEditor;
import sift.core.terminal.TextEdit;
import sift.core.terminal.TextTransformer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0086\u0002J\b\u0010\u000b\u001a\u00020\tH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lsift/core/terminal/StringEditor;", "", "transformers", "", "Lsift/core/terminal/TextTransformer;", "(Ljava/util/List;)V", "getTransformers", "()Ljava/util/List;", "invoke", "", "any", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nTextTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextTransformer.kt\nsift/core/terminal/StringEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1789#2,3:106\n*S KotlinDebug\n*F\n+ 1 TextTransformer.kt\nsift/core/terminal/StringEditor\n*L\n23#1:106,3\n*E\n"})
public final class StringEditor {
    @NotNull
    private final List<TextTransformer> transformers;

    public StringEditor(@NotNull List<? extends TextTransformer> transformers) {
        Intrinsics.checkNotNullParameter(transformers, (String)"transformers");
        this.transformers = transformers;
    }

    @NotNull
    public final List<TextTransformer> getTransformers() {
        return this.transformers;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.transformers, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)toString.1.INSTANCE, (int)24, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String invoke(@NotNull Object any) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        Iterable iterable = this.transformers;
        String initial$iv = any.toString();
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void transformer;
            TextTransformer textTransformer = (TextTransformer)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = transformer.invoke(acc);
        }
        return accumulator$iv;
    }

    private static final String toString$format(TextTransformer transformer) {
        String string;
        TextTransformer textTransformer = transformer;
        if (textTransformer instanceof Deduplicate) {
            string = "dedupe(" + ((Deduplicate)transformer).getChar() + ")";
        } else if (textTransformer instanceof IdSequencer) {
            string = "id-sequence(" + ((IdSequencer)transformer).getPattern().getPattern() + ")";
        } else if (textTransformer instanceof Replace) {
            string = "replace(" + ((Replace)transformer).getRegex().getPattern() + " -> " + ((Replace)transformer).getWith() + ")";
        } else if (textTransformer instanceof TextEdit) {
            string = "edit(" + CollectionsKt.joinToString$default((Iterable)((TextEdit)transformer).getTransformers(), null, null, null, (int)0, null, (Function1)toString.format.1.INSTANCE, (int)31, null) + ")";
        } else if (textTransformer instanceof ChangeCase) {
            string = "change-case(" + ((ChangeCase)transformer).getCase().name() + ")";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public static final /* synthetic */ String access$toString$format(TextTransformer transformer) {
        return StringEditor.toString$format(transformer);
    }
}

