/*
 * Decompiled with CFR 0.152.
 */
package sift.core.terminal;

import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyles;
import com.github.ajalt.mordant.terminal.Terminal;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import sift.core.TemplateProcessingException;
import sift.core.terminal.ExceptionHandlerKt;
import sift.core.terminal.Gruvbox;
import sift.core.terminal.ProfilerKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lsift/core/terminal/ExceptionHandler;", "", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "printStackTrace", "", "(Lcom/github/ajalt/mordant/terminal/Terminal;Z)V", "err", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "invoke", "", "e", "", "printException", "printTrace", "Lsift/core/TemplateProcessingException;", "core"})
public final class ExceptionHandler {
    @NotNull
    private final Terminal terminal;
    private final boolean printStackTrace;
    @NotNull
    private final TextStyle err;

    public ExceptionHandler(@NotNull Terminal terminal, boolean printStackTrace) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminal = terminal;
        this.printStackTrace = printStackTrace;
        this.err = Gruvbox.INSTANCE.getRed2().plus(TextStyles.bold);
    }

    public /* synthetic */ ExceptionHandler(Terminal terminal, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            terminal = new Terminal(AnsiLevel.NONE, null, null, null, null, 0, null, 126, null);
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(terminal, bl);
    }

    public final void invoke(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof TemplateProcessingException) {
            if (((TemplateProcessingException)e).getTrace() != null) {
                this.printTrace((TemplateProcessingException)e);
                this.printException(((TemplateProcessingException)e).getCause());
            } else {
                this.printException(((TemplateProcessingException)e).getCause());
                Terminal.println$default((Terminal)this.terminal, (Object)Gruvbox.INSTANCE.getFg().invoke("Error occurred during template processing: Use " + Gruvbox.INSTANCE.getLight0().plus(TextStyles.bold).invoke("--profile") + " to identify the problematic operation."), null, null, null, null, (boolean)false, (int)62, null);
            }
        } else {
            this.printException(e);
        }
        Terminal.println$default((Terminal)this.terminal, (boolean)false, (int)1, null);
        Terminal.println$default((Terminal)this.terminal, (Object)Gruvbox.INSTANCE.getFg().invoke("If you think this error is caused by a bug in sift, consider reporting it at " + TextStyles.bold.plus(TextStyles.underline).invoke("https://github.com/junkdog/sift/issues")), null, null, null, null, (boolean)false, (int)62, null);
    }

    private final void printException(Throwable e) {
        String string = this.err.invoke(Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName() + ": ");
        String string2 = e.getMessage();
        if (string2 == null) {
            string2 = "Unknown error";
        }
        Terminal.println$default((Terminal)this.terminal, (Object)(string + this.err.invoke(string2)), null, null, null, null, (boolean)false, (int)62, null);
        if (this.printStackTrace) {
            Terminal.println$default((Terminal)this.terminal, (Object)ExceptionHandlerKt.access$getStacktrace(e), null, null, null, null, (boolean)false, (int)62, null);
            Terminal.println$default((Terminal)this.terminal, (boolean)false, (int)1, null);
        } else {
            Terminal.println$default((Terminal)this.terminal, (boolean)false, (int)1, null);
            Terminal.println$default((Terminal)this.terminal, (Object)Gruvbox.INSTANCE.getFg().invoke("Run sift with the " + Gruvbox.INSTANCE.getLight0().plus(TextStyles.bold).invoke("--stacktrace") + " option to print the full stack trace."), null, null, null, null, (boolean)false, (int)62, null);
        }
    }

    private final void printTrace(TemplateProcessingException e) {
        String string = this.err.invoke("Error: ");
        String string2 = e.getCause().getMessage();
        if (string2 == null) {
            string2 = "Unknown error";
        }
        Terminal.println$default((Terminal)this.terminal, (Object)(string + this.err.invoke(string2)), null, null, null, null, (boolean)false, (int)62, null);
        Terminal.println$default((Terminal)this.terminal, (boolean)false, (int)1, null);
        Intrinsics.checkNotNull(e.getTrace(), (String)"null cannot be cast to non-null type sift.core.tree.Tree<sift.core.api.Measurement>");
        ExceptionHandlerKt.access$markError(e.getTrace());
        ProfilerKt.printProfile(this.terminal, e.getTrace());
        Terminal.println$default((Terminal)this.terminal, (boolean)false, (int)1, null);
    }

    public ExceptionHandler() {
        this(null, false, 3, null);
    }
}

