/*
 * Decompiled with CFR 0.152.
 */
package sift.core.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import sift.core.dsl.RegexType;
import sift.core.dsl.SiftType;
import sift.core.dsl.SiftTypeKt;
import sift.core.dsl.Type;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lsift/core/jackson/SiftTypeSerializer;", "", "()V", "Deserializer", "Serializer", "core"})
public final class SiftTypeSerializer {
    @NotNull
    public static final SiftTypeSerializer INSTANCE = new SiftTypeSerializer();

    private SiftTypeSerializer() {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lsift/core/jackson/SiftTypeSerializer$Deserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lsift/core/dsl/SiftType;", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "core"})
    @SourceDebugExtension(value={"SMAP\nSiftTypeSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SiftTypeSerializer.kt\nsift/core/jackson/SiftTypeSerializer$Deserializer\n+ 2 JacksonExt.kt\nsift/core/jackson/JacksonExtKt\n*L\n1#1,42:1\n6#2:43\n*S KotlinDebug\n*F\n+ 1 SiftTypeSerializer.kt\nsift/core/jackson/SiftTypeSerializer$Deserializer\n*L\n33#1:43\n*E\n"})
    public static final class Deserializer
    extends JsonDeserializer<SiftType> {
        @NotNull
        public SiftType deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
            SiftType siftType;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            JsonParser $this$readValueAs$iv = p;
            boolean $i$f$readValueAs = false;
            String raw = (String)$this$readValueAs$iv.readValueAs(String.class);
            boolean bl = false;
            if (StringsKt.startsWith$default((String)raw, (String)"!", (boolean)false, (int)2, null)) {
                siftType = Type.Companion.primitiveType$core(raw.charAt(1));
            } else if (StringsKt.startsWith$default((String)raw, (String)"r#", (boolean)false, (int)2, null)) {
                String string = raw.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                siftType = SiftTypeKt.getType(new Regex(string));
            } else {
                siftType = Type.Companion.from$core(raw);
            }
            return siftType;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lsift/core/jackson/SiftTypeSerializer$Serializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lsift/core/dsl/SiftType;", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "core"})
    public static final class Serializer
    extends JsonSerializer<SiftType> {
        public void serialize(@NotNull SiftType value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
            SiftType siftType = value;
            if (siftType instanceof RegexType) {
                gen.writeString("r#" + ((RegexType)value).getMatch$core().getPattern());
            } else if (siftType instanceof Type) {
                if (((Type)value).isPrimitive$core()) {
                    gen.writeString("!" + ((Type)value).getValue$core());
                } else {
                    gen.writeString(((Type)value).getValue$core());
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }
}

