/*
 * Decompiled with CFR 0.152.
 */
package sift.core.graphviz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.onedaybeard.collectionsby.IterableByKt;
import org.jetbrains.annotations.NotNull;
import sift.core.api.SystemModel;
import sift.core.entity.Entity;
import sift.core.graphviz.DiagramGenerator;
import sift.core.graphviz.Dot;
import sift.core.graphviz.DotKt;
import sift.core.graphviz.EdgeLayout;
import sift.core.tree.EntityNode;
import sift.core.tree.Tree;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B,\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u0011\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0016\u0010\u000b\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\u00020\t*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lsift/core/graphviz/DiagramGenerator;", "", "sm", "Lsift/core/api/SystemModel;", "edgeSplines", "Lsift/core/graphviz/EdgeLayout;", "colorLookup", "Lkotlin/Function1;", "Lsift/core/entity/Entity$Type;", "", "(Lsift/core/api/SystemModel;Lsift/core/graphviz/EdgeLayout;Lkotlin/jvm/functions/Function1;)V", "nodes", "", "Lsift/core/entity/Entity;", "color", "getColor", "(Lsift/core/entity/Entity;)Ljava/lang/String;", "build", "tree", "Lsift/core/tree/Tree;", "Lsift/core/tree/EntityNode;", "entities", "core"})
@SourceDebugExtension(value={"SMAP\nDot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Dot.kt\nsift/core/graphviz/DiagramGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,354:1\n766#2:355\n857#2,2:356\n1603#2,9:358\n1855#2:367\n1856#2:369\n1612#2:370\n766#2:371\n857#2,2:372\n766#2:374\n857#2,2:375\n1549#2:377\n1620#2,3:378\n1#3:368\n1#3:381\n*S KotlinDebug\n*F\n+ 1 Dot.kt\nsift/core/graphviz/DiagramGenerator\n*L\n54#1:355\n54#1:356,2\n55#1:358,9\n55#1:367\n55#1:369\n55#1:370\n56#1:371\n56#1:372,2\n67#1:374\n67#1:375,2\n104#1:377\n104#1:378,3\n55#1:368\n*E\n"})
public final class DiagramGenerator {
    @NotNull
    private final EdgeLayout edgeSplines;
    @NotNull
    private final Function1<Entity.Type, String> colorLookup;
    @NotNull
    private final List<Entity> nodes;

    public DiagramGenerator(@NotNull SystemModel sm, @NotNull EdgeLayout edgeSplines, @NotNull Function1<? super Entity.Type, String> colorLookup) {
        Intrinsics.checkNotNullParameter((Object)sm, (String)"sm");
        Intrinsics.checkNotNullParameter((Object)((Object)edgeSplines), (String)"edgeSplines");
        Intrinsics.checkNotNullParameter(colorLookup, (String)"colorLookup");
        this.edgeSplines = edgeSplines;
        this.colorLookup = colorLookup;
        this.nodes = IterableByKt.filterBy((Iterable)CollectionsKt.flatten((Iterable)sm.getEntitiesByType().values()), (Function1)((Function1)nodes.1.INSTANCE), (Object)((Object)Dot.node));
    }

    private final String getColor(Entity $this$color) {
        return (String)this.colorLookup.invoke((Object)Entity.Type.box-impl($this$color.getType-f7BBXPQ()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String build(@NotNull Tree<EntityNode> tree) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Object p0;
        Iterable $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        Iterable $this$filter$iv2 = tree.children();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            p0 = (Tree)element$iv$iv;
            boolean bl = false;
            if (!DotKt.access$validNode((Tree)p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv2 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        p0 = $this$forEach$iv$iv$iv.iterator();
        while (p0.hasNext()) {
            Entity it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = p0.next();
            boolean bl = false;
            Tree p02 = (Tree)element$iv$iv;
            boolean bl2 = false;
            if (DotKt.access$getEntity(p02) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv2;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Entity e = (Entity)element$iv$iv;
            boolean bl = false;
            List<Object> list = e.get("dot-type");
            if (!((list != null ? CollectionsKt.firstOrNull(list) : null) == Dot.edge)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set rootEntities = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set includedNodes2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)tree.walk(), (Function1)build.includedNodes.1.INSTANCE), (Function1)((Function1)build.includedNodes.2.INSTANCE)), (Function1)((Function1)build.includedNodes.3.INSTANCE)));
        $this$filterTo$iv$iv2 = CollectionsKt.toSet((Iterable)SetsKt.plus((Set)rootEntities, (Iterable)this.nodes));
        boolean $i$f$filter2 = false;
        void $i$f$filterTo2 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!includedNodes2.contains(DotKt.access$getNodeId(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List nodes2 = (List)destination$iv$iv2;
        String ortho = " splines=" + this.edgeSplines.name() + ",";
        return StringsKt.trimMargin$default((String)("\n            |digraph {\n            |    // setup\n            |    graph [rankdir=LR," + ortho + " truecolor=true, bgcolor=\"#00000000\", margin=0.2, nodesep=0.2, ranksep=0.2];\n            |    node [\n            |        shape=box;\n            |        fontname=\"verdana\";\n            |        fontcolor=\"#ebdbb2\";\n            |    ];\n            |    edge [\n            |        arrowhead=normal;\n            |        arrowtail=dot;\n            |        fontcolor=\"#ebdbb2\";\n            |        fontname=\"verdana\";\n            |        fontsize=11;\n            |    ];\n            |\n            |    // nodes\n            |    " + this.nodes(nodes2) + "\n            |    \n            |    // node ranks\n            |    " + DotKt.access$ranks(nodes2) + "\n            |    \n            |    // graph\n            |    " + DotKt.access$graph(tree, this.edgeSplines) + "\n            |}\n        "), null, (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String nodes(List<Entity> entities) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Entity entity = (Entity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DiagramGenerator.nodes$describe(this, (Entity)p0));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n    ", null, null, (int)0, null, null, (int)62, null);
    }

    private static final String nodes$describe(DiagramGenerator this$0, Entity e) {
        Object object;
        block3: {
            block2: {
                object = DotKt.access$getDotShape(e);
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = ",shape=" + it;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        String shape = object;
        return DotKt.access$getNodeId(e) + "[label=\"" + DotKt.access$getDotLabel(e) + "\",color=\"" + this$0.getColor(e) + "\"" + shape + "];";
    }
}

