/*
 * Decompiled with CFR 0.152.
 */
package sift.core.asm.signature;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.signature.SignatureVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0010\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eJ\b\u0010\u0012\u001a\u00020\u0001H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0001H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\b\u0010\u001a\u001a\u00020\u0001H\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u0001H\u0016J\b\u0010\u001e\u001a\u00020\u0001H\u0016J\b\u0010\u001f\u001a\u00020\u0001H\u0016J\b\u0010 \u001a\u00020\u0001H\u0016J\b\u0010!\u001a\u00020\u0001H\u0016J\b\u0010\"\u001a\u00020\u0010H\u0016J\u0010\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u0015H\u0016J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000eH\u0016R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lsift/core/asm/signature/BaseSignatureVisitor;", "Lorg/objectweb/asm/signature/SignatureVisitor;", "api", "", "sv", "(ILorg/objectweb/asm/signature/SignatureVisitor;)V", "indent", "getIndent", "()I", "setIndent", "(I)V", "getSv", "()Lorg/objectweb/asm/signature/SignatureVisitor;", "tag", "", "log", "", "s", "visitArrayType", "visitBaseType", "descriptor", "", "visitClassBound", "visitClassType", "name", "visitEnd", "visitExceptionType", "visitFormalTypeParameter", "visitInnerClassType", "visitInterface", "visitInterfaceBound", "visitParameterType", "visitReturnType", "visitSuperclass", "visitTypeArgument", "wildcard", "visitTypeVariable", "core"})
public class BaseSignatureVisitor
extends SignatureVisitor {
    @Nullable
    private final SignatureVisitor sv;
    private int indent;
    @Nullable
    private String tag;

    public BaseSignatureVisitor(int api, @Nullable SignatureVisitor sv) {
        super(api);
        this.sv = sv;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.tag = StringsKt.takeLast((String)string, (int)6);
    }

    @Nullable
    public final SignatureVisitor getSv() {
        return this.sv;
    }

    public final int getIndent() {
        return this.indent;
    }

    public final void setIndent(int n) {
        this.indent = n;
    }

    public void visitFormalTypeParameter(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        throw new IllegalStateException("visitFormalTypeParameter".toString());
    }

    @NotNull
    public SignatureVisitor visitClassBound() {
        throw new IllegalStateException("visitClassBound()".toString());
    }

    @NotNull
    public SignatureVisitor visitInterfaceBound() {
        throw new IllegalStateException("visitInterfaceBound()".toString());
    }

    @NotNull
    public SignatureVisitor visitSuperclass() {
        throw new IllegalStateException("visitSuperclass()".toString());
    }

    @NotNull
    public SignatureVisitor visitInterface() {
        throw new IllegalStateException("visitInterface()".toString());
    }

    @NotNull
    public SignatureVisitor visitParameterType() {
        throw new IllegalStateException("visitParameterType()".toString());
    }

    @NotNull
    public SignatureVisitor visitReturnType() {
        throw new IllegalStateException("visitReturnType()".toString());
    }

    @NotNull
    public SignatureVisitor visitExceptionType() {
        throw new IllegalStateException("visitExceptionType()".toString());
    }

    public void visitBaseType(char descriptor) {
        throw new IllegalStateException(("visitBaseType(descriptor=" + descriptor + ")").toString());
    }

    public void visitTypeVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        throw new IllegalStateException(("visitTypeVariable(name=" + name + ")").toString());
    }

    @NotNull
    public SignatureVisitor visitArrayType() {
        throw new IllegalStateException("visitArrayType()".toString());
    }

    public void visitClassType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        throw new IllegalStateException(("visitClassType(name=" + name + ")").toString());
    }

    public void visitInnerClassType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        throw new IllegalStateException(("visitInnerClassType(name=" + name + ")").toString());
    }

    public void visitTypeArgument() {
        throw new IllegalStateException("visitTypeArgument()".toString());
    }

    @NotNull
    public SignatureVisitor visitTypeArgument(char wildcard) {
        throw new IllegalStateException(("visitTypeArgument(wildcard=" + wildcard + ")").toString());
    }

    public void visitEnd() {
        block0: {
            SignatureVisitor signatureVisitor = this.sv;
            if (signatureVisitor == null) break block0;
            signatureVisitor.visitEnd();
        }
    }

    public final void log(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String t = this.tag + " ";
        String prefix = StringsKt.padEnd$default((String)"", (int)(Math.max(0, this.indent) * 4), (char)'\u0000', (int)2, null);
        System.out.println((Object)(t + prefix + s));
    }
}

