/*
 * Decompiled with CFR 0.152.
 */
package sift.core.asm;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.onedaybeard.collectionsby.IterableByKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;
import sift.core.asm.AsmClassNodeResolversKt;
import sift.core.asm.AsmKtKt;
import sift.core.asm.MavenArtifact;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u00052\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a(\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0002\u001a(\u0010\f\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u00052\u0006\u0010\r\u001a\u00020\u000e2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0011"}, d2={"asDirectory", "Ljava/net/URI;", "getAsDirectory", "(Ljava/net/URI;)Ljava/net/URI;", "classNodesOf", "", "Lorg/objectweb/asm/tree/ClassNode;", "Lsift/core/element/AsmClassNode;", "uri", "artifact", "Lsift/core/asm/MavenArtifact;", "mavenRepositories", "resolveClassNodes", "source", "", "resolvePath", "Ljava/nio/file/Path;", "core"})
@SourceDebugExtension(value={"SMAP\nAsmClassNodeResolvers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsmClassNodeResolvers.kt\nsift/core/asm/AsmClassNodeResolversKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1#2:109\n1373#3:110\n1461#3,5:111\n1549#3:116\n1620#3,3:117\n1549#3:120\n1620#3,3:121\n1549#3:124\n1620#3,3:125\n1549#3:128\n1620#3,3:129\n*S KotlinDebug\n*F\n+ 1 AsmClassNodeResolvers.kt\nsift/core/asm/AsmClassNodeResolversKt\n*L\n44#1:110\n44#1:111,5\n46#1:116\n46#1:117,3\n47#1:120\n47#1:121,3\n67#1:124\n67#1:125,3\n68#1:128\n68#1:129,3\n*E\n"})
public final class AsmClassNodeResolversKt {
    @NotNull
    public static final List<ClassNode> resolveClassNodes(@NotNull String source, @NotNull List<URI> mavenRepositories) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(mavenRepositories, (String)"mavenRepositories");
        CharSequence charSequence = source;
        boolean isUri = new Regex("^[a-z-]{2,}:").containsMatchIn(charSequence);
        MavenArtifact mavenArtifact = MavenArtifact.Companion.parse(source);
        MavenArtifact mavenArtifact2 = mavenArtifact;
        return mavenArtifact2 != null ? AsmClassNodeResolversKt.classNodesOf(mavenArtifact2, mavenRepositories) : (isUri ? AsmClassNodeResolversKt.classNodesOf(new URI(source)) : AsmKtKt.classNodes(AsmClassNodeResolversKt.resolvePath(source)));
    }

    public static /* synthetic */ List resolveClassNodes$default(String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return AsmClassNodeResolversKt.resolveClassNodes(string, list);
    }

    private static final Path resolvePath(String source) {
        Object object = new String[]{"target/classes"};
        Object p0 = object = Path.of(source, object);
        boolean $i$f$resolvePath$exists = false;
        boolean bl = false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        Object object2 = Files.exists((Path)p0, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? object : null;
        if (object2 == null) {
            Path path;
            Path p02 = path = Path.of(source, new String[0]);
            boolean $i$f$resolvePath$exists$0 = false;
            boolean bl2 = false;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            object2 = Files.exists(p02, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) ? path : null;
            if (object2 == null) {
                throw new IllegalStateException(("path does not exist: " + source).toString());
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final List<ClassNode> classNodesOf(URI uri) {
        Object object;
        Path f2 = Files.createTempFile("sift_download", ".jar", new FileAttribute[0]);
        try {
            List list;
            object = uri.toURL().openStream();
            Throwable throwable = null;
            try {
                Object p0 = (InputStream)object;
                boolean bl = false;
                p0 = ((InputStream)p0).readAllBytes();
            }
            catch (Throwable p0) {
                throwable = p0;
                throw p0;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            Object p0 = p0;
            boolean $i$f$classNodesOf$writeBytes = false;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)f2, (String)"f::writeBytes");
            OpenOption[] openOptionArray = new OpenOption[]{};
            Files.write(f2, (byte[])p0, Arrays.copyOf(openOptionArray, openOptionArray.length));
            object = FileSystems.newFileSystem(f2);
            throwable = null;
            try {
                byte[] p02;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Object list$iv$iv;
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                FileSystem fs = (FileSystem)object;
                boolean bl2 = false;
                Iterable<Path> iterable = fs.getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"fs.rootDirectories");
                Iterable<Path> iterable2 = iterable;
                boolean $i$f$flatMapSequence = false;
                void var8_15 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapSequenceTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    Path root2 = (Path)element$iv$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)root2, (String)"root");
                    list$iv$iv = PathsKt.walk((Path)root2, (PathWalkOption[])new PathWalkOption[0]);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
                }
                $this$flatMap$iv = IterableByKt.filterBy((Iterable)((List)destination$iv$iv), (Function1)((Function1)classNodesOf.3.2.INSTANCE), (Object)"class");
                boolean $i$f$map = false;
                $this$flatMapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    list$iv$iv = (Path)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    byte[] byArray = Files.readAllBytes((Path)p02);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(this)");
                    collection.add(byArray);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    p02 = (byte[])item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl5 = false;
                    collection.add(AsmKtKt.classNode(p02));
                }
                list = (List)destination$iv$iv;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = list;
        }
        catch (Throwable throwable) {
            Intrinsics.checkNotNullExpressionValue((Object)f2, (String)"f");
            Files.deleteIfExists(f2);
            throw throwable;
        }
        Files.deleteIfExists(f2);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ClassNode> classNodesOf(MavenArtifact artifact, List<URI> mavenRepositories) {
        URI p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = mavenRepositories;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            URI uRI = (URI)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(AsmClassNodeResolversKt.getAsDirectory(p0));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (URI)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.resolve(artifact.getRepoPath()));
        }
        List customLocations = (List)destination$iv$iv;
        List list = (List)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)customLocations, (Object)artifact.getMavenLocal()), (Object)artifact.getMavenCentral())), (Function1)classNodesOf.4.INSTANCE));
        if (list == null) {
            throw new IllegalStateException(("failed downloading maven artifact: " + artifact).toString());
        }
        return list;
    }

    private static final URI getAsDirectory(URI $this$asDirectory) {
        String string = $this$asDirectory.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
        return StringsKt.endsWith$default((String)string, (String)"/", (boolean)false, (int)2, null) ? $this$asDirectory : new URI($this$asDirectory + "/");
    }

    private static final List<ClassNode> classNodesOf$tryDownload(URI uri) {
        List<ClassNode> list;
        try {
            list = AsmClassNodeResolversKt.classNodesOf(uri);
        }
        catch (Exception e) {
            list = null;
        }
        return list;
    }

    public static final /* synthetic */ List access$classNodesOf$tryDownload(URI uri) {
        return AsmClassNodeResolversKt.classNodesOf$tryDownload(uri);
    }
}

