/*
 * Decompiled with CFR 0.152.
 */
package sift.core.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sift.core.api.Context;
import sift.core.api.SystemModel;
import sift.core.api.TemplateProcessor;
import sift.core.jackson.SerializationModuleKt;
import sift.core.template.SystemModelTemplate;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a&\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u000f"}, d2={"loadSystemModel", "Lsift/core/api/SystemModel;", "file", "Ljava/io/File;", "resolveSystemModel", "path", "", "template", "Lsift/core/template/SystemModelTemplate;", "mavenRepostiories", "", "Ljava/net/URI;", "saveSystemModel", "", "result", "core"})
@SourceDebugExtension(value={"SMAP\nSystemModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemModel.kt\nsift/core/api/SystemModelKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,73:1\n1#2:74\n48#3:75\n43#3:76\n*S KotlinDebug\n*F\n+ 1 SystemModel.kt\nsift/core/api/SystemModelKt\n*L\n52#1:75\n52#1:76\n*E\n"})
public final class SystemModelKt {
    public static final void saveSystemModel(@NotNull SystemModel result, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String p0 = ExtensionsKt.jacksonObjectMapper().registerModule((Module)SerializationModuleKt.serializationModule()).writeValueAsString((Object)result);
        boolean bl = false;
        FilesKt.writeText$default((File)file, (String)p0, null, (int)2, null);
    }

    @NotNull
    public static final SystemModel loadSystemModel(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().registerModule((Module)SerializationModuleKt.serializationModule());
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"jacksonObjectMapper()\n  \u2026le(serializationModule())");
        ObjectMapper $this$readValue$iv = objectMapper;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        return (SystemModel)$this$readValue$iv.readValue(file, (TypeReference)new TypeReference<SystemModel>(){});
    }

    @NotNull
    public static final SystemModel resolveSystemModel(@NotNull String path, @Nullable SystemModelTemplate template, @NotNull List<URI> mavenRepostiories) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(mavenRepostiories, (String)"mavenRepostiories");
        if (StringsKt.endsWith$default((String)path, (String)"json", (boolean)false, (int)2, null)) {
            File f2 = new File(path);
            if (!f2.exists()) {
                throw new FileNotFoundException(path);
            }
            return SystemModelKt.loadSystemModel(f2);
        }
        if (template == null) {
            boolean bl = false;
            String string = "unable to load " + path + " as no template is specified";
            throw new IllegalArgumentException(string.toString());
        }
        Context p0 = TemplateProcessor.process$core$default(TemplateProcessor.Companion.from(path, mavenRepostiories), template.template(), false, null, 4, null);
        boolean bl = false;
        return new SystemModel(p0);
    }
}

