/*
 * Decompiled with CFR 0.152.
 */
package com.ansj.vec.util;

import com.ansj.vec.Word2VEC;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WordKmeans {
    private HashMap<String, float[]> wordMap = null;
    private int iter;
    private Classes[] cArray = null;

    public static void main(String[] args) throws IOException {
        Word2VEC vec = new Word2VEC();
        vec.loadGoogleModel("vectors.bin");
        System.out.println("load model ok!");
        WordKmeans wordKmeans = new WordKmeans(vec.getWordMap(), 50, 50);
        Classes[] explain = wordKmeans.explain();
        int i = 0;
        while (i < explain.length) {
            System.out.println("--------" + i + "---------");
            System.out.println(explain[i].getTop(10));
            ++i;
        }
    }

    public WordKmeans(HashMap<String, float[]> wordMap, int clcn, int iter) {
        this.wordMap = wordMap;
        this.iter = iter;
        this.cArray = new Classes[clcn];
    }

    public Classes[] explain() {
        Iterator<Map.Entry<String, float[]>> iterator = this.wordMap.entrySet().iterator();
        int i = 0;
        while (i < this.cArray.length) {
            Map.Entry<String, float[]> next = iterator.next();
            this.cArray[i] = new Classes(i, next.getValue());
            ++i;
        }
        i = 0;
        while (i < this.iter) {
            Classes classes;
            Classes[] classesArray = this.cArray;
            int n = this.cArray.length;
            int n2 = 0;
            while (n2 < n) {
                classes = classesArray[n2];
                classes.clean();
                ++n2;
            }
            for (Map.Entry<String, float[]> next : this.wordMap.entrySet()) {
                double miniScore = Double.MAX_VALUE;
                int classesId = 0;
                Classes[] classesArray2 = this.cArray;
                int n3 = this.cArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Classes classes2 = classesArray2[n4];
                    double tempScore = classes2.distance(next.getValue());
                    if (miniScore > tempScore) {
                        miniScore = tempScore;
                        classesId = classes2.id;
                    }
                    ++n4;
                }
                this.cArray[classesId].putValue(next.getKey(), miniScore);
            }
            classesArray = this.cArray;
            n = this.cArray.length;
            n2 = 0;
            while (n2 < n) {
                classes = classesArray[n2];
                classes.updateCenter(this.wordMap);
                ++n2;
            }
            System.out.println("iter " + i + " ok!");
            ++i;
        }
        return this.cArray;
    }

    public static class Classes {
        private int id;
        private float[] center;
        Map<String, Double> values = new HashMap<String, Double>();

        public Classes(int id, float[] center) {
            this.id = id;
            this.center = (float[])center.clone();
        }

        public double distance(float[] value) {
            double sum = 0.0;
            int i = 0;
            while (i < value.length) {
                sum += (double)((this.center[i] - value[i]) * (this.center[i] - value[i]));
                ++i;
            }
            return sum;
        }

        public void putValue(String word, double score) {
            this.values.put(word, score);
        }

        public void updateCenter(HashMap<String, float[]> wordMap) {
            int i = 0;
            while (i < this.center.length) {
                this.center[i] = 0.0f;
                ++i;
            }
            float[] value = null;
            for (String keyWord : this.values.keySet()) {
                value = wordMap.get(keyWord);
                int i2 = 0;
                while (i2 < value.length) {
                    int n = i2;
                    this.center[n] = this.center[n] + value[i2];
                    ++i2;
                }
            }
            int i3 = 0;
            while (i3 < this.center.length) {
                this.center[i3] = this.center[i3] / (float)this.values.size();
                ++i3;
            }
        }

        public void clean() {
            this.values.clear();
        }

        public List<Map.Entry<String, Double>> getTop(int n) {
            ArrayList<Map.Entry<String, Double>> arrayList = new ArrayList<Map.Entry<String, Double>>(this.values.entrySet());
            Collections.sort(arrayList, new Comparator<Map.Entry<String, Double>>(){

                @Override
                public int compare(Map.Entry<String, Double> o1, Map.Entry<String, Double> o2) {
                    return o1.getValue() > o2.getValue() ? 1 : -1;
                }
            });
            int min = Math.min(n, arrayList.size() - 1);
            if (min <= 1) {
                return Collections.emptyList();
            }
            return arrayList.subList(0, min);
        }
    }
}

