/*
 * Decompiled with CFR 0.152.
 */
package com.ansj.vec.util;

import com.ansj.vec.domain.HiddenNeuron;
import com.ansj.vec.domain.Neuron;
import java.util.Collection;
import java.util.TreeSet;

public class Haffman {
    private int layerSize;
    private TreeSet<Neuron> set = new TreeSet();

    public Haffman(int layerSize) {
        this.layerSize = layerSize;
    }

    public void make(Collection<Neuron> neurons) {
        this.set.addAll(neurons);
        while (this.set.size() > 1) {
            this.merger();
        }
    }

    private void merger() {
        HiddenNeuron hn = new HiddenNeuron(this.layerSize);
        Neuron min1 = this.set.pollFirst();
        Neuron min2 = this.set.pollFirst();
        hn.category = min2.category;
        hn.freq = min1.freq + min2.freq;
        min1.parent = hn;
        min2.parent = hn;
        min1.code = 0;
        min2.code = 1;
        this.set.add(hn);
    }
}

