/*
 * Decompiled with CFR 0.152.
 */
package com.ansj.vec.domain;

import com.ansj.vec.domain.Neuron;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class WordNeuron
extends Neuron {
    public String name;
    public double[] syn0 = null;
    public List<Neuron> neurons = null;
    public int[] codeArr = null;

    public List<Neuron> makeNeurons() {
        if (this.neurons != null) {
            return this.neurons;
        }
        Neuron neuron = this;
        this.neurons = new LinkedList<Neuron>();
        while ((neuron = neuron.parent) != null) {
            this.neurons.add(neuron);
        }
        Collections.reverse(this.neurons);
        this.codeArr = new int[this.neurons.size()];
        int i = 1;
        while (i < this.neurons.size()) {
            this.codeArr[i - 1] = this.neurons.get((int)i).code;
            ++i;
        }
        this.codeArr[this.codeArr.length - 1] = this.code;
        return this.neurons;
    }

    public WordNeuron(String name, double freq, int layerSize) {
        this.name = name;
        this.freq = freq;
        this.syn0 = new double[layerSize];
        Random random = new Random();
        int i = 0;
        while (i < this.syn0.length) {
            this.syn0[i] = (random.nextDouble() - 0.5) / (double)layerSize;
            ++i;
        }
    }

    public WordNeuron(String name, double freq, int category, int layerSize) {
        this.name = name;
        this.freq = freq;
        this.syn0 = new double[layerSize];
        this.category = category;
        Random random = new Random();
        int i = 0;
        while (i < this.syn0.length) {
            this.syn0[i] = (random.nextDouble() - 0.5) / (double)layerSize;
            ++i;
        }
    }
}

