/*
 * Decompiled with CFR 0.152.
 */
package com.ansj.vec;

import com.ansj.vec.domain.HiddenNeuron;
import com.ansj.vec.domain.Neuron;
import com.ansj.vec.domain.WordNeuron;
import com.ansj.vec.util.Haffman;
import com.ansj.vec.util.MapCount;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Learn {
    private Map<String, Neuron> wordMap = new HashMap<String, Neuron>();
    private int layerSize = 200;
    private int window = 5;
    private double sample = 0.001;
    private double alpha;
    private double startingAlpha = this.alpha = 0.025;
    public int EXP_TABLE_SIZE = 1000;
    private Boolean isCbow = false;
    private double[] expTable = new double[this.EXP_TABLE_SIZE];
    private int trainWordsCount = 0;
    private int MAX_EXP = 6;

    public Learn(Boolean isCbow, Integer layerSize, Integer window, Double alpha, Double sample) {
        this.createExpTable();
        if (isCbow != null) {
            this.isCbow = isCbow;
        }
        if (layerSize != null) {
            this.layerSize = layerSize;
        }
        if (window != null) {
            this.window = window;
        }
        if (alpha != null) {
            this.alpha = alpha;
        }
        if (sample != null) {
            this.sample = sample;
        }
    }

    public Learn() {
        this.createExpTable();
    }

    private void trainModel(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String temp = null;
            long nextRandom = 5L;
            int wordCount = 0;
            int lastWordCount = 0;
            int wordCountActual = 0;
            while ((temp = br.readLine()) != null) {
                if (wordCount - lastWordCount > 10000) {
                    System.out.println("alpha:" + this.alpha + "\tProgress: " + (int)((double)wordCountActual / (double)(this.trainWordsCount + 1) * 100.0) + "%");
                    lastWordCount = wordCount;
                    this.alpha = this.startingAlpha * (1.0 - (double)(wordCountActual += wordCount - lastWordCount) / (double)(this.trainWordsCount + 1));
                    if (this.alpha < this.startingAlpha * 1.0E-4) {
                        this.alpha = this.startingAlpha * 1.0E-4;
                    }
                }
                String[] strs = temp.split(" ");
                wordCount += strs.length;
                ArrayList<WordNeuron> sentence = new ArrayList<WordNeuron>();
                int i = 0;
                while (i < strs.length) {
                    double ran;
                    Neuron entry = this.wordMap.get(strs[i]);
                    if (!(entry == null || this.sample > 0.0 && (ran = (Math.sqrt(entry.freq / (this.sample * (double)this.trainWordsCount)) + 1.0) * (this.sample * (double)this.trainWordsCount) / entry.freq) < (double)((nextRandom = nextRandom * 25214903917L + 11L) & 0xFFFFL) / 65536.0)) {
                        sentence.add((WordNeuron)entry);
                    }
                    ++i;
                }
                int index = 0;
                while (index < sentence.size()) {
                    nextRandom = nextRandom * 25214903917L + 11L;
                    if (this.isCbow.booleanValue()) {
                        this.cbowGram(index, sentence, (int)nextRandom % this.window);
                    } else {
                        this.skipGram(index, sentence, (int)nextRandom % this.window);
                    }
                    ++index;
                }
            }
            System.out.println("Vocab size: " + this.wordMap.size());
            System.out.println("Words in train file: " + this.trainWordsCount);
            System.out.println("sucess train over!");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void skipGram(int index, List<WordNeuron> sentence, int b) {
        WordNeuron word = sentence.get(index);
        int c = 0;
        int a = b;
        while (a < this.window * 2 + 1 - b) {
            if (a != this.window && (c = index - this.window + a) >= 0 && c < sentence.size()) {
                double[] neu1e = new double[this.layerSize];
                List<Neuron> neurons = word.neurons;
                WordNeuron we = sentence.get(c);
                int i = 0;
                while (i < neurons.size()) {
                    HiddenNeuron out = (HiddenNeuron)neurons.get(i);
                    double f = 0.0;
                    int j = 0;
                    while (j < this.layerSize) {
                        f += we.syn0[j] * out.syn1[j];
                        ++j;
                    }
                    if (!(f <= (double)(-this.MAX_EXP)) && !(f >= (double)this.MAX_EXP)) {
                        f = (f + (double)this.MAX_EXP) * (double)(this.EXP_TABLE_SIZE / this.MAX_EXP / 2);
                        f = this.expTable[(int)f];
                        double g = ((double)(1 - word.codeArr[i]) - f) * this.alpha;
                        c = 0;
                        while (c < this.layerSize) {
                            int n = c;
                            neu1e[n] = neu1e[n] + g * out.syn1[c];
                            ++c;
                        }
                        c = 0;
                        while (c < this.layerSize) {
                            int n = c;
                            out.syn1[n] = out.syn1[n] + g * we.syn0[c];
                            ++c;
                        }
                    }
                    ++i;
                }
                int j = 0;
                while (j < this.layerSize) {
                    int n = j;
                    we.syn0[n] = we.syn0[n] + neu1e[j];
                    ++j;
                }
            }
            ++a;
        }
    }

    private void cbowGram(int index, List<WordNeuron> sentence, int b) {
        WordNeuron last_word;
        WordNeuron word = sentence.get(index);
        int c = 0;
        List<Neuron> neurons = word.neurons;
        double[] neu1e = new double[this.layerSize];
        double[] neu1 = new double[this.layerSize];
        int a = b;
        while (a < this.window * 2 + 1 - b) {
            if (a != this.window && (c = index - this.window + a) >= 0 && c < sentence.size() && (last_word = sentence.get(c)) != null) {
                c = 0;
                while (c < this.layerSize) {
                    int n = c;
                    neu1[n] = neu1[n] + last_word.syn0[c];
                    ++c;
                }
            }
            ++a;
        }
        int d = 0;
        while (d < neurons.size()) {
            HiddenNeuron out = (HiddenNeuron)neurons.get(d);
            double f = 0.0;
            c = 0;
            while (c < this.layerSize) {
                f += neu1[c] * out.syn1[c];
                ++c;
            }
            if (!(f <= (double)(-this.MAX_EXP)) && !(f >= (double)this.MAX_EXP)) {
                f = this.expTable[(int)((f + (double)this.MAX_EXP) * (double)(this.EXP_TABLE_SIZE / this.MAX_EXP / 2))];
                double g = f * (1.0 - f) * ((double)word.codeArr[d] - f) * this.alpha;
                c = 0;
                while (c < this.layerSize) {
                    int n = c;
                    neu1e[n] = neu1e[n] + g * out.syn1[c];
                    ++c;
                }
                c = 0;
                while (c < this.layerSize) {
                    int n = c;
                    out.syn1[n] = out.syn1[n] + g * neu1[c];
                    ++c;
                }
            }
            ++d;
        }
        a = b;
        while (a < this.window * 2 + 1 - b) {
            if (a != this.window && (c = index - this.window + a) >= 0 && c < sentence.size() && (last_word = sentence.get(c)) != null) {
                c = 0;
                while (c < this.layerSize) {
                    int n = c;
                    last_word.syn0[n] = last_word.syn0[n] + neu1e[c];
                    ++c;
                }
            }
            ++a;
        }
    }

    private void readVocab(File file) throws IOException {
        MapCount<String> mc = new MapCount<String>();
        Throwable throwable = null;
        Iterator iterator = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String temp = null;
            while ((temp = br.readLine()) != null) {
                String[] split = temp.split(" ");
                this.trainWordsCount += split.length;
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    mc.add(string);
                    ++n2;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        for (Map.Entry element : mc.get().entrySet()) {
            this.wordMap.put((String)element.getKey(), new WordNeuron((String)element.getKey(), (double)element.getValue().intValue() / (double)mc.size(), this.layerSize));
        }
    }

    private void readVocabWithSupervised(File[] files) throws IOException {
        int category = 0;
        while (category < files.length) {
            MapCount<String> mc = new MapCount<String>();
            Throwable throwable = null;
            Iterator iterator = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(files[category])));){
                String temp = null;
                while ((temp = br.readLine()) != null) {
                    String[] split = temp.split(" ");
                    this.trainWordsCount += split.length;
                    String[] stringArray = split;
                    int n = split.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        mc.add(string);
                        ++n2;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            for (Map.Entry element : mc.get().entrySet()) {
                double tarFreq = (double)element.getValue().intValue() / (double)mc.size();
                if (this.wordMap.get(element.getKey()) != null) {
                    double srcFreq = this.wordMap.get(element.getKey()).freq;
                    if (srcFreq >= tarFreq) continue;
                    Neuron wordNeuron = this.wordMap.get(element.getKey());
                    wordNeuron.category = category;
                    wordNeuron.freq = tarFreq;
                    continue;
                }
                this.wordMap.put((String)element.getKey(), new WordNeuron((String)element.getKey(), tarFreq, category, this.layerSize));
            }
            ++category;
        }
    }

    private void createExpTable() {
        int i = 0;
        while (i < this.EXP_TABLE_SIZE) {
            this.expTable[i] = Math.exp(((double)i / (double)this.EXP_TABLE_SIZE * 2.0 - 1.0) * (double)this.MAX_EXP);
            this.expTable[i] = this.expTable[i] / (this.expTable[i] + 1.0);
            ++i;
        }
    }

    public void learnFile(File file) throws IOException {
        this.readVocab(file);
        new Haffman(this.layerSize).make(this.wordMap.values());
        for (Neuron neuron : this.wordMap.values()) {
            ((WordNeuron)neuron).makeNeurons();
        }
        this.trainModel(file);
    }

    public void learnFile(File summaryFile, File[] classifiedFiles) throws IOException {
        this.readVocabWithSupervised(classifiedFiles);
        new Haffman(this.layerSize).make(this.wordMap.values());
        for (Neuron neuron : this.wordMap.values()) {
            ((WordNeuron)neuron).makeNeurons();
        }
        this.trainModel(summaryFile);
    }

    public void saveModel(File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
                dataOutputStream.writeInt(this.wordMap.size());
                dataOutputStream.writeInt(this.layerSize);
                double[] syn0 = null;
                for (Map.Entry<String, Neuron> element : this.wordMap.entrySet()) {
                    dataOutputStream.writeUTF(element.getKey());
                    double[] dArray = syn0 = ((WordNeuron)element.getValue()).syn0;
                    int n = syn0.length;
                    int n2 = 0;
                    while (n2 < n) {
                        double d = dArray[n2];
                        dataOutputStream.writeFloat(Double.valueOf(d).floatValue());
                        ++n2;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getLayerSize() {
        return this.layerSize;
    }

    public void setLayerSize(int layerSize) {
        this.layerSize = layerSize;
    }

    public int getWindow() {
        return this.window;
    }

    public void setWindow(int window) {
        this.window = window;
    }

    public double getSample() {
        return this.sample;
    }

    public void setSample(double sample) {
        this.sample = sample;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
        this.startingAlpha = alpha;
    }

    public Boolean getIsCbow() {
        return this.isCbow;
    }

    public void setIsCbow(Boolean isCbow) {
        this.isCbow = isCbow;
    }

    public static void main(String[] args) throws IOException {
        Learn learn = new Learn();
        long start = System.currentTimeMillis();
        learn.learnFile(new File("library/xh.txt"));
        System.out.println("use time " + (System.currentTimeMillis() - start));
        learn.saveModel(new File("library/javaVector"));
    }
}

